/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.business.edoc.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.business.edoc.dao.EdocActButtonDao;
import com.ustc.business.edoc.dao.EdocButtonsDao;
import com.ustc.business.edoc.entity.EdocActButton;
import com.ustc.business.edoc.entity.EdocButtons;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class EdocActButtonService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private EdocActButtonDao edocactbuttonDao;
    @Autowired
    private EdocButtonsDao edocButtonsDao;

    public EdocActButton findEdocActButton(Long id) {
        EdocActButton entity = (EdocActButton)this.edocactbuttonDao.findById(id).get();
        return entity;
    }

    public List<EdocActButton> findByActIdAndIsEnable(Long actId, String isEnable) {
        List<EdocActButton> list = this.edocactbuttonDao.findByActIdAndIsEnableOrderByDisplayNo(actId, isEnable);
        ArrayList<EdocActButton> newlist = new ArrayList<EdocActButton>();
        for (EdocActButton e : list) {
            EdocButtons btn = this.edocButtonsDao.findById(e.getButtonId()).get();
            if (!"Y".equals(btn.getIsUse())) continue;
            e.setButton(btn);
            newlist.add(e);
        }
        return newlist;
    }

    public void saveEdocActButton(EdocActButton entity) {
        this.edocactbuttonDao.save(entity);
    }

    public void delEdocActButton(Long id) {
        EdocActButton entity = (EdocActButton)this.edocactbuttonDao.findById(id).get();
        this.edocactbuttonDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("business.edoc.EdocActButton.select", params, PageRequest.of((int)page, (int)rows));
    }

    public List<EdocActButton> findByActIdAndIsEnableAndButtonType(Long actId, String isUseY, String buttonType) {
        List<EdocActButton> list = this.edocactbuttonDao.findByActIdAndIsEnableAndButtonTypeOrderByDisplayNo(actId, isUseY, buttonType);
        for (EdocActButton e : list) {
            e.setButton(this.edocButtonsDao.findById(e.getButtonId()).get());
        }
        return list;
    }
}

