/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.dao.GmInfoTypeDao;
import com.ustc.base.entity.GmInfoType;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GmInfoTypeService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private GmInfoTypeDao gminfotypeDao;

    public GmInfoType findGmInfoType(Long id) {
        GmInfoType entity = (GmInfoType)this.gminfotypeDao.findById(id).get();
        return entity;
    }

    public GmInfoType saveGmInfoType(GmInfoType entity) {
        entity = (GmInfoType)this.gminfotypeDao.save(entity);
        return entity;
    }

    public void delGmInfoType(Long id) {
        GmInfoType entity = (GmInfoType)this.gminfotypeDao.findById(id).get();
        entity.setIsUse("N");
        this.gminfotypeDao.save(entity);
    }

    public Object PageAll(String type, Long accountid, Long org, Long dept, String search, int page, int rows, String sort, String order, Long orgId, String orgIdVal) {
        Subject currentUser;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)type)) {
            params.put("type", type);
            params.put("accountid", accountid);
            params.put("org", org);
            params.put("dept", dept);
        }
        if (accountid != null) {
            params.put("accountid", accountid);
            params.put("org", org);
        }
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (orgId != null) {
            params.put("orgId", orgId);
        }
        if (!StringUtils.isEmpty((String)orgIdVal)) {
            params.put("orgIdVal", orgIdVal);
        }
        if ((currentUser = SecurityUtils.getSubject()).isPermitted("admin:manage")) {
            params.put("isAdmin", "Y");
        }
        return this.bSqlHelper.serachPage("base.GmInfoType.select", params, PageRequest.of((int)page, (int)rows));
    }

    public List<ComBoxTreeNode> infoTypeTree() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.GmInfoType.infoTypeTree", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<Map<String, Object>> getInfoTypeListForSearch(Long orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        Subject currentUser = SecurityUtils.getSubject();
        if (currentUser.isPermitted("admin:manage")) {
            params.put("isAdmin", "Y");
        }
        return this.bSqlHelper.getMapList("base.GmInfoType.getInfoTypeListForSearch", params);
    }

    public List<Map<String, Object>> getInfoTypeList(String typeId, Long accountid, Long org, Long dept) {
        Subject currentUser;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountid);
        params.put("org", org);
        params.put("dept", dept);
        if (!StringUtils.isEmpty((String)typeId)) {
            params.put("typeId", typeId);
        }
        if ((currentUser = SecurityUtils.getSubject()).isPermitted("admin:manage")) {
            params.put("isAdmin", "Y");
        }
        return this.bSqlHelper.getMapList("base.GmInfoType.getInfoTypeList", params);
    }
}

