/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.GmInfoReadDao;
import com.ustc.base.entity.GmInfoRead;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GmInfoReadService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private GmInfoReadDao gminforeadDao;

    public GmInfoRead findGmInfoRead(Long id) {
        GmInfoRead entity = (GmInfoRead)this.gminforeadDao.findById(id).get();
        return entity;
    }

    public void saveGmInfoRead(GmInfoRead entity) {
        this.gminforeadDao.save(entity);
    }

    public void delGmInfoRead(Long id) {
        GmInfoRead entity = (GmInfoRead)this.gminforeadDao.findById(id).get();
        this.gminforeadDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("base.GmInfoRead.select", params, PageRequest.of((int)page, (int)rows));
    }

    public List<Map<String, Object>> getReadList(Long infoId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("infoId", infoId);
        return this.bSqlHelper.getMapList("base.GmInfoRead.getReadList", params);
    }

    public List<Map<String, Object>> getDeptList(Long infoId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("infoId", infoId);
        return this.bSqlHelper.getMapList("base.GmInfoRead.getDeptList", params);
    }

    public List<Map<String, Object>> getEmpList(Long deptId, Long infoId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("infoId", infoId);
        params.put("deptId", deptId);
        return this.bSqlHelper.getMapList("base.GmInfoRead.getEmpList", params);
    }

    public Integer findReadCountByinfoId(Long infoId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (infoId == null) {
            return 0;
        }
        params.put("infoId", infoId);
        return this.bSqlHelper.getIntValue("base.GmInfoRead.findReadCountByinfoId", params);
    }

    public Integer findConnectFlowCount(Long infoId, String bizCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (infoId == null) {
            return 0;
        }
        params.put("infoId", infoId);
        if (StringUtils.isEmpty((String)bizCode)) {
            return 0;
        }
        params.put("bizCode", bizCode);
        return this.bSqlHelper.getIntValue("base.GmInfoRead.findConnectFlowCount", params);
    }
}

