/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.alibaba.fastjson.JSON;
import com.ustc.base.common.spring.entity.Code;
import com.ustc.base.common.spring.entity.MaxIdHelper;
import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.gen.util.FreeMarkerUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
@Service(value="CreateCodeService")
public class CreateCodeService {
    private static final Logger logger = LoggerFactory.getLogger(CreateCodeService.class);
    @Autowired
    private BeetlSQLHelper bsh;
    @Autowired
    private NativeSqlHelper sqlHelper;
    private ThreadLocal<Map<String, Long>> LastIDKeeper = new ThreadLocal();

    public void prepareBatchCode() {
        this.LastIDKeeper.remove();
        this.LastIDKeeper.set(new HashMap());
    }

    public void endBatchCode() {
        this.LastIDKeeper.remove();
    }

    public void prepareInsert(List<Object> entityList) {
        this.prepareBatchCode();
        for (Object entity : entityList) {
            this.createCode(entity);
        }
        this.endBatchCode();
    }

    public void createCode(Object entity) {
        Class<?> cls = entity.getClass();
        try {
            Method[] methods;
            String tableName = cls.getAnnotation(Table.class).name();
            for (Method method : methods = cls.getMethods()) {
                String code;
                if (!method.isAnnotationPresent(Code.class) || !StringUtils.isEmpty((CharSequence)(code = (String)method.invoke(entity, new Object[0])))) continue;
                Code codeAnno = method.getAnnotation(Code.class);
                Column columnAnno = method.getAnnotation(Column.class);
                String columnName = columnAnno.name();
                if (!StringUtils.isEmpty((CharSequence)columnName)) {
                    columnName = columnName.toUpperCase();
                }
                String generatedCode = this.createCode(tableName, columnName, codeAnno, entity);
                Method setMethod = cls.getMethod("s" + method.getName().substring(1), String.class);
                setMethod.invoke(entity, generatedCode);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u7f16\u7801\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u4fdd\u5b58\u5904\u7406\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public String createCode(String tableName, String columnName, Code codeAnno, Object entity) {
        Map paras = (Map)JSON.parseObject((String)JSON.toJSONString((Object)entity), Map.class);
        LoginUser user = SysUtils.getLoginUser();
        int snLength = codeAnno.serialLength();
        paras.put("tableName", tableName);
        paras.put("codeName", columnName);
        paras.put("loginuser", user);
        String prefixCode = FreeMarkerUtil.instance().genString(codeAnno.prefix(), paras);
        String suffixCode = FreeMarkerUtil.instance().genString(codeAnno.suffix(), paras);
        return this.createCode(tableName, columnName, snLength, prefixCode, suffixCode, "", null);
    }

    public String createCode(String tableName, String columnName, int snLength, String prefixCode, String suffixCode, String mainIdColumnName, Long mainId) {
        if (suffixCode == null) {
            suffixCode = "";
        }
        String sn = null;
        Map<String, Long> lastIdCache = this.LastIDKeeper.get();
        String key = tableName + columnName + prefixCode + suffixCode;
        long lastSN = 0L;
        lastSN = lastIdCache != null && lastIdCache.containsKey(key) ? lastIdCache.get(key).longValue() : this.searchMaxCode(tableName, columnName, prefixCode, snLength, suffixCode, mainIdColumnName, mainId);
        sn = StringUtils.leftPad((String)String.valueOf(++lastSN), (int)snLength, (char)'0');
        if (lastIdCache != null) {
            lastIdCache.put(key, lastSN);
        }
        return prefixCode + sn + suffixCode;
    }

    private long searchMaxCode(String tableName, String columnName, String prefix, int snLength, String suffixCode, String mainIdColumnName, Long mainId) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("prefix", prefix + "%" + suffixCode);
        paras.put("length", prefix.length() + snLength + suffixCode.length());
        String sql = "SELECT max(" + columnName + ") code\nFROM " + tableName + " t\nWHERE " + columnName + " like :prefix\n    AND LENGTH(" + columnName + ") = :length";
        if (mainId != null && StrKit.notBlank(mainIdColumnName)) {
            paras.put("mainId", mainId);
            sql = sql + "\tAND " + mainIdColumnName + " = :mainId";
        }
        MaxIdHelper.lock("10000000", tableName, columnName);
        String code = Objects.toString(this.sqlHelper.getSingal(sql, paras), null);
        if (!StringUtils.isEmpty((CharSequence)code)) {
            return Long.valueOf(code.substring(code.length() - snLength - suffixCode.length(), code.length() - suffixCode.length()));
        }
        return 0L;
    }
}

