/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasWarningLevelDao;
import com.ustc.base.entity.BasWarningLevel;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasWarningLevelService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasWarningLevelDao baswarninglevelDao;

    public BasWarningLevel findBasWarningLevel(Long id) {
        BasWarningLevel entity = (BasWarningLevel)this.baswarninglevelDao.getOne(id);
        return entity;
    }

    public void saveBasWarningLevel(List<BasWarningLevel> list, LoginUser loginUser) {
        for (BasWarningLevel entity : list) {
            entity.setIsUse("Y");
            if (entity.getWarningLevelId() == null) {
                entity.setCreateAccount(loginUser.getAccountid());
                entity.setCreateTime(new Date());
                this.baswarninglevelDao.save(entity);
                continue;
            }
            entity.setModifyAccount(loginUser.getAccountid());
            entity.setModifyTime(new Date());
            this.baswarninglevelDao.save(entity);
        }
    }

    public void delBasWarningLevel(Long id) {
        BasWarningLevel entity = (BasWarningLevel)this.baswarninglevelDao.getOne(id);
        entity.setIsUse("N");
        this.baswarninglevelDao.save(entity);
    }

    public PageObject PageAll(String search, String warningId, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)warningId)) {
            params.put("warningId", warningId);
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.searchPage("base.BasWarningLevel.select", params, PageRequest.of((int)page, (int)rows));
    }

    public Map<String, Object> findBaswarninglevelMap(Long warningLevelId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("warningLevelId", warningLevelId);
        return this.bSqlHelper.getMap("base.BasWarningLevel.findBaswarninglevelMap", params);
    }
}

