/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.BasUserGroupMemberDao;
import com.ustc.base.entity.BasUserGroupMember;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasUserGroupMemberService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasUserGroupMemberDao basusergroupmemberDao;

    public BasUserGroupMember findBasUserGroupMember(Long id) {
        BasUserGroupMember entity = (BasUserGroupMember)this.basusergroupmemberDao.getOne(id);
        return entity;
    }

    public void saveBasUserGroupMember(BasUserGroupMember entity) {
        this.basusergroupmemberDao.save(entity);
    }

    public void delBasUserGroupMember(Long id) {
        BasUserGroupMember entity = (BasUserGroupMember)this.basusergroupmemberDao.getOne(id);
        entity.setIsUse("N");
        this.basusergroupmemberDao.save(entity);
    }

    public PageObject PageAll(String search, String userGroupId, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)userGroupId)) {
            params.put("userGroupId", userGroupId);
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.searchPage("base.BasUserGroupMember.select", params, PageRequest.of((int)page, (int)rows));
    }

    public PageObject PageNotAll(String search, String userGroupId, String deptCode, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)userGroupId)) {
            params.put("userGroupId", userGroupId);
        }
        if (!StringUtils.isEmpty((String)deptCode)) {
            params.put("deptCode", deptCode);
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.searchPage("base.BasUserGroupMember.pageNotBasUserGroupMember", params, PageRequest.of((int)page, (int)rows));
    }

    public void moveBasUserGroupMember(boolean inout, Long userGroupId, Long orgid, Long deptid, String accountids) {
        String[] accounts = accountids.split(",");
        if (userGroupId == null) {
            return;
        }
        if (inout) {
            ArrayList<Long> accountlist = new ArrayList<Long>();
            for (String accountid : accounts) {
                accountlist.add(Long.parseLong(accountid));
            }
            this.basusergroupmemberDao.deleteByUserGroupIdAndAccountIdIn(userGroupId, accountlist);
        } else {
            for (String accountid : accounts) {
                BasUserGroupMember entity = new BasUserGroupMember();
                entity = this.basusergroupmemberDao.findByUserGroupIdAndAccountId(userGroupId, Long.parseLong(accountid));
                if (entity != null) continue;
                BasUserGroupMember newentity = new BasUserGroupMember();
                newentity.setUserGroupId(userGroupId);
                newentity.setOrgId(orgid);
                newentity.setDeptId(deptid);
                newentity.setAccountId(Long.parseLong(accountid));
                this.basusergroupmemberDao.save(newentity);
            }
        }
        SysUtils.clearShiroCache();
    }
}

