/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.dao.BasRolesDao;
import com.ustc.base.entity.BasRoles;
import com.ustc.base.service.BasEmpAccountService;
import com.ustc.base.service.BasRolesAccountService;
import com.ustc.base.service.CommonService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasRolesService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasRolesDao basrolesDao;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private BasRolesAccountService basrolesaccountService;

    public List<BasRoles> findAll() {
        return this.basrolesDao.findByIsUse("Y");
    }

    public JsonMsg checkRepeat(BasRoles entity) {
        JsonMsg msg = new JsonMsg();
        List<BasRoles> list = this.basrolesDao.findByRoleNameAndIsUse(entity.getRoleName(), "Y");
        if (list.size() > 1) {
            msg.setSuccess(false);
            msg.setMsg("\u89d2\u8272\u540d\u79f0\u6709\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        } else if (list.size() == 1 && !list.get(0).getRoleId().equals(entity.getRoleId())) {
            msg.setSuccess(false);
            msg.setMsg("\u89d2\u8272\u540d\u79f0\u6709\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        }
        return msg;
    }

    public BasRoles findBasRoles(Long id) {
        BasRoles entity = (BasRoles)this.basrolesDao.findById(id).get();
        return entity;
    }

    public void saveBasRoles(BasRoles entity) {
        this.basrolesDao.save(entity);
    }

    public void delBasRoles(Long id) {
        this.basrolesDao.deleteById(id);
    }

    public PageObject PageAll(String roleType, Long orgid, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer("select * from BAS_ROLES t where  t.is_use=:isUse \n");
        params.put("isUse", "Y");
        if (StrKit.notBlank(roleType)) {
            sql.append(" and t.role_type in (:roleType) \n");
            params.put("roleType", Arrays.asList(roleType.split(",")));
        }
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and (");
            sql.append("   upper(t.ROLE_NAME) like :search ");
            sql.append(" or  upper(t.ROLE_CODE) like :search ");
            sql.append(") ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append("\torder by t.DISPLAY_NO ");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("ROLE_TYPE", "ROLE_TYPE");
        dicmapper.put("ROLE_ORIGIN", "ROLE_ORIGIN");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public Map<String, Object> findRoleLevelByAccountId(String ids) {
        int roleLevel = 10;
        long acc = 0L;
        long rorgId = 0L;
        HashMap<String, Object> obj = new HashMap<String, Object>();
        String[] idStr = null;
        if (ids == null || ids.length() <= 0) {
            return null;
        }
        idStr = ids.split(",");
        if (idStr != null && idStr.length > 0) {
            for (int i = 0; i < idStr.length; ++i) {
                long account = Long.parseLong(idStr[i]);
                List<Map<String, Object>> findRolesByAccountId = this.basrolesaccountService.findRolesByAccountId(account);
                long orgId = this.basEmpAccountService.findById(account).getOrgId();
                if (findRolesByAccountId == null || findRolesByAccountId.size() <= 0) continue;
                for (Map<String, Object> roelsBy : findRolesByAccountId) {
                    int level;
                    if (roelsBy.get("ROLE_LEVEL") == null || (level = Integer.parseInt(roelsBy.get("ROLE_LEVEL").toString())) != 3 && level != 5) continue;
                    if (orgId == 10000000L && (rorgId == 0L || rorgId == 10000000L) && level < roleLevel) {
                        roleLevel = level;
                        acc = account;
                        rorgId = orgId;
                    }
                    if (orgId != 10000000L && (rorgId == 0L || rorgId != 0L && rorgId != 10000000L) && level < roleLevel) {
                        roleLevel = level;
                        acc = account;
                        rorgId = orgId;
                    }
                    if (orgId == 10000000L || rorgId == 0L || rorgId == 0L || rorgId == 10000000L) {
                        // empty if block
                    }
                    if (orgId != 10000000L || rorgId != 0L && (rorgId == 0L || rorgId == 10000000L)) continue;
                    roleLevel = level;
                    acc = account;
                    rorgId = orgId;
                }
            }
        }
        if (rorgId == 0L) {
            return null;
        }
        obj.put("highestAccount", acc);
        obj.put("highestOrg", rorgId);
        obj.put("roleLevel", roleLevel);
        return obj;
    }
}

