/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.BasRolesAccountDao;
import com.ustc.base.entity.BasRoles;
import com.ustc.base.entity.BasRolesAccount;
import com.ustc.base.service.BasRolesService;
import com.ustc.base.service.CommonService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasRolesAccountService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasRolesAccountDao basrolesaccountDao;
    @Autowired
    private BasRolesService basRolesService;

    public BasRolesAccount findBasRolesAccount(Long id) {
        BasRolesAccount entity = (BasRolesAccount)this.basrolesaccountDao.findById(id).get();
        return entity;
    }

    public void saveBasRolesAccount(BasRolesAccount entity) {
        this.basrolesaccountDao.save(entity);
    }

    public void delBasRolesAccount(Long id) {
        this.basrolesaccountDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select * from BAS_ROLES_ACCOUNT t  order by t.ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from BAS_ROLES_ACCOUNT t where   upper(t.ID) like ?1  or upper(t.ROLE_ID) like ?1  or upper(t.ACCOUNT_ID) like ?1  order by t.ID";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List getRoleSelectAcount(Long orgid, Long deptid, Long roleid) {
        return this.PageRoleAccount(true, orgid, deptid, roleid, null, null, "", 1, 999999).getRows();
    }

    public PageObject PageRoleAccount(Boolean inout, Long orgid, Long deptid, Long roleid, Long unOrgid, Long unDeptid, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        if (roleid == null) {
            return pageobject;
        }
        BasRoles role = this.basRolesService.findBasRoles(roleid);
        String roleType = role.getRoleType();
        HashMap<String, Object> params = new HashMap<String, Object>();
        String deptsql = "";
        String inandout = inout != false ? " in " : " not in ";
        if ("dept".equals(roleType) && deptid != null) {
            deptsql = " and d.dept_id = :deptid \n";
            params.put("deptid", deptid);
        } else if ("org".equals(roleType) && orgid != null) {
            deptsql = " and d.org_id = :orgid \n";
            params.put("orgid", orgid);
        }
        StringBuffer sql = new StringBuffer("select a.account_id,\n       a.account_name,\n       b.emp_name,\n       d.dept_name,\n       d.dept_id,\n       o.org_id\n  from bas_emp_account a\n  left join bas_emp b\n    on a.emp_id = b.emp_id\n   and b.status = :status\n  left join hr_emp h\n    on h.emp_id = b.hr_emp_id\n   and h.is_use = 'Y'\n  left join bas_dept d\n    on a.dept_id = d.dept_id\n  left join bas_org o\n    on a.org_id = o.org_id\n where a.is_use = 'Y'\n   and b.is_use = 'Y'\n   and a.account_id " + inandout + "       (select d.account_id from bas_roles_account d where d.role_id = :roleid " + deptsql + ") \n");
        params.put("status", "1");
        params.put("roleid", roleid);
        if (StrKit.notNull(search)) {
            sql.append("   and (upper(a.account_name) like :search or upper(b.emp_name) like :search ) \n");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (inout.booleanValue() && orgid == null) {
            sql.append(" and b.org_id is null");
        } else if (!inout.booleanValue()) {
            if (unOrgid == null) {
                unOrgid = orgid;
            }
            sql.append(" and o.org_id in (with recursive tmp as \n(select o1.org_id id from BAS_ORG o1 where o1.org_id = :unOrgid \nUNION ALL select o2.org_id id from BAS_ORG o2,tmp t  where t.id = o2.porg_id) select *  from tmp p)  \n");
            params.put("unOrgid", unOrgid);
            if (unDeptid != null) {
                sql.append(" and b.dept_id = :unDeptid");
                params.put("unDeptid", unDeptid);
            }
        }
        sql.append("\torder by h.display_no, o.sort, d.display_no ");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        return pageobject;
    }

    public BasRolesAccount findByRoleIdAndAccountId(Long roleid, Long accountid) {
        return this.basrolesaccountDao.findByRoleIdAndAccountId(roleid, accountid);
    }

    public List<BasRolesAccount> findByroleIdAndAccountId(Long roleid, Long accountid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (roleid != null) {
            params.put("roleid", roleid);
        }
        if (accountid != null) {
            params.put("accountid", accountid);
        }
        return this.bSqlHelper.getList("business.gm.GmAssetsDepreciation.findByroleIdAndAccountId", params, BasRolesAccount.class);
    }

    public List<BasRolesAccount> findByRoleIdAndAccountId(List<Long> roleids, Long accountid) {
        return this.basrolesaccountDao.findByRoleIdInAndAccountId(roleids, accountid);
    }

    public boolean isHasAdminRoles(Long accountid) {
        BasRolesAccount b = this.basrolesaccountDao.findByRoleIdAndAccountId(SysContent.ROLE_ID_SUPER_ADMIN, accountid);
        return b != null;
    }

    public boolean isAccountHasRoles(Long accountid) {
        boolean hasRoles = false;
        String sql = "select count(1)\n  from bas_roles_account t, bas_roles r\n where t.role_id = r.role_id\n   and r.is_use = 'Y'\n   AND t.account_id = ?1";
        Object object = this.sqlHelper.getSingal(sql, new Object[]{accountid});
        if (object != null && Integer.parseInt(object.toString()) > 0) {
            hasRoles = true;
        }
        return hasRoles;
    }

    public void moveBasRolesAccount(boolean inout, Long roleid, Long orgid, Long deptid, String accountids) {
        String[] accounts = accountids.split(",");
        if (roleid == null) {
            return;
        }
        BasRoles role = this.basRolesService.findBasRoles(roleid);
        String roleType = role.getRoleType();
        if (inout) {
            for (String accountid : accounts) {
                BasRolesAccount entity = new BasRolesAccount();
                entity = "org".equals(roleType) ? this.basrolesaccountDao.findByRoleIdAndOrgIdAndAccountId(roleid, orgid, Long.parseLong(accountid)) : ("dept".equals(roleType) ? this.basrolesaccountDao.findByRoleIdAndOrgIdAndDeptIdAndAccountId(roleid, orgid, deptid, Long.parseLong(accountid)) : this.basrolesaccountDao.findByRoleIdAndAccountId(roleid, Long.parseLong(accountid)));
                if (entity != null) continue;
                BasRolesAccount newentity = new BasRolesAccount();
                newentity.setRoleId(roleid);
                if ("dept".equals(roleType) && deptid != null) {
                    newentity.setOrgId(orgid);
                    newentity.setDeptId(deptid);
                } else if ("org".equals(roleType) && orgid != null) {
                    newentity.setOrgId(orgid);
                }
                newentity.setAccountId(Long.parseLong(accountid));
                this.basrolesaccountDao.save(newentity);
            }
        } else {
            ArrayList<Long> accountlist = new ArrayList<Long>();
            for (String accountid : accounts) {
                accountlist.add(Long.parseLong(accountid));
            }
            if ("org".equals(roleType)) {
                this.basrolesaccountDao.deleteByRoleIdAndOrgIdAndAccountIdIn(roleid, orgid, accountlist);
            } else if ("dept".equals(roleType)) {
                this.basrolesaccountDao.deleteByRoleIdAndOrgIdAndDeptIdAndAccountIdIn(roleid, orgid, deptid, accountlist);
            } else {
                this.basrolesaccountDao.deleteByRoleIdAndAccountIdIn(roleid, accountlist);
            }
        }
        SysUtils.clearShiroCache();
    }

    public List<Map<String, Object>> findBasRolesAccountListByRoleIds(String roleIds) {
        String sql = "select distinct t.account_id from bas_roles_account t where t.role_id in (" + roleIds + ")";
        List resultList = this.sqlHelper.queryByNativeSQL(sql, new int[0]);
        return resultList;
    }

    public List<Map<String, Object>> findRolesByAccountId(Long accountId) {
        String sql = "select r.* from bas_roles_account t,bas_roles r where r.role_id = t.role_id and t.account_Id=:accountId";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountId", accountId);
        List resultList = this.sqlHelper.queryByNativeSQL(sql, params, new int[0]);
        return resultList;
    }

    public List<BasRolesAccount> findAccountByRoleIdAndOrgId(long roleId, long orgId) {
        List<BasRolesAccount> bra = this.basrolesaccountDao.findByRoleIdAndOrgId(roleId, orgId);
        return bra;
    }

    public List<BasRolesAccount> findAccountByRoleIdAndDeptId(long roleId, long deptId) {
        List<BasRolesAccount> bra = this.basrolesaccountDao.findByRoleIdAndDeptId(roleId, deptId);
        return bra;
    }

    public List<BasRolesAccount> findByAccountIdAndRoleId(long accountId, long roleId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountId", accountId);
        params.put("roleId", roleId);
        List<BasRolesAccount> bra = this.bSqlHelper.getList("base.BasGroup.findByAccountIdAndRoleId", params, BasRolesAccount.class);
        return bra;
    }
}

