/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.ComboxNode;
import com.ustc.base.common.util.ComboxUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasPostDao;
import com.ustc.base.entity.BasPost;
import com.ustc.base.service.CommonService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasPostService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasPostDao baspostDao;

    public BasPost findBasPost(Long id) {
        BasPost entity = (BasPost)this.baspostDao.getOne(id);
        return entity;
    }

    public Object findBasPostNameByCode(String code) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("SELECT *  FROM  BAS_POST  t  WHERE t.is_use = 'Y' and t.post_code=:code ");
        params.put("code", code);
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), params, new int[0]);
        return ((Map)list.get(0)).get("POST_NAME");
    }

    public JsonMsg saveBasPost(BasPost entity) {
        this.baspostDao.save(entity);
        return new JsonMsg(true, "\u4fdd\u5b58\u6210\u529f", entity);
    }

    public JsonMsg delBasPost(Long id) {
        BasPost entity = (BasPost)this.baspostDao.getOne(id);
        entity.setIsUse("N");
        return this.saveBasPost(entity);
    }

    public List<ComboxNode> getComBoxBasPost() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT T.POST_CODE ID, T.post_name TEXT, T.POST_CODE VALUE  FROM  BAS_POST  t  WHERE t.is_use = 'Y' ");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select * from BAS_POST t where t.is_use=:isUse ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and  (");
            sql.append("  upper(t.POST_ID) like :search ");
            sql.append(" or upper(t.POST_CODE) like :search ");
            sql.append(" or upper(t.POST_NAME) like :search ");
            sql.append(" or upper(t.IS_USE) like :search ");
            sql.append(" or upper(t.OA_ID) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.POST_ID");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<ComboxNode> combo() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.post_id as id,t.post_id as value,t.post_name as text from BAS_POST t where t.is_use=:isUse ");
        params.put("isUse", "Y");
        sql.append(" order by t.display_no ");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), params, new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }
}

