/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.spring.SystemServiceLog;
import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.ComboxNode;
import com.ustc.base.common.util.ComboxUtils;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.BasEmpAccountDao;
import com.ustc.base.dao.BasOrgDao;
import com.ustc.base.entity.BasOrg;
import com.ustc.base.service.CommonService;
import com.ustc.business.hr.entity.HrSettings;
import com.ustc.business.hr.service.HrSettingsService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasOrgService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasOrgDao basOrgDao;
    @Autowired
    private BasEmpAccountDao basAccountDao;
    @Autowired
    private CommonService commonService;
    @Autowired
    private HrSettingsService hrSettingsService;

    public List<ComBoxTreeNode> getOrgMenu(long pid) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT \tt.ORG_ID id,\n     t.abbr text, \n      t.org_code as orgCode,\n\t\tcase when (\tSELECT COUNT(*) \n\t\t\t\t\t\tFROM BAS_ORG \n\t\t\t\t\t\tWHERE PORG_ID = T.ORG_ID AND IS_USE='Y'\n\t\t\t\t\t)=0 then 'open' else 'closed' end AS state \nFROM \tBAS_ORG t  WHERE\tt.IS_USE='Y' \nAND\t\tt.PORG_ID = ?1 \norder by t.sort\n");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{pid}, new int[0]);
        return CommTreeUtils.listToNodeList(list);
    }

    public List<ComBoxTreeNode> getOrgTree() {
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive org as\n\t (select m.* from BAS_ORG m \n\t where   m.PORG_ID = 0  and m.is_use='Y' \n\t union all\n\t select m.* from BAS_ORG m,org  where  m.PORG_ID=org.ORG_ID and m.is_use='Y'\n\t )\n select \n\t\t\tt.ORG_ID id, \n\t\t\tT.PORG_ID PID, \n\t\t\tt.abbr text, \n\t\t\t'open' as state\n from org t\n ORDER BY t.sort");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> findOrgTree(Long obsId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select \tT .ORG_ID id,\n       T .PORG_ID pid, \n       T .abbr text \n from \tBAS_ORG T \n where T .IS_USE = 'Y' \n start with \t\tT .PORG_ID = ?1 \nCONNECT BY PRIOR \tT .ORG_ID = T .PORG_ID \n ORDER BY \t\t\tT .sort ");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{obsId}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public String getOrgName(String ids) {
        String sql = "select GETORGNAME('" + ids + "') from dual";
        return Objects.toString(this.sqlHelper.getSingal(sql), "");
    }

    public String getOrgDeptName(String ids) {
        String sql = "select GETDEPTNAME('" + ids + "') ";
        return Objects.toString(this.sqlHelper.getSingal(sql), "");
    }

    public List<ComBoxTreeNode> queryOrgAndDeptTree(String id, String orgId) {
        StringBuilder sql = new StringBuilder();
        if (StringUtils.isNotBlank((String)orgId)) {
            id = orgId;
            sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept m \n\t where  " + ("0".equals(id) ? "m.pid" : "m.id") + "='" + id + "' \n\t union all\n\t select m.* from view_bas_org_dept m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept a where a.pid=t.id)=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        } else {
            if (StringUtils.isBlank((String)id)) {
                id = "0";
            }
            sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept m \n\t where  " + ("0".equals(id) ? "m.pid" : "m.id") + "='" + id + "' \n\t union all\n\t select m.* from view_bas_org_dept m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept a where a.pid=t.id)=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        }
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public List<ComBoxTreeNode> queryOrgAndDeptTreeQx(String id, String orgId) {
        StringBuilder sql = new StringBuilder();
        Subject currentUser = SecurityUtils.getSubject();
        if (!currentUser.isPermitted("searchAllHrPost")) {
            id = orgId;
            sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept m \n\t where  " + ("0".equals(id) ? "m.pid" : "m.id") + "='" + id + "' \n\t union all\n\t select m.* from view_bas_org_dept m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept a where a.pid=t.id)=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        } else {
            id = "0";
            sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept m \n\t where  " + ("0".equals(id) ? "m.pid" : "m.id") + "='" + id + "' \n\t union all\n\t select m.* from view_bas_org_dept m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept a where a.pid=t.id)=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        }
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public Object queryOrgAndDeptTreeWithoutRoot(String id) {
        if (StringUtils.isBlank((String)id)) {
            id = "0";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept m \n\t where  m.pid=" + SysContent.GROUP_ORG + " \n\t union all\n\t select m.* from view_bas_org_dept m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept a where a.pid=t.id)=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public List<ComBoxTreeNode> queryOrgAndDeptTreeForContact(String id) {
        HrSettings hrSettings = this.hrSettingsService.findByOrgId(SysUtils.getLoginUser().getOrgid());
        String crossOrg = "Y";
        if (hrSettings != null) {
            crossOrg = hrSettings.getCrossOrg();
        }
        if (StringUtils.isBlank((String)id)) {
            id = "Y".equals(crossOrg) ? "0" : SysUtils.getLoginUser().getOrgid().toString();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept m \n\t where  " + ("0".equals(id) ? "m.pid" : "m.id") + "='" + id + "'\n\t union all\n\t select m.* from view_bas_org_dept m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept a where a.pid=t.id)=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public List<Map<String, Object>> queryEmpOrgTree(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String sql = "with recursive emp as(\nselect e.* from view_bas_org_emp e where e.id=#id# union all\nselect e.* from view_bas_org_emp e,emp m where  e.pid = m.id\n)\nselect b.*,\n       (select count(*) from view_bas_org_emp a where a.pid = b.id) title,\n       case when b.type=0 then 'org' when b.type=1 then 'dept' when b.type=2 then 'post' when b.type=3 then 'emp' else '' end class_Name,\n       b.text name\n  from emp b order by b.type desc,b.display_no";
        params.put("id", id.toString());
        return CommTreeUtils.buildTreeMap(this.bSqlHelper.serachBySql(sql, params));
    }

    public List<Map<String, Object>> queryOrgTreeMap(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String sql = " WITH RECURSIVE temp AS ( \nSELECT b.*,( SELECT count(*) FROM view_bas_org_dept a WHERE a.pid = b.id ) title,\nnvl2 ( b.dept_id, 'dept', 'org' ) class_Name,\nb.text NAME \nFROM\n\tview_bas_org_dept b WHERE b.id=#id# \n\tUNION ALL\n\tSELECT b.*,( SELECT count(*) FROM view_bas_org_dept a WHERE a.pid = b.id ) title,\nnvl2 ( b.dept_id, 'dept', 'org' ) class_Name,\nb.text NAME \nFROM\n\tview_bas_org_dept b,\n\t\ttemp t \n\tWHERE\n\t\tt.id = b.pid \n\t) SELECT\n\ttemp.*\nFROM\n\ttemp ";
        params.put("id", id.toString());
        return CommTreeUtils.buildTreeMap(this.bSqlHelper.serachBySql(sql, params));
    }

    public List queryOrgAndDeptList(String id) {
        if (StringUtils.isBlank((String)id)) {
            id = "0";
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" WITH RECURSIVE temp AS (  SELECT\tb.*  FROM\tview_bas_org_dept b WHERE b.pid = '\" + id + \"' \tUNION ALL SELECT\tb.*  FROM\tview_bas_org_dept b,\t\ttemp t \tWHERE\t\tt.id = b.pid \t) SELECT\ttemp.* FROM\ttemp ");
        return this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
    }

    public List<ComBoxTreeNode> queryOrgAndDeptTreeNew(String id) {
        if (StringUtils.isBlank((String)id)) {
            id = "0";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept m \n\t where  m.id='" + id + "' \n\t union all\n\t select m.* from view_bas_org_dept m,org  where  m.pid=org.id\n\t )\n select t.*,\n\t(case when (select count(*) from view_bas_org_dept a where a.pid=t.id)=0 then 'open' else 'closed' end )state\n from org t\n ORDER by t.dtype desc,t.display_no");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public Object queryOrgAndDeptTreeNew1(String id, Long orgId) {
        if (StringUtils.isBlank((String)id)) {
            id = "0";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept_new m \n\t where  m.pid='" + id + "' \n\t union all\n\t select m.* from view_bas_org_dept_new m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept_new a where a.pid=t.id)=0 then 'open' else 'closed' end state,concat(t.id,'_') pids\n from org t\n where t.ORG_ID=" + orgId + " ORDER by t.dtype desc,t.display_no");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public JsonMsg saveOrg(BasOrg basOrg) {
        if (basOrg.getOrgId() == null) {
            basOrg.setIsUse("Y");
        }
        this.basOrgDao.save(basOrg);
        return new JsonMsg(true, "\u4fdd\u5b58\u6210\u529f", basOrg);
    }

    @SystemServiceLog(description="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u4fe1\u606fservice")
    public BasOrg findByOrgId(Long orgId) {
        Optional org = this.basOrgDao.findById(orgId);
        if (org.isPresent()) {
            return (BasOrg)this.basOrgDao.findById(orgId).get();
        }
        return null;
    }

    public boolean delOrgs(Long searchId) {
        StringBuilder sql = new StringBuilder();
        sql.append("\tUPDATE \tBAS_ORG m \n\tSET\t\tm.IS_USE='N' \n\tWHERE \tm.ORG_ID in ( \n\t\tSELECT \tT.ORG_ID \n\t\tFROM \tBAS_ORG T \n\t\tWHERE \tT.IS_USE = 'Y' \n \tstart with t.PORG_ID = ?1 \n\t\tconnect by prior t.ORG_ID = t.PORG_ID ) \n");
        this.sqlHelper.exeNativeSQL(sql.toString(), new Object[]{searchId});
        return true;
    }

    public List<ComBoxTreeNode> getOutOrgTreeByLv(String lv) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT distinct T.ORG_ID ID, T.ABBR TEXT,T.PORG_ID PID \n  FROM bas_org t\n WHERE t.lv = ?1\n START WITH org_id IN (SELECT org_id\n                         FROM bas_outside_org  where is_use='Y')\nCONNECT BY PRIOR t.porg_id = t.org_id  order by t.ABBR");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{lv}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> buildOrgAndDeptTreeWithOnLineAccount(List<ComBoxTreeNode> orgdepttree, List<Long> accountIdList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", accountIdList);
        String sql = "select t.*,nvl(d.dept_id,t.dept_id) bizdept,nvl(d.org_id,t.org_id) bizorg,(with recursive org as(\nselect m.* from view_bas_org_dept m where m.id =nvl(d.dept_id,t.dept_id)\nunion all  select m.* from view_bas_org_dept m,org  where  m.id=org.pid\n)select group_concat(org.id) from org\n)pids from bas_emp_account t\nleft join bas_org o on o.org_id = t.org_id\nleft join bas_dept d on d.dept_id= o.belong_dept where t.account_id in( #join(ids)#) and t.emp_id<>0";
        List<Map<String, Object>> accountlist = this.bSqlHelper.serachBySql(sql, params);
        this.buildOnLineAccount(orgdepttree, accountlist);
        return orgdepttree;
    }

    public void buildOnLineAccount(List<ComBoxTreeNode> orgdepttree, List<Map<String, Object>> accountlist) {
        for (ComBoxTreeNode node : orgdepttree) {
            if ("1".equals(node.getAttributes().get("dtype").toString())) {
                String id = node.getId();
                int num = 0;
                for (Map<String, Object> account : accountlist) {
                    if (account.get("bizdept") == null || !("," + account.get("pids") + ",").contains("," + id + ",") && !id.equals(account.get("deptId").toString())) continue;
                    ++num;
                }
                node.setText(num > 0 ? node.getText() + "(" + num + ")" : node.getText());
            } else {
                int num = 0;
                for (Map<String, Object> account : accountlist) {
                    if (!("," + account.get("pids") + ",").contains("," + node.getId() + ",")) continue;
                    ++num;
                }
                node.setText(num > 0 ? node.getText() + "(" + num + ")" : node.getText());
            }
            if (node.getChildren().size() <= 0) continue;
            this.buildOnLineAccount(node.getChildren(), accountlist);
        }
    }

    public List<ComboxNode> allFinanceOrg() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT distinct T.ORG_ID ID, T.ABBR TEXT,T.ORG_ID VALUE,t.sort \n  FROM bas_org t\n WHERE  T.IS_FINANCE_UNIT='Y' and t.is_use='Y' order by t.sort ");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }

    public List<BasOrg> allEasOrg() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * \n  FROM bas_org t\n WHERE  T.IS_FINANCE_UNIT='Y' and t.is_use='Y' order by t.sort ");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), BasOrg.class, new int[0]);
        return list;
    }

    public List<ComboxNode> getComboOrg() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT distinct T.ORG_ID ID, T.ORG_NAME TEXT,T.ORG_ID VALUE,T.SORT \n  FROM bas_org t\n WHERE t.is_use='Y' order by t.sort");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }

    public List<ComboxNode> getComboOrgByType(String type) {
        StringBuilder sql = new StringBuilder();
        if ("tf".equals(type)) {
            sql.append(" SELECT distinct T.ORG_ID ID, T.ORG_NAME TEXT,T.ORG_ID VALUE,T.SORT FROM bas_org t WHERE t.is_use='Y' AND t.ORG_ID = 10000000 order by t.sort ");
        } else if ("js".equals(type)) {
            sql.append(" SELECT distinct T.ORG_ID ID, T.ORG_NAME TEXT,T.ORG_ID VALUE,T.SORT FROM bas_org t WHERE t.is_use='Y' AND t.ORG_ID = 10000600 order by t.sort ");
        } else {
            sql.append(" SELECT distinct T.ORG_ID ID, T.ORG_NAME TEXT,T.ORG_ID VALUE,T.SORT FROM bas_org t WHERE t.is_use='Y' order by t.sort  ");
        }
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }

    public Long queryEmpOrgId(Long accountId) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("  select getorgid(:accountId) from dual ");
        params.put("accountId", accountId);
        Object o = this.sqlHelper.getSingal(sql.toString(), params);
        if (o != null && StrKit.notBlank(o.toString())) {
            return Long.valueOf(o.toString());
        }
        return null;
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*  ");
        sql.append(" from BAS_ORG t  ");
        sql.append(" where t.is_use=:isUse ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and  (");
            sql.append("  upper(t.ORG_ID) like :search ");
            sql.append(" or upper(t.ABBR) like :search ");
            sql.append(" or upper(t.ADDR) like :search ");
            sql.append(" or upper(t.ANNUL_DATE) like :search ");
            sql.append(" or upper(t.CITY) like :search ");
            sql.append(" or upper(t.CLSFY) like :search ");
            sql.append(" or upper(t.COLLECT_TIME) like :search ");
            sql.append(" or upper(t.CONTACT) like :search ");
            sql.append(" or upper(t.COUNTRY) like :search ");
            sql.append(" or upper(t.DATA_SOURCE) like :search ");
            sql.append(" or upper(t.DATA_STATUS) like :search ");
            sql.append(" or upper(t.ESTABLISH_DATE) like :search ");
            sql.append(" or upper(t.FAX) like :search ");
            sql.append(" or upper(t.FILE_ID) like :search ");
            sql.append(" or upper(t.FOUND_DATE) like :search ");
            sql.append(" or upper(t.HOLDING_PCT) like :search ");
            sql.append(" or upper(t.IDNTFR_CODE) like :search ");
            sql.append(" or upper(t.INDUSTRY) like :search ");
            sql.append(" or upper(t.INDUSTRY_SUB) like :search ");
            sql.append(" or upper(t.IS_USE) like :search ");
            sql.append(" or upper(t.LEGAL_PERSON) like :search ");
            sql.append(" or upper(t.LV) like :search ");
            sql.append(" or upper(t.MAIL) like :search ");
            sql.append(" or upper(t.MAIN_INDUSTRY) like :search ");
            sql.append(" or upper(t.ORG_CODE) like :search ");
            sql.append(" or upper(t.ORG_NAME) like :search ");
            sql.append(" or upper(t.ORG_NO) like :search ");
            sql.append(" or upper(t.PORG_ID) like :search ");
            sql.append(" or upper(t.POST_CODE) like :search ");
            sql.append(" or upper(t.PROP) like :search ");
            sql.append(" or upper(t.PROVINCE) like :search ");
            sql.append(" or upper(t.REG_CAPITAL) like :search ");
            sql.append(" or upper(t.RETRIEVE_CODE) like :search ");
            sql.append(" or upper(t.SORT) like :search ");
            sql.append(" or upper(t.STATUS) like :search ");
            sql.append(" or upper(t.TAX_REG_NO) like :search ");
            sql.append(" or upper(t.TEL) like :search ");
            sql.append(" or upper(t.TYP) like :search ");
            sql.append(" or upper(t.UPDATE_TIME) like :search ");
            sql.append(" or upper(t.WEBSITE) like :search ");
            sql.append(" or upper(t.IS_ADMINISTRATE_UNIT) like :search ");
            sql.append(" or upper(t.IS_FINANCE_UNIT) like :search ");
            sql.append(" or upper(t.IS_COST_CENTER) like :search ");
            sql.append(" or upper(t.TO_FINANCE_CODE) like :search ");
            sql.append(" or upper(t.TO_EAS_CODE) like :search ");
            sql.append(" or upper(t.OA_ID) like :search ");
            sql.append(" or upper(t.IS_FINANCIAL) like :search ");
            sql.append(") ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.SORT");
        if (StrKit.notBlank(sort)) {
            String exesql = "select * from (" + sql.toString() + ") " + SysUtils.genOrderBy(sort, order);
            pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<ComBoxTreeNode> treeBasOrg(Long pid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", pid);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.treeBasOrg", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> findBasOrgByOne(Long org_id) {
        List<ComBoxTreeNode> result = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("org_id", org_id);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.findBasOrgByOne", params);
        result = CommTreeUtils.buildTreeNode(list);
        for (int i = 0; i < result.size(); ++i) {
            result.get(i).setValue(result.get(i).getId());
            result.get(i).setChecked(false);
        }
        return result;
    }

    public List<Map<String, Object>> constructOrgAndFirstDept() {
        HashMap params = new HashMap();
        StringBuilder sql = new StringBuilder();
        sql.append("select\nt.ID value,\nt.TEXT text\nfrom VIEW_BAS_ORG_DEPT t where t.pid='10000000' order by t.dtype desc,t.display_no");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[0], new int[0]);
        for (Map map : list) {
            map.put("value", map.get("VALUE"));
            map.put("text", map.get("TEXT"));
        }
        return list;
    }

    public Object getComboDeptForGroup() {
        StringBuilder sql = new StringBuilder();
        sql.append("select\nt.dept_id value,\nt.abbr text\nfrom BAS_DEPT t where t.is_use='Y' and t.org_id=10000000");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }

    public Object getComboDeptForLogin(Long orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.getComboDeptForLogin", params);
        return ComboxUtils.buildComboxNodes(list);
    }

    public List<ComBoxTreeNode> getNextDept(Long deptId) {
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive cte as(\n    SELECT x.ID id,x.TEXT text,x.PID pid \n    from VIEW_BAS_ORG_DEPT x\n    where x.id =" + deptId + " \n    union all \n    SELECT y.ID id,y.TEXT text,y.PID pid\n    from VIEW_BAS_ORG_DEPT y\n    join cte c on c.id = y.pid and y.id =" + deptId + "\n)SELECT ID,TEXT,PID from cte");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public String findRetrieveCodeById(Long orgId) {
        String firstCode = null;
        if (orgId != null) {
            BasOrg orgEntity = (BasOrg)this.basOrgDao.findById(orgId).get();
            firstCode = orgEntity.getRetrieveCode();
        }
        return firstCode;
    }

    public Object getComboOrgNew() {
        StringBuilder sql = new StringBuilder();
        LoginUser user = SysUtils.getLoginUser();
        Long orgId = user.getOrgid();
        sql.append("SELECT DISTINCT \nz.ORG_ID ID,\nz.ABBR TEXT,\nz.ORG_ID  VALUE,\nz.sort\nFROM\n(\n(WITH recursive view_temp1 AS (\nSELECT\nt.* \nFROM\nBAS_ORG t \nWHERE\nt.is_use = 'Y' AND t.Porg_id = 0\nUNION ALL\nSELECT\nt.* \nFROM\nBAS_ORG t,view_temp1 v1\nWHERE\nt.is_use = 'Y' AND v1.org_id = t.porg_id\n)select * from view_temp1) \n) z order by z.sort\n");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }

    public Object getComboOrgTop(String orderBy) {
        StringBuilder sql = new StringBuilder();
        LoginUser user = SysUtils.getLoginUser();
        Long orgId = user.getOrgid();
        sql.append("select z.ORG_ID ID, z.ABBR TEXT,z.ORG_ID VALUE\nfrom\n(select t.* from BAS_ORG t\nWHERE t.is_use='Y'\n");
        if ("top".equals(orderBy)) {
            sql.append("and t.PORG_ID=0");
        }
        sql.append("start with t.org_id = " + orgId);
        sql.append("CONNECT BY PRIOR t.porg_id = t.org_id) z\norder by z.sort");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }

    public BasOrg findTaxTypeByOrgId(Long orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LoginUser user = SysUtils.getLoginUser();
        if (orgId == null) {
            orgId = user.getOrgid();
        }
        params.put("orgId", orgId);
        BasOrg entity = this.bSqlHelper.getEntity("base.BasOrg.findTaxTypeByOrgId", params, BasOrg.class);
        return entity;
    }

    public List<ComBoxTreeNode> queryOrgAndDeptTreeByOrg(String id, Long orgId) {
        String orgSql = "";
        if (SysContent.GROUP_ORG.compareTo(orgId) == 0) {
            id = "0";
            orgSql = " and m.ORG_id= " + orgId + " ";
        } else {
            id = SysContent.GROUP_ORG.toString();
            orgSql = " and m.dept_id= " + SysUtils.getLoginUser().getBusinessUnitId() + " ";
        }
        String view = "view_bas_org_bizdept";
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive org as\n\t (select * from " + view + " m \n\t where  m.pid='" + id + "' " + orgSql + " \n\t union all\n\t select m.* from " + view + " m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_bizdept a where a.pid=t.id)=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public List<ComboxNode> getComboxListForApplyOrg(Long orgId, String level) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LoginUser user = SysUtils.getLoginUser();
        if (orgId == null) {
            orgId = user.getOrgid();
        }
        params.put("orgId", orgId);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.getComboxListForApplyOrg", params);
        return ComboxUtils.buildComboxNodes(list);
    }

    public List<ComBoxTreeNode> querySubUnit(Long id, String excludeids) {
        String sql = "select b.* from view_bas_org_dept b\n  where b.pid='" + (id == null ? SysUtils.getLoginUser().getOrgid() : id) + "' or\nb.pid in (select t.id from view_bas_org_dept t\n  where b.pid='" + (id == null ? SysUtils.getLoginUser().getOrgid() : id) + "'  and t.dept_id is null )\n\torder by dtype desc,b.display_no";
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]));
        return ll;
    }

    public List<ComboxNode> getSubUnitAndSeptByOrg(Long orgId, Boolean isdetail) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LoginUser user = SysUtils.getLoginUser();
        if (orgId != null) {
            params.put("orgId", orgId);
        } else if (!isdetail.booleanValue()) {
            params.put("orgId", user.getOrgid());
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.getComboxListForOrgSub", params);
        return ComboxUtils.buildComboxNodes(list);
    }

    public String findSubUnitAndSeptNameById(String id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)id)) {
            return "";
        }
        params.put("id", id);
        return this.bSqlHelper.getStringValue("base.BasOrg.findSubUnitAndSeptNameById", params);
    }

    public List<ComboxNode> findAssessmentOrg() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.findAssessmentOrg", params);
        return ComboxUtils.buildComboxNodes(list);
    }
}

