/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasNameUsedDao;
import com.ustc.base.entity.BasContactOrgRename;
import com.ustc.base.entity.BasNameUsed;
import com.ustc.base.service.CommonService;
import com.ustc.pub.dao.PubContactOrgDao;
import com.ustc.pub.entity.PubContactOrg;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasNameUsedService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasNameUsedDao basnameusedDao;
    @Autowired
    private PubContactOrgDao pubcontactorgDao;

    public BasNameUsed findBasNameUsed(Long id) {
        BasNameUsed entity = (BasNameUsed)this.basnameusedDao.findById(id).get();
        return entity;
    }

    public Boolean valitateName(String nameUsedName) {
        List<BasNameUsed> list = this.basnameusedDao.findByNameUsedNameAndIsUse(nameUsedName, "Y");
        List<PubContactOrg> list1 = this.pubcontactorgDao.findByContactOrgNameAndIsUse(nameUsedName, "Y");
        if (list != null && list.size() > 0 || list1 != null && list1.size() > 0) {
            return true;
        }
        return false;
    }

    public void saveBasNameUsed(BasNameUsed entity) {
        this.basnameusedDao.save(entity);
    }

    public void insertData(BasContactOrgRename orgName) {
        BasNameUsed entity = new BasNameUsed();
        entity.setContactOrgId(orgName.getContactOrgId());
        entity.setNameUsedName(orgName.getContactOrgName());
        entity.setInvalidTime(new Date());
        entity.setModifyAccount(orgName.getModifyAccount());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        this.basnameusedDao.save(entity);
    }

    public void delBasNameUsed(Long id) {
        BasNameUsed entity = (BasNameUsed)this.basnameusedDao.findById(id).get();
        entity.setIsUse("N");
        this.basnameusedDao.save(entity);
    }

    public PageObject PageAll(Long contactOrgId, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select t.*, \n");
        sql.append(" e.account_name \n");
        sql.append(" from BAS_NAME_USED t \n");
        sql.append(" left join bas_emp_account e on e.account_id=t.Modify_Account \n");
        sql.append(" where t.is_use=:isUse ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and  (");
            sql.append("  upper(t.NAME_USED_NAME) like :search ");
            sql.append(" or upper(t.REMARK) like :search ");
            sql.append(" or upper(e.account_name) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (contactOrgId != null) {
            sql.append(" and t.CONTACT_ORG_ID =:contactOrgId");
            params.put("contactOrgId", contactOrgId);
        }
        sql.append(" order by t.NAME_USED_ID");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }
}

