/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ustc.app.common.AppPush;
import com.ustc.base.common.CronTask.SchedulingRunnable;
import com.ustc.base.common.exception.ExceptionHandler;
import com.ustc.base.common.spring.SpringContextHolder;
import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.DateUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.BasDeviceUserDao;
import com.ustc.base.dao.BasMessageDao;
import com.ustc.base.dao.BasMessageReceiveDao;
import com.ustc.base.entity.BasDeviceUser;
import com.ustc.base.entity.BasEmpAccount;
import com.ustc.base.entity.BasMessage;
import com.ustc.base.entity.BasMessageReceive;
import com.ustc.base.extend.IBasMessageAdditional;
import com.ustc.base.service.BasEmpAccountService;
import com.ustc.base.service.CommonService;
import com.ustc.util.StringUtil;
import com.ustc.webservice.sms.ISmsManagerService;
import com.ustc.workflow.service.FlowUtilService;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasMessageService {
    public static Logger loger = Logger.getLogger(ExceptionHandler.class);
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasMessageDao basmessageDao;
    @Autowired
    private BasMessageReceiveDao basMessageReceiveDao;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasDeviceUserDao BasDeviceUserDao;
    @Autowired(required=false)
    private ISmsManagerService smsManagerService;

    public BasMessage findBasMessage(Long id) {
        BasMessage entity = (BasMessage)this.basmessageDao.findById(id).get();
        return entity;
    }

    public void saveBasMessage(BasMessage entity) {
        this.basmessageDao.save(entity);
    }

    public void delBasMessage(Long id) {
        this.basmessageDao.deleteById(id);
    }

    public BasMessage findBasMessageByAccountId(Long id, Long accountId) {
        if (id == null || accountId == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountId);
        params.put("msgId", id);
        String sql = "select t.*\n  from Bas_Message t, BAS_MESSAGE_RECEIVE r\n where r.msg_id = t.msg_id\n   and (r.ACCOUNT_ID =:accountid or exists (select 1\n  from WF_AGENT a, gen_form f,  bas_message_receive e\n where   f.form_code =t.form_code\n   and e.account_id = a.agent_to_account\n   and e.msg_id=t.msg_id\n   and a.agent_to_account=r.account_id\n   and a.agent_account = :accountid\n   and( (concat('%,' , a.agent_content , ',%') like concat('%,' , f.flow_cat_id , ',%')\n   and a.end_date > now()\n   and (a.cancel_date is null or a.cancel_date > now())) or a.agent_type='2')) ) \n   and r.IS_DEAL = 'N'\n   and t.is_use = 'Y'\n   and t.msg_id = :msgId";
        List list = this.sqlHelper.queryByNativeSQL(sql, params, BasMessage.class, new int[0]);
        if (list != null && !list.isEmpty()) {
            return (BasMessage)list.get(0);
        }
        return null;
    }

    public BasMessage findByformCodeAndbusiMainIdAndAccountId(String busiMainId, Long accountId, String formCode) {
        if (busiMainId == null || accountId == null || formCode == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountId);
        params.put("busiMainId", busiMainId);
        params.put("formCode", formCode);
        String sql = "select t.* from Bas_Message t,BAS_MESSAGE_RECEIVE r where r.msg_id=t.msg_id and r.ACCOUNT_ID=:accountid and r.IS_DEAL='N' and t.is_use='Y' and t.BUSI_MAIN_ID=:busiMainId and t.FORM_CODE=:formCode ";
        List list = this.sqlHelper.queryByNativeSQL(sql, params, BasMessage.class, new int[0]);
        if (list != null && !list.isEmpty()) {
            return (BasMessage)list.get(0);
        }
        return null;
    }

    public List<BasMessage> findByProcessinstid(Long processinstid) {
        return this.basmessageDao.findByProcessinstid(processinstid);
    }

    public PageObject PageSysMessageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.msg_id,t.msg_title,DATE_FORMAT(t.sendtime,'%Y-%m-%d %H:%i:%s') as sendtime from BAS_MESSAGE t where t.is_use=:isUse and t.MSG_TYPE=2");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and  (");
            sql.append("  upper(t.MSG_ID) like :search ");
            sql.append(" or upper(t.MSG_TITLE) like :search ");
            sql.append(" or upper(t.MSG_URL) like :search ");
            sql.append(" or upper(t.MSG_TYPE) like :search ");
            sql.append(" or upper(t.BUSI_TYPE) like :search ");
            sql.append(" or upper(t.SENDER) like :search ");
            sql.append(" or upper(t.SENDTIME) like :search ");
            sql.append(" or upper(t.IS_PUBLIC) like :search ");
            sql.append(" or upper(t.IS_USE) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.SENDTIME desc");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("MSG_TYPE", "MSG_TYPE");
        dicmapper.put("BUSI_TYPE", "BUSINESS_TYPE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select * from BAS_MESSAGE t  order by t.MSG_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from BAS_MESSAGE t where   upper(t.MSG_ID) like ?1  or upper(t.MSG_TITLE) like ?1  or upper(t.MSG_URL) like ?1  or upper(t.MSG_TYPE) like ?1  or upper(t.BUSI_TYPE) like ?1  or upper(t.SENDER) like ?1  or upper(t.SENDTIME) like ?1  or upper(t.IS_PUBLIC) like ?1  or upper(t.IS_USE) like ?1  order by t.MSG_ID";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("MSG_TYPE", "MSG_TYPE");
        dicmapper.put("BUSI_TYPE", "BUSINESS_TYPE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<Map<String, Object>> PageToDoList(Long accountid, String search) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT case i.limittime when 0 then 0 else floor((now()-i.starttime)*24*60-i.limittime) end overtime,t.*,\n       b.account_name  AS account_Name,getdeptname(b.dept_id) dept_name,\n       b2.account_name AS creator,\n       r.is_read       AS is_read\n  FROM BAS_MESSAGE t\n left join wf_workitem i on t.workitemid=i.workitemid    left join (SELECT r.msg_id, r.account_id, r.is_read\n               FROM BAS_MESSAGE_RECEIVE r\n              where r.is_deal = 'N'\n             UNION\n             SELECT s.msg_id, a.agent_account, e.is_read\n               FROM WF_AGENT            a,\n                    gen_form            f,\n                    bas_message         s,\n                    bas_message_receive e\n              WHERE s.form_code = f.form_code\n                AND s.msg_id = e.msg_id\n                AND e.account_id = a.agent_to_account\n                AND s.is_use = 'Y'\n                AND e.is_deal = 'N'\n                AND a.is_use = 'Y'\n                AND ((concat('%,' , a.agent_content , ',%')) LIKE\n                    (concat('%,' , f.flow_cat_id , ',%')) AND\n                    a.end_date > now() AND\n                    (a.cancel_date IS NULL OR a.cancel_date > now()) OR\n                    a.agent_type = '2')) r\n    on r.msg_id = t.msg_id\n  LEFT JOIN bas_emp_account b\n    ON t.sender = b.account_id\n  LEFT JOIN WF_PROCESSDEFINE_PROCESSINST w\n    ON t.processinstid = w.processinstid\n  LEFT JOIN bas_emp_account b2\n    ON w.creator = b2.account_id\n WHERE t.is_use = 'Y'\n");
        Subject currentUser = SecurityUtils.getSubject();
        if (currentUser.hasRole("ORG_KJ")) {
            sql.append("   and t.form_code not in('FmPayTotal','FmReceiveTotal','FmInvoiceOutApply')\n");
        }
        sql.append("   and r.account_id = #accountid#\n   AND t.msg_type NOT IN (3, 4, 5) \n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountid);
        if (StrKit.notBlank(search)) {
            sql.append("  and (    upper(t.MSG_TITLE) like #search#  or upper(b.account_name) like #search# ) ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.SENDTIME desc ");
        List<Map<String, Object>> list = this.bSqlHelper.serachBySql(sql.toString(), params);
        Map<String, IBasMessageAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageAdditional.class);
        for (String key : map.keySet()) {
            IBasMessageAdditional bma = map.get(key);
            list.addAll(0, bma.getMsgList().stream().map(t -> {
                try {
                    return PropertyUtils.describe((Object)t);
                }
                catch (Exception e) {
                    return new HashMap();
                }
            }).filter(a -> a.get("msgTitle") != null).collect(Collectors.toList()));
        }
        return list;
    }

    public List<Map<String, Object>> PageToDoList(Long accountid, String search, String subject, String startDate, String endDate) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT t.*,\n       b.account_name  AS account_Name,getdeptname(b.dept_id) dept_name,\n       b2.account_name AS creator,\n       r.is_read       AS is_read\n  FROM BAS_MESSAGE t\n  left join (SELECT r.msg_id, r.account_id, r.is_read\n               FROM BAS_MESSAGE_RECEIVE r\n              where r.is_deal = 'N'\n             UNION\n             SELECT s.msg_id, a.agent_account, e.is_read\n               FROM WF_AGENT            a,\n                    gen_form            f,\n                    bas_message         s,\n                    bas_message_receive e\n              WHERE s.form_code = f.form_code\n                AND s.msg_id = e.msg_id\n                AND e.account_id = a.agent_to_account\n                AND s.is_use = 'Y'\n                AND e.is_deal = 'N'\n                AND a.is_use = 'Y'\n                AND ((concat('%,' , a.agent_content , ',%')) LIKE\n                    (concat('%,' , f.flow_cat_id , ',%')) AND\n                    a.end_date > now() AND\n                    (a.cancel_date IS NULL OR a.cancel_date > now()) OR\n                    a.agent_type = '2')) r\n    on r.msg_id = t.msg_id\n  LEFT JOIN bas_emp_account b\n    ON t.sender = b.account_id\n  LEFT JOIN WF_PROCESSDEFINE_PROCESSINST w\n    ON t.processinstid = w.processinstid\n  LEFT JOIN bas_emp_account b2\n    ON w.creator = b2.account_id\n WHERE t.is_use = 'Y'\n");
        Subject currentUser = SecurityUtils.getSubject();
        if (currentUser.hasRole("ORG_KJ")) {
            sql.append("   and t.form_code not in('FmPayTotal','FmReceiveTotal','FmInvoiceOutApply')\n");
        }
        if (!StringUtil.isEmpty(startDate) && !StringUtil.isEmpty(endDate)) {
            sql.append("   and  DATE_FORMAT(SENDTIME,'%Y-%m-%d') BETWEEN  '" + startDate + "' and '" + endDate + "' \n");
        }
        if (StringUtil.isNotEmpty(subject)) {
            sql.append("   and  MSG_TITLE like  '%" + subject + "%' \n");
        }
        sql.append("   and r.account_id = #accountid#\n   AND t.msg_type NOT IN (3, 4, 5) \n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountid);
        if (StrKit.notBlank(search)) {
            sql.append("  and (    upper(t.MSG_TITLE) like #search#  or upper(b.account_name) like #search# ) ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.SENDTIME desc ");
        List<Map<String, Object>> list = this.bSqlHelper.serachBySql(sql.toString(), params);
        return list;
    }

    public PageObject PageToDoListApp(Long accountid, String itemTypeId, String search, Integer page, Integer rows) {
        PageObject pageobject = new PageObject();
        StringBuffer sql = new StringBuffer();
        sql.append("select c.app_url,\n       t.*,\n       b1.account_name accountName,\n       w.PROCESSDEFNAME,\n       case c.is_app when 'Y' then  nvl2(c.app_url, 1, 2) else  3 end MSG_FLAG,\n       r.is_read,\n       (\twith recursive temp as(\n\t\t select a.* from STF_BUSINESS_TYPE a where  a.res_id = s.business_type_id\n\t\t union all\n\t\t select a.* from STF_BUSINESS_TYPE a,temp t where t.PARENT_ID=a.RES_ID  ) \n\t\t select name from temp where PARENT_ID=0) item_type\n  from BAS_MESSAGE t\n  left join (SELECT r.msg_id, r.account_id, r.is_read\n               FROM BAS_MESSAGE_RECEIVE r\n              where r.is_deal = 'N'\n             UNION\n             SELECT s.msg_id, a.agent_account, e.is_read\n               FROM WF_AGENT            a,\n                    gen_form            f,\n                    bas_message         s,\n                    bas_message_receive e\n              WHERE s.form_code = f.form_code\n                AND s.msg_id = e.msg_id\n                AND e.account_id = a.agent_to_account\n                AND s.is_use = 'Y'\n                AND e.is_deal = 'N'\n                AND a.is_use = 'Y'\n                AND (concat('%,',a.agent_content ,',%') LIKE\n                   concat('%,' ,f.flow_cat_id,',%') AND\n                    a.end_date > now() AND\n                    (a.cancel_date IS NULL OR a.cancel_date > now()) OR\n                    a.agent_type = '2')) r\n    on r.msg_id = t.msg_id\n  left join bas_emp_account b1\n    on t.sender = b1.account_id\n  left join wf_processinst p\n    on p.processinstid = t.processinstid\n  left join stf_business_process s\n    on s.design_name = p.processinstname\n  left join GEN_FORM c\n    on t.form_code = c.form_code\n   and c.is_use = 'Y'\n inner join wf_processdefine_processinst w\n    on t.processinstid = w.processinstid\n where t.is_use = 'Y'\n   and t.msg_type not in (3, 4, 5)\n   and r.account_id = :accountid \n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountid);
        if (StrKit.notBlank(itemTypeId)) {
            params.put("itemTypeId", itemTypeId);
            sql.append(" and (select y.res_id from stf_business_type y where y.parent_id = 0 start with y.res_id = s.business_type_id connect by y.res_id = prior y.parent_id)=:itemTypeId \n");
        }
        if (StrKit.notBlank(search)) {
            sql.append("  and (    upper(t.MSG_TITLE) like :search  or upper(b.account_name) like :search ) \n");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.SENDTIME desc ");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, page, rows);
        return pageobject;
    }

    public PageObject pageHaveDoneList(String isBusiness, Long accountid, String startDate, String endDate, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        StringBuffer sql = new StringBuffer();
        sql.append("with temp as\n (select z.*\n    from (select q1.msg_id,\n                 ROW_NUMBER() over(PARTITION by q1.processinstid ORDER BY q1.msg_id DESC) as ro\n            from BAS_MESSAGE q1, BAS_MESSAGE_RECEIVE q2\n           where q1.msg_id = q2.msg_id\n             and q2.account_id = :accountid\n             and q2.is_deal = 'Y') z\n   where z.ro = 1),\nperson as\n (select group_concat(s.participant) participant,\n         group_concat(distinct s.workitemname) workitemname,\n         s.processinstid\n    from (select p.participant, tt.workitemname, tt.processinstid\n            from WF_WORKITEM tt, WF_PARTICIPANT p\n           where tt.currentstate in (4, 10)\n             and p.partictype = 'role'\n             and tt.workitemid = p.workitemid\n          union all\n          select p.participant, workitemname, tt.processinstid\n            from WF_WORKITEM tt, WF_PARTICIPANT p\n           where tt.currentstate in (4, 10)\n             and p.partictype = 'person'\n             and tt.workitemid = p.workitemid) s\n   group by s.processinstid)\nselect a.MSG_ID,\n       a.processinstid,\n       a.MSG_TITLE,\n\t\ta.msg_url,\n       a.msg_type,\n       a.form_code,\n       a.busi_main_id,\n       DATE_FORMAT(a.sendtime,'%Y-%m-%d %H:%i:%s') AS SENDTIME,\n       DATE_FORMAT(t.deal_time,'%Y-%m-%d %H:%i:%s') as deal_time,\n       b.account_name,\n       getaccountname(p.participant) AS receive_By,\n       p.workitemname workitemname\n  from temp, BAS_MESSAGE_RECEIVE t\n  left join BAS_MESSAGE a\n    on t.msg_id = a.msg_id\n  left join bas_emp_account b\n    on a.sender = b.account_id\n  left join person p\n    on p.processinstid = a.processinstid\n where t.account_id = :accountid\n   and t.is_deal = 'Y'\n   and temp.msg_id = t.msg_id\n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountid);
        if (StrKit.notBlank(startDate)) {
            sql.append("\tand DATE_FORMAT(t.deal_time,'%Y-%m-%d') >= :startDate \n");
            params.put("startDate", startDate);
        }
        if (StrKit.notBlank(endDate)) {
            sql.append("\tand DATE_FORMAT(t.deal_time,'%Y-%m-%d') <= :endDate \n");
            params.put("endDate", endDate);
        }
        if (StrKit.notBlank(search)) {
            sql.append("  and (    upper(a.MSG_TITLE) like :search  or upper(b.account_name) like :search ) ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by ifnull(t.DEAL_TIME,now()) desc ");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("MSG_TYPE", "MSG_TYPE");
        dicmapper.put("BUSI_TYPE", "BUSINESS_TYPE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<BasMessage> queryHaveDoneList(Long accountid, String search, int page, int rows) {
        StringBuffer sql = new StringBuffer();
        sql.append("with temp\nas\n(\n  select z.* from\n     (select q1.msg_id,ROW_NUMBER() over(PARTITION by q1.processinstid ORDER BY q1.msg_id DESC) as ro\n     from BAS_MESSAGE q1,BAS_MESSAGE_RECEIVE q2, wf_processinst wp where q1.msg_id = q2.msg_id and q1.processinstid = wp.processinstid and wp.currentstate <> 7 and q2.account_id = #accountid# and q2.is_deal = 'Y'\n     ) z\n  where z.ro = 1),\nperson as\n (select group_concat(s.participant) participant,\n         group_concat(distinct s.workitemname) workitemname,\n         s.processinstid\n    from (select p.participant, tt.workitemname, tt.processinstid\n            from WF_WORKITEM tt, WF_PARTICIPANT p\n           where tt.currentstate in (4, 10)\n             and p.partictype = 'role'\n             and tt.workitemid = p.workitemid\n          union all\n          select p.participant, workitemname, tt.processinstid\n            from WF_WORKITEM tt, WF_PARTICIPANT p\n           where tt.currentstate in (4, 10)\n             and p.partictype = 'person'\n             and tt.workitemid = p.workitemid) s\n   group by s.processinstid)\n select * from( select a.*,case when p.workitemname='' then '\u7ed3\u675f' when p.workitemname is null then '\u7ed3\u675f' else p.workitemname end as workitemname,DATE_FORMAT(t.deal_time,'%Y-%m-%d %H:%i:%s') as dealtime   from temp,BAS_MESSAGE_RECEIVE t\n  left join BAS_MESSAGE a\n    on t.msg_id = a.msg_id\n  left join bas_emp_account b\n    on a.sender = b.account_id\n  left join person p\n    on p.processinstid = a.processinstid\n   where  t.account_id=#accountid# and t.is_deal='Y' and temp.msg_id = t.msg_id\n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountid);
        if (StrKit.notBlank(search)) {
            sql.append("  and (    upper(a.MSG_TITLE) like #search#  or upper(b.account_name) like #search# ) ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by ifnull(t.DEAL_TIME,now()) desc ");
        sql.append(" )t   limit #largenum#,#bignum# ");
        params.put("largenum", (page - 1) * rows);
        params.put("bignum", page * rows);
        List<BasMessage> list = this.bSqlHelper.serachBySql(sql.toString(), params, BasMessage.class);
        return list;
    }

    public PageObject pageHaveDoneListApp(Long accountid, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        StringBuffer sql = new StringBuffer();
        sql.append("select c.app_url,a.MSG_ID,a.processinstid,a.MSG_TITLE,a.msg_type,a.form_code,a.busi_main_id,DATE_FORMAT(a.sendtime,'yyyy-mm-dd %H:%i:%s') AS SENDTIME,DATE_FORMAT(t.deal_time,'%Y-%m-%d %H:%i:%s') as deal_time,b.account_name\n  from BAS_MESSAGE_RECEIVE t\n  left join BAS_MESSAGE a\n    on t.msg_id = a.msg_id\n  left join bas_emp_account b\n    on a.sender = b.account_id\n inner join GEN_FORM c on a.FORM_code = c.FORM_code and c.is_app = 'Y' \n inner join wf_processdefine_processinst  w  on a.PROCESSINSTID = w.PROCESSINSTID \n   where  t.account_id=:accountid and t.is_deal='Y' \n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountid);
        if (StrKit.notBlank(search)) {
            sql.append("  and (    upper(a.MSG_TITLE) like :search  or upper(b.account_name) like :search ) ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.DEAL_TIME desc nulls last ");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        return pageobject;
    }

    public PageObject pageAccountMessageList(Long accountid, String msgType, String isRead, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        StringBuffer sql = new StringBuffer();
        sql.append("select a.MSG_ID,a.processinstid,a.MSG_TITLE,a.msg_type,a.form_code,a.busi_main_id,a.msg_url msg_url,t.is_read,DATE_FORMAT(a.sendtime,'%Y-%m-%d %H:%i:%s') as send_time,b.account_name\n  from BAS_MESSAGE_RECEIVE t\n  left join BAS_MESSAGE a\n    on t.msg_id = a.msg_id\n  left join bas_emp_account b\n    on a.sender = b.account_id\n   where  t.account_id=:accountid  and a.is_use = 'Y'");
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)isRead)) {
            sql.append("and t.IS_READ=:isRead ");
            params.put("isRead", isRead);
        }
        if (StringUtils.isNotEmpty((String)msgType)) {
            sql.append("and a.msg_type=:msgType ");
            params.put("msgType", msgType);
        } else {
            sql.append("and a.msg_type=:msgType ");
            params.put("msgType", SysContent.MSG_ALERT);
        }
        params.put("accountid", accountid);
        if (StrKit.notBlank(search)) {
            sql.append("  and upper(a.MSG_TITLE) like :search ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.is_read, a.sendtime desc");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<BasMessage> getMessageWarnAlert(Long accountid, String search) {
        ArrayList<BasMessage> messageList = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append("select a.*\n  from BAS_MESSAGE_RECEIVE t\n  left join BAS_MESSAGE a\n    on t.msg_id = a.msg_id\n  left join bas_emp_account b\n    on a.sender = b.account_id\n   where  t.account_id=:accountid and a.msg_type = " + SysContent.MSG_WARN + " and a.is_use = 'Y'");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountid);
        if (StrKit.notBlank(search)) {
            sql.append("  and upper(a.MSG_TITLE) like :search ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.is_read, a.sendtime desc");
        messageList = this.sqlHelper.queryByNativeSQL(sql.toString(), params, BasMessage.class, new int[0]);
        return messageList;
    }

    public List<BasMessage> findAccountWarningList(Long accountid, String search) {
        ArrayList<BasMessage> msglist = new ArrayList<BasMessage>();
        List<BasMessage> messagelist = this.getMessageWarnAlert(accountid, search);
        msglist.addAll(messagelist);
        Collections.sort(msglist);
        return msglist;
    }

    public void saveMessage(Long processInstId, String msgTitle, String params, List<Long> reciveIds, String msgUrl, String msgytype, String formCode, String businessMainId) {
        this.saveMessage(processInstId, null, msgTitle, params, SysUtils.getLoginAccountId(), reciveIds, msgUrl, msgytype, formCode, businessMainId, null, null, true);
    }

    public void saveMessage(Long processInstId, Long workitemid, String msgTitle, String params, Long accountid, List<Long> reciveIds, String msgUrl, String msgytype, String formCode, String businessMainId, Long msglevel, String listUrl, boolean isSendDD) {
        if (msgTitle != null) {
            msgTitle = msgTitle.replaceAll("\t|\r|\n", "");
        }
        BasMessage basMessage = new BasMessage();
        basMessage.setProcessinstid(processInstId);
        basMessage.setWorkitemid(workitemid);
        basMessage.setMsgTitle(msgTitle);
        basMessage.setMsgUrl(msgUrl);
        basMessage.setBusiMainId(businessMainId);
        basMessage.setFormCode(formCode.toString());
        basMessage.setSender(accountid);
        basMessage.setSendtime(new Date());
        basMessage.setMsgType(Long.parseLong(msgytype));
        basMessage.setBusiType(0L);
        basMessage.setIsPublic("Y");
        basMessage.setIsUse("Y");
        basMessage.setMsgLevel(msglevel == null ? SysContent.MSG_LEVEL_0 : msglevel);
        basMessage.setMsgParams(params);
        BasMessage message = (BasMessage)this.basmessageDao.save(basMessage);
        String sendername = "";
        if (accountid != null) {
            sendername = this.basEmpAccountService.findById(accountid).getAccountName();
        }
        isSendDD = processInstId != null && isSendDD;
        loger.error((Object)("\u6267\u884c\u6d41\u7a0b\u751f\u6210\u6d88\u606f\u7684\u76f8\u5173\u4fe1\u606f:" + JSON.toJSONString((Object)message)));
        this.saveMsgDetail(message, reciveIds, msgTitle, listUrl, sendername, isSendDD, processInstId, formCode, businessMainId);
    }

    public void saveMsgDetail(BasMessage message, List<Long> reciveIds, String msgTitle, String listUrl, String sendername, boolean isFlow, Long processInstId, String formCode, String businessMainId) {
        ArrayList<String> clientIds = new ArrayList<String>(reciveIds.size());
        for (Long reciveId : reciveIds) {
            String userId;
            BasMessageReceive basMessageDetail = new BasMessageReceive();
            basMessageDetail.setMsgId(message.getMsgId());
            basMessageDetail.setAccountId(reciveId);
            basMessageDetail.setIsDeal("N");
            basMessageDetail.setIsRead("N");
            this.basMessageReceiveDao.save(basMessageDetail);
            BasEmpAccount bea = this.basEmpAccountService.findById(reciveId);
            List<BasDeviceUser> devs = this.BasDeviceUserDao.findByAccountIdOrderByIdDesc(reciveId);
            if (!devs.isEmpty()) {
                clientIds.add(devs.get(0).getClientId());
            }
            if ((userId = bea.getReserveUser1()) == null || userId.equals("") || !isFlow) continue;
            loger.info((Object)("\u9489\u9489\u7528\u6237id=" + userId));
            if (SysContent.MSG_ALERT.equals(message.getMsgType())) {
                isFlow = false;
            }
            this.sendMsg(userId, msgTitle, listUrl, sendername, isFlow, message.getMsgId(), processInstId, formCode, businessMainId);
        }
        JSONObject json = new JSONObject();
        json.put("businessMainId", (Object)businessMainId);
        json.put("msgId", (Object)message.getMsgId());
        json.put("formCode", (Object)message.getFormCode());
        json.put("processid", (Object)message.getProcessinstid());
        try {
            AppPush.pushToList("\u60a8\u6709\u4e00\u6761\u65b0\u7684\u6d88\u606f", msgTitle, json.toJSONString(), clientIds);
        }
        catch (Exception e) {
            loger.error((Object)("app\u63a8\u9001\u5f02\u5e38:" + json.toJSONString()), (Throwable)e);
        }
    }

    public void sendMsg(String userIds, String title, String listUrl, String sendername, boolean isFlow, long msgId, long processInstId, String formCode, String businessMainId) {
    }

    public void delMydealByWorkitemid(Long workitemid, Long accountid, String follows) {
        String sql = "SELECT d.*\n  FROM bas_message t,\n       bas_message_receive d\n WHERE  d.account_id=?2\n   and d.is_deal='N'\n\tand t.msg_id=d.msg_id\n\tand t.workitemid=?1\n";
        List list = this.sqlHelper.queryByNativeSQL(sql, new Object[]{workitemid, accountid}, BasMessageReceive.class, new int[0]);
        HashMap<Long, Long> ids = new HashMap<Long, Long>();
        if (!list.isEmpty()) {
            BasMessageReceive detail = (BasMessageReceive)list.get(0);
            ids.put(detail.getMsgId(), accountid);
            detail.setIsDeal("Y");
            detail.setIsRead("Y");
            detail.setDealTime(new Date());
            this.basMessageReceiveDao.save(detail);
            BasMessage msg = (BasMessage)this.basmessageDao.findById(detail.getMsgId()).get();
            msg.setMsgTitle(msg.getMsgTitle().replace("\u5f85\u5904\u7406", "\u5df2\u5904\u7406"));
            msg.setIsUse("N");
            msg.setFollowType(follows);
            this.basmessageDao.save(msg);
        }
    }

    public void delMydealByProcessinstid(Long processinstid, String businessMainId) {
        List<BasMessage> list = this.basmessageDao.findByProcessinstidAndBusiMainIdAndIsUse(processinstid, businessMainId, "Y");
        for (BasMessage msg : list) {
            msg.setIsUse("N");
        }
        this.basmessageDao.saveAll(list);
    }

    public void delMydealByProcessinstid(Long processinstid) {
        List<BasMessage> list = this.basmessageDao.findByProcessinstid(processinstid);
        for (BasMessage msg : list) {
            msg.setIsUse("N");
        }
        this.basmessageDao.saveAll(list);
    }

    public List<Map<String, Object>> findAccountToDoList(Long accountid) {
        return this.PageToDoList(accountid, null);
    }

    public List<Map<String, Object>> findToDoListForAdm(Long accountid) {
        return this.PageToDoList(accountid, null);
    }

    public BasMessage findMsgByProcessinstid(Long accountid, Long processinstid) {
        if (processinstid == null || accountid == null) {
            return null;
        }
        Long workitemid = this.flowUtilService.getWorkItemId(processinstid);
        if (workitemid == null) {
            return null;
        }
        BasMessage message = this.basmessageDao.findByWorkitemidAndProcessinstidAndIsUse(workitemid, processinstid, "Y");
        return message;
    }

    public HashMap<String, List<BasMessage>> findMsgs() throws ParseException {
        HashMap<String, List<BasMessage>> hashMap = new HashMap<String, List<BasMessage>>();
        StringBuilder sqlMsg = new StringBuilder();
        sqlMsg.append("SELECT t.msg_id,\n       t.msg_title,\n       t.sender senderid,\n       t.msg_url,\n       t.busi_type,\n       p.ACCOUNT_ID reciveid,\n       DATE_FORMAT(t.sendtime,'%Y-%m-%d %H:%i:%s') sendtime\n  FROM bas_message        t,\n       BAS_MESSAGE_RECEIVE p\n WHERE t.msg_id = p.msg_id\n      -- AND t.busi_type IN (0, 1)\n\tand t.is_use='Y' \n   AND p.is_read = 'N'\n ORDER BY t.sendtime DESC");
        List list = this.sqlHelper.queryByNativeSQL(sqlMsg.toString(), new int[0]);
        for (Object o : list) {
            Map row = (Map)o;
            BasMessage basMessage = new BasMessage();
            basMessage.setMsgId(Long.parseLong(row.get("MSG_ID").toString()));
            String titleStr = SysUtils.removeHtmlTag(row.get("MSG_TITLE").toString());
            if (StringUtils.isEmpty((String)titleStr.trim().replaceAll("&nbsp;", ""))) {
                basMessage.setMsgTitle("\u672a\u8bfb\u6d88\u606f");
            } else if (titleStr.length() > 40) {
                basMessage.setMsgTitle(titleStr.substring(0, 39) + "\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7");
            } else {
                basMessage.setMsgTitle(titleStr);
            }
            if (row.get("MSG_URL") != null) {
                basMessage.setMsgUrl(row.get("MSG_URL").toString());
            }
            basMessage.setSender(Long.parseLong(row.get("SENDERID").toString()));
            basMessage.setBusiType(Long.valueOf(row.get("BUSI_TYPE").toString()));
            basMessage.setSendtime(DateUtils.strToTime(row.get("SENDTIME").toString()));
            basMessage.setReciveId(Long.parseLong(row.get("RECIVEID").toString()));
            if (!hashMap.keySet().contains(row.get("RECIVEID").toString())) {
                hashMap.put(row.get("RECIVEID").toString(), new ArrayList());
            }
            hashMap.get(row.get("RECIVEID").toString()).add(basMessage);
        }
        return hashMap;
    }

    public BasMessage maintain() {
        StringBuilder sql = new StringBuilder();
        sql.append("select *  from BAS_MESSAGE t where t.is_use='Y' and t.msg_type = 2 and t.sendtime > now() order by t.sendtime desc ");
        Object o = this.sqlHelper.getSingal(sql.toString(), null, BasMessage.class);
        if (o != null) {
            return (BasMessage)o;
        }
        return null;
    }

    public void setMsgIsRead(Long accountid, Long msgid) {
        List<BasMessageReceive> receivelist = this.basMessageReceiveDao.findByAccountIdAndMsgId(accountid, msgid);
        for (BasMessageReceive basMessageReceive : receivelist) {
            basMessageReceive.setIsRead("Y");
            basMessageReceive.setReadTime(new Date());
            this.basMessageReceiveDao.save(basMessageReceive);
        }
    }

    public void setMsgIsRead(Long accountid) {
        List<BasMessageReceive> receivelist = this.basMessageReceiveDao.findByAccountId(accountid);
        for (BasMessageReceive basMessageReceive : receivelist) {
            basMessageReceive.setIsRead("Y");
            basMessageReceive.setReadTime(new Date());
            this.basMessageReceiveDao.save(basMessageReceive);
        }
    }

    public BasMessage findMsgByBizTypeAndBizMainId(Long bizType, String bizMainId) {
        return this.basmessageDao.findByBusiTypeAndBusiMainId(bizType, bizMainId);
    }

    public List<BasMessage> getAccountMessageList(Long accountid, Long type) {
        String sql = "select b.*\n  from bas_message_receive a, bas_message b\n where a.msg_id = b.msg_id\n   and b.msg_type = ?2\n   and a.account_id = ?1\n   and a.is_read = 'N'\n   and b.is_use = 'Y'\n   order by b.sendtime desc";
        return this.sqlHelper.queryByNativeSQL(sql, new Object[]{accountid, type}, BasMessage.class, new int[0]);
    }

    public List<Map<String, Object>> getAccountMessageMapList(Long accountid, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        params.put("type", type);
        String sql = "select b.*,a.is_read,to_char(b.sendtime,'yyyy-mm-dd hh24:mi:ss') sendtime_All,k.PHOTO_VERSION_ID,getaccountname(b.sender) sender_name\n  from bas_message_receive a, bas_message b ,BAS_EMP_ACCOUNT c,hr_emp k,bas_emp h    \n where a.msg_id = b.msg_id\n   and b.msg_type = 3\n   and a.account_id = #accountid#\n" + (type.equals("A") ? "\n" : "and a.is_read = #type#  \n") + "   and b.is_use = 'Y' and  c.EMP_ID=h.EMP_ID AND b.sender=c.ACCOUNT_ID and h.hr_emp_id=k.emp_id \n   order by b.sendtime desc";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public List<Map<String, Object>> getMsgInfoByCodeAndType(Long accountid, String formCode, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        params.put("formCode", formCode);
        params.put("type", type);
        String sql = "select b.*,a.is_read,to_char(b.sendtime,'yyyy-mm-dd hh24:mi:ss') sendtime_All,k.PHOTO_VERSION_ID,getaccountname(b.sender) sender_name\n  from bas_message_receive a, bas_message b ,BAS_EMP_ACCOUNT c,hr_emp k,bas_emp h    \n where a.msg_id = b.msg_id\n   and b.msg_type = 3  and ifnull(a.IS_SHOW, 'Y') !='N' \n   and a.account_id = #accountid#\n" + (type.equals("A") ? "\n" : "and a.is_read = #type# \n") + "   and b.is_use = 'Y' and b.FORM_CODE=#formCode# and b.PROCESSINSTID is null and  c.EMP_ID=h.EMP_ID AND b.sender=c.ACCOUNT_ID and h.hr_emp_id=k.emp_id\n   order by b.sendtime desc";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public List<Map<String, Object>> getMsgInfoAll(Long accountid, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        params.put("type", type);
        String sql = "select b.*,a.is_read,date_format(b.sendtime,'%Y-%m-%d %H:%i:%s') sendtime_All,d.FORM_NAME AS MSG_TYPE_NAME,k.PHOTO_VERSION_ID,getaccountname(b.sender) sender_name,NVL2(b.PROCESSINSTID, 'liucheng',d.icon ) ICON\r\n  from bas_message_receive a, bas_message b ,BAS_EMP_ACCOUNT c,hr_emp k,bas_emp h,GEN_FORM d    \n where a.msg_id = b.msg_id\n   and b.msg_type = 3 and ifnull(a.IS_SHOW, 'Y') !='N' and b.FORM_CODE=d.FORM_CODE \n   and a.account_id = #accountid#\n" + (type.equals("A") ? "\n" : "and a.is_read = #type# \n") + "   and b.is_use = 'Y'   and  c.EMP_ID=h.EMP_ID AND b.sender=c.ACCOUNT_ID and h.hr_emp_id=k.emp_id\n   order by b.sendtime asc";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public void clearMessageList(Long accountid) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        String sql = "UPDATE bas_message_receive a\r\n\t\t\t\tSET a.IS_SHOW = 'N' \r\n\t\t\t\tWHERE\r\n\t\t\t\t\ta.account_id =#accountid# and  a.MSG_ID IN (SELECT MSG_ID FROM BAS_MESSAGE WHERE MSG_TYPE=3 AND IS_USE='Y') \r\n";
        this.bSqlHelper.updateBysql(sql, params);
    }

    public List<Map<String, Object>> getAccountMessageMapInfo(Long accountid) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        String sql = "SELECT\r\n\tifnull( sum( case  a.is_read when 'Y' then 1 else  0 end), 0 ) 'read',\r\n\tifnull( sum( case  a.is_read when 'N' then  1 else  0 end), 0 ) not_read \r\nFROM\r\n\tBAS_MESSAGE t,\r\n\tBAS_MESSAGE_RECEIVE a \r\nWHERE\r\n\tt.MSG_TYPE = 3 \r\n\tAND t.MSG_ID = a.msg_id \r\n\tAND ifnull( a.IS_SHOW, 'Y' ) != 'N' \r\n\tAND a.ACCOUNT_ID =#accountid# \r\n\tAND t.IS_USE = 'Y'";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public List<Map<String, Object>> getAccountMessageMapInfoToWork(Long accountid) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        String sql = "SELECT\r\n\t\t\t\tsum(decode(is_read,'Y',1,0)) read,sum(decode(is_read,'N',1,0)) not_read\r\n\t\t\t\tFROM\r\n\t\t\t\t\tBAS_MESSAGE t,\r\n\t\t\t\t\tBAS_MESSAGE_RECEIVE a \r\n\t\t\t\tWHERE\r\n\t\t\t\t\tMSG_TYPE = 3  \r\n\t\t\t\t\tAND t.MSG_ID = a.msg_id \r\n\t\t\t\t\tand t.PROCESSINSTID is NOT NULL\r\n\t\t\t\t\tAND a.ACCOUNT_ID =#accountid#\r\n\t\t\t\t\tAND t.IS_USE='Y' and ifnull(a.IS_SHOW, 'Y')!='N' ";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public List<Map<String, Object>> findByformCode(Long accountid) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        String sql = "SELECT\r\nt.*,C.FORM_NAME AS MSG_TYPE_NAME,getaccountname(t.sender) sender_name,DATE_FORMAT(t.sendtime,'%Y-%m-%d %H:%i:%s') sendTime_all\r\nFROM\r\n\tBAS_MESSAGE t,\r\n\tBAS_MESSAGE_RECEIVE a ,GEN_FORM C \r\nWHERE\r\n\tMSG_TYPE = 3 \r\n\tAND t.MSG_ID = a.msg_id and t.FORM_CODE=C.FORM_CODE  \r\n\tAND a.ACCOUNT_ID =#accountid# \r\n\tAND t.IS_USE = 'Y'  AND t.SENDTIME=(SELECT\r\nMAX(t.SENDTIME) \r\nFROM\r\n\tBAS_MESSAGE t,\r\n\tBAS_MESSAGE_RECEIVE a \r\nWHERE\r\n\tMSG_TYPE = 3 \r\n\tAND t.MSG_ID = a.msg_id \r\n\tAND a.ACCOUNT_ID =#accountid# \r\n\tAND t.IS_USE = 'Y'  )";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public List<Map<String, Object>> findByMaxMsg(Long accountId) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountId", accountId);
        String sql = "SELECT\r\nt.*,C.FORM_NAME AS MSG_TYPE_NAME,getaccountname(t.sender) sender_name,to_char(t.sendtime,'yyyy-mm-dd hh24:mi:ss') sendTime_all\r\nFROM\r\n\tBAS_MESSAGE t,\r\n\tGEN_FORM C \r\nWHERE\r\n t.SENDTIME = (\r\n\tSELECT\r\n\t\tmax( t.SENDTIME ) \r\n\tFROM\r\n\t\tBAS_MESSAGE t,\r\n\t\tBAS_MESSAGE_RECEIVE a \r\n\tWHERE\r\n\t\tMSG_TYPE = 3 \r\n\t\tAND t.MSG_ID = a.msg_id \r\n\t\tAND t.PROCESSINSTID IS NOT NULL \r\n\t\tAND a.ACCOUNT_ID =#accountId# \r\n\tAND t.IS_USE = 'Y' \r\n\t)\t\r\n and t.FORM_CODE=C.FORM_CODE  ";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public void setAccountMessageAllReaded(Long accountid, String msgId) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        params.put("msgId", msgId);
        String sqlWhere = "a.msg_id = #msgId#\n";
        if (msgId == null) {
            sqlWhere = "a.msg_id in (select msg_id from bas_message b where b.msg_type = 3 and b.is_use = 'Y')\n";
        }
        String sql = "update bas_message_receive a\n   set a.is_read = 'Y', a.read_time = now()\n   where\n " + sqlWhere + "   and a.account_id = #accountid#\n   and a.is_read = 'N'";
        this.bSqlHelper.updateBysql(sql, params);
    }

    public void setAccountMessageFormReaded(Long accountid, String formCode) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        params.put("formCode", formCode);
        String sql = "update bas_message_receive a\n   set a.is_read = 'Y', a.read_time = sysdate\n   where\n    a.account_id = #accountid# and a.msg_id in (select b.msg_id from bas_message b where b.msg_type=3 and b.is_use='Y' and b.FORM_CODE=#formCode# and b.PROCESSINSTID is null)\n   and a.is_read = 'N'";
        this.bSqlHelper.updateBysql(sql, params);
    }

    public void setAccountMessageWorkReaded(Long accountid) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        String sql = "update bas_message_receive a\n   set a.is_read = 'Y', a.read_time = sysdate\n   where\n     a.account_id = #accountid# and a.msg_id in (select b.msg_id from bas_message b where b.msg_type=3 and b.is_use='Y' and b.PROCESSINSTID is not null) \n   and a.is_read = 'N'";
        this.bSqlHelper.updateBysql(sql, params);
    }

    public List<Map<String, Object>> getAccountMessageMapList(Long accountid, String type, String queryFormCode, String search) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        params.put("type", type);
        String tempSql = "";
        if (StrKit.notNull(queryFormCode)) {
            params.put("queryFormCode", queryFormCode);
            tempSql = tempSql + " and b.form_code = #queryFormCode# \n";
        }
        if (StrKit.notNull(search)) {
            params.put("search", "%" + search + "%");
            tempSql = tempSql + "   and b.msg_title like #search#\n";
        }
        String sql = "select b.*,a.is_read,GETACCOUNTNAME(a.account_id) account_name\n  from bas_message_receive a, bas_message b\n where a.msg_id = b.msg_id\n   and b.msg_type =3\n" + tempSql + "   and a.account_id = #accountid#\n" + (type.equals("A") ? "\n" : "and a.is_read = #type# \n") + "   and b.is_use = 'Y'\n   order by b.sendtime desc";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public List<BasMessage> getAccountMessageAndWarnMapList(Long accountid, String type, String queryFormCode, String search, String msgType) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        params.put("type", type);
        params.put("search", "%" + search + "%");
        String sql = "select b.*,a.is_read,GETACCOUNTNAME(a.account_id) account_name\n ,case when a.is_read = 'Y' then '\u5df2\u8bfb' when a.is_read = 'N'  then '\u672a\u8bfb' end as is_read_text\n  from bas_message_receive a, bas_message b\n where a.msg_id = b.msg_id\n   and b.msg_type =3\n   and b.msg_title like #search#\n   and a.account_id = #accountid#\n" + (type.equals("A") ? "\n" : "and a.is_read = #type# \n") + "   and b.is_use = 'Y'\n   order by b.sendtime desc";
        return this.bSqlHelper.serachBySql(sql, params, BasMessage.class);
    }

    public void saveMessageList(String formCode, String title, String msgUrl, Long sender, Long receiveId, String busiMainId) {
        BasMessage message = new BasMessage();
        message.setMsgTitle(title);
        message.setMsgType(SysContent.MSG_ALERT);
        message.setMsgUrl(msgUrl);
        message.setSender(sender);
        message.setBusiType(SysContent.APP_TYPE_IOP);
        message.setIsPublic("Y");
        message.setBusiMainId(busiMainId);
        message.setFormCode(formCode);
        message.setIsUse("Y");
        this.saveBasMessage(message);
        BasMessageReceive receive = new BasMessageReceive();
        receive.setAccountId(receiveId);
        receive.setIsRead("N");
        receive.setIsDeal("N");
        receive.setMsgId(message.getMsgId());
        this.basMessageReceiveDao.save(receive);
    }

    public List<BasMessage> findHYRentContractList(Long accountid) {
        ArrayList<BasMessage> msglist = new ArrayList<BasMessage>();
        Collections.sort(msglist);
        return msglist;
    }

    public Object isHaveTodo(Long accountId1) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (accountId1 != null) {
            params.put("accountId1", accountId1);
        }
        return this.bSqlHelper.getLongValue("business.hr.HrEmp.isHaveTodo", params);
    }

    public PageObject pageBaseFlowSendInfo(String search, int page, int rows, String status) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search + "%");
        }
        if (!StringUtils.isEmpty((String)status)) {
            params.put("status", status);
        }
        params.put("admin", SysContent.ADMIN_ACCOUNT_ID);
        return this.bSqlHelper.serachPage("base.BasMessage.BaseFlowSendInfo", params, PageRequest.of((int)page, (int)rows));
    }

    public List<BasMessage> findByformCodeAndbusiMainId(Long id, String formCode) {
        return this.basmessageDao.findByBusiMainIdAndFormCodeAndIsUse(id.toString(), formCode, "Y");
    }

    public Object getMyFlow(Long accountId, String myFLow) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (accountId == null) {
            accountId = SysUtils.getLoginAccountId();
        }
        params.put("accountId", accountId);
        if (StrKit.notBlank(myFLow)) {
            params.put("myFLow", myFLow);
        }
        return this.bSqlHelper.getStringValue("base.BasMessage.getMyFlow", params);
    }

    public JsonMsg sendurge(String actId, Long processInstId, String ids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processInstId", processInstId);
        params.put("actId", actId);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("business.hr.HrEmp.getUndoEmpMobileByProcessinstId", params);
        if (list.isEmpty()) {
            return new JsonMsg("\u6ca1\u6709\u627e\u5230\u53ef\u4ee5\u53d1\u9001\u77ed\u4fe1\u7684\u8054\u7cfb\u4eba");
        }
        ArrayList<String> mobiles = new ArrayList<String>(list.size() + 1);
        String msgTitle = Objects.toString(list.get(0).get("msgTitle"), "");
        list.stream().forEach(p -> {
            if (("," + ids + ",").contains("," + Objects.toString(p.get("accountId"), "") + ",")) {
                mobiles.add(Objects.toString(p.get("mobilephone"), ""));
            }
        });
        return this.smsManagerService.sendSms(mobiles, SysUtils.getLoginUser().getAccountName() + "\u5411\u60a8\u53d1\u9001\u4e86\u4e00\u6761\u667a\u7ba1\u5e73\u53f0\u5f85\u529e\u50ac\u529e\uff1a" + msgTitle + "\u3002\u8bf7\u60a8\u5c3d\u5feb\u5904\u7406\uff01");
    }

    public List<Map<String, Object>> getUrgePersons(String actId, Long processInstId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processInstId", processInstId);
        params.put("actId", actId);
        return this.bSqlHelper.getMapList("business.hr.HrEmp.getUndoEmpMobileByProcessinstId", params);
    }

    public List<Map<String, Object>> getUndoAccounts(Long processinstid) {
        String sql = "select t.msg_title,\nt.msg_id,\n       getaccountname(r.account_id) account_name,p.processinstname,\n       r.account_id,\n       t.workitemid,\n      w.workitemname\n  from BAS_MESSAGE t, bas_message_receive r,wf_workitem w,Wf_Processinst p\n where t.msg_id = r.msg_id\n   and w.workitemid=t.workitemid\n   and t.is_use = 'Y'\n   and t.msg_type = 1\n   AND w.processinstid =p.processinstid    AND t.processinstid =#processinstid# ";
        return this.bSqlHelper.serachBySql(sql, MapUtil.of((Object)"processinstid", (Object)processinstid));
    }

    public void updateMsgAccount(Long workitemid, Long accountId, Long msgId, Long newaccountId, String newActId, String newActName) {
        String sql;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("workitemid", workitemid);
        params.put("accountId", accountId);
        BasMessage msg = (BasMessage)this.basmessageDao.findById(msgId).get();
        params.put("msgId", msgId);
        params.put("processinstid", msg.getProcessinstid());
        if (newaccountId != null) {
            params.put("newaccountId", newaccountId);
            params.put("newaccountName", this.basEmpAccountService.findById(newaccountId).getAccountName());
            sql = "update bas_message_receive t set t.account_id=#newaccountId# where t.msg_id=#msgId# and t.account_id=#accountId#";
            this.bSqlHelper.updateBysql(sql, params);
            sql = "update WF_WORKITEM t set t.participant=#newaccountId# where t.workitemid=#workitemid#";
            this.bSqlHelper.updateBysql(sql, params);
            sql = "update wf_participant t set t.participant=#newaccountId#,participant2=#newaccountName# where t.workitemid=#workitemid#";
            this.bSqlHelper.updateBysql(sql, params);
        }
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{newActId, newActName})) {
            params.put("newActId", newActId);
            params.put("newActName", newActName);
            sql = "update WF_WORKITEM t set t.activitydefid=#newActId#,t.workitemname=#newActName# where t.workitemid=#workitemid#";
            this.bSqlHelper.updateBysql(sql, params);
            sql = "update wf_transctrl r set r.destactdefid=#newActId#,r.destactdefname=#newActName#  where r.transctrlid in( select x.transctrlid from (select max(t.transctrlid) transctrlid from  wf_transctrl t where t.processinstid=#processinstid# and t.destactdefid=(select w.activitydefid from wf_workitem w where w.workitemid=#workitemid#))x)";
            this.bSqlHelper.updateBysql(sql, params);
            sql = "update wf_activityinst t set  t.activitydefid=#newActId#,t.activityinstname=#newActName#  where t.activityinstid in(select x.activityinstid from (select w.activityinstid from wf_workitem w where w.workitemid=#workitemid#)x)";
            this.bSqlHelper.updateBysql(sql, params);
        }
    }

    public void updateMsgDeal(Long processinstid, Long day) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processinstid", processinstid);
        if (day == null) {
            day = 2L;
        }
        params.put("day", day);
        String sql = "update WF_WORKITEM t set t.endtime=t.endtime-#day#,t.starttime=t.starttime-#day# where t.processinstid=#processinstid#\n";
        this.bSqlHelper.updateBysql(sql, params);
        sql = "update wf_transctrl t set t.transtime=t.transtime-#day# where t.processinstid=#processinstid#\n";
        this.bSqlHelper.updateBysql(sql, params);
        sql = "update wf_activityinst t set t.endtime=t.endtime-#day#,t.starttime=t.starttime-#day#,t.createtime=t.createtime-#day# where t.processinstid=#processinstid#";
        this.bSqlHelper.updateBysql(sql, params);
        sql = "update bas_message t set t.sendtime=t.sendtime-#day# where t.processinstid=#processinstid#";
        this.bSqlHelper.updateBysql(sql, params);
        sql = "update bas_message_receive t set t.read_time=t.read_time-#day#,t.deal_time=t.deal_time-#day#  where t.msg_id in( select t.msg_id from bas_message t where t.processinstid=#processinstid#)";
        this.bSqlHelper.updateBysql(sql, params);
    }

    public void msgUrgeAuto() {
        String sql = "select  t.*\n  from bas_message t, bas_message_receive r\n where t.msg_id = r.msg_id\n   and ((t.msg_level = '0' and (now() - t.sendtime) * 24 <= 23) or\n       (t.msg_level = '1' and (now() - t.sendtime) * 24 <= 2.5 ))\n   and t.is_use = 'Y'\n";
        List<BasMessage> msgs = this.bSqlHelper.serachBySql(sql, new HashMap<String, Object>(), BasMessage.class);
        for (BasMessage msg : msgs) {
            this.pushMsgReminde(msg);
        }
    }

    public void pushMsgReminde(BasMessage msg) {
        try {
            String msgTitle = "";
            Date sendTime = msg.getSendtime();
            if ("0".equals(String.valueOf(msg.getMsgLevel()))) {
                sendTime = DateUtils.addHours(sendTime, 23);
                msgTitle = "\u60a8\u6709\u4e00\u6761\u5f85\u529e1\u5c0f\u65f6\u540e\u5373\u5c06\u5230\u671f";
            } else if ("1".equals(String.valueOf(msg.getMsgLevel()))) {
                sendTime = DateUtils.addSecond(sendTime, 150);
                msgTitle = "\u60a8\u6709\u4e00\u6761\u52a0\u6025\u5f85\u529e\u534a\u5c0f\u65f6\u540e\u5373\u5c06\u5230\u671f";
            } else if ("2".equals(String.valueOf(msg.getMsgLevel()))) {
                sendTime = new Date();
                msgTitle = "\u60a8\u6709\u4e00\u6761\u7279\u6025\u5f85\u529e\u6025\u9700\u5904\u7406";
            }
            JSONObject json = new JSONObject();
            json.put("businessMainId", (Object)msg.getBusiMainId().toString());
            json.put("msgId", (Object)msg.getMsgId());
            json.put("formCode", (Object)msg.getFormCode());
            json.put("processid", (Object)msg.getProcessinstid());
            List<BasMessageReceive> receives = this.basMessageReceiveDao.findByMsgId(msg.getMsgId());
            ArrayList<String> clientIds = new ArrayList<String>();
            for (BasMessageReceive receive : receives) {
                List<BasDeviceUser> devs = this.BasDeviceUserDao.findByAccountIdOrderByIdDesc(receive.getAccountId());
                if (devs.isEmpty()) continue;
                clientIds.add(devs.get(0).getClientId());
            }
            if ("2".equals(String.valueOf(msg.getMsgLevel()))) {
                this.pushMsgReminde(msgTitle, msg.getMsgTitle(), json, clientIds);
            } else {
                SchedulingRunnable schedulingRunnable = new SchedulingRunnable("basMessageService", "pushMsgReminde", msgTitle, msg.getMsgTitle(), json, clientIds);
            }
        }
        catch (Exception e) {
            loger.error((Object)"\u624b\u673a\u7aef\u63a8\u9001\u5931\u8d25:", (Throwable)e);
        }
    }

    public void pushMsgReminde(String title, String msgTitle, JSONObject json, ArrayList<String> clientIds) {
        loger.info((Object)("title:" + title + ",clientIds" + msgTitle + ",clientIds" + json.toJSONString() + ",clientIds" + clientIds));
        AppPush.pushToList(title, msgTitle, json.toJSONString(), clientIds);
    }

    public List<String> getApproActs(String busiMainId, String formCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountId", SysUtils.getLoginAccountId());
        params.put("busiMainId", busiMainId);
        params.put("formCode", formCode);
        return this.bSqlHelper.getList("workflow.flow.getApproActsByBizId", params, String.class);
    }
}

