/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.ComboxNode;
import com.ustc.base.common.util.ComboxUtils;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.dao.BasFinanceOrgRightDao;
import com.ustc.base.entity.BasFinanceOrgRight;
import com.ustc.base.service.CommonService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasFinanceOrgRightService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasFinanceOrgRightDao basfinanceorgrightDao;

    public BasFinanceOrgRight findBasFinanceOrgRight(Long id) {
        BasFinanceOrgRight entity = (BasFinanceOrgRight)this.basfinanceorgrightDao.findById(id).get();
        return entity;
    }

    public void saveBasFinanceOrgRight(BasFinanceOrgRight entity) {
        this.basfinanceorgrightDao.save(entity);
    }

    public void delBasFinanceOrgRight(Long id, Long userId) {
        BasFinanceOrgRight entity = (BasFinanceOrgRight)this.basfinanceorgrightDao.findById(id).get();
        entity.setIsUse("N");
        entity.setModifyAccount(userId);
        entity.setModifyTime(new Date());
        this.basfinanceorgrightDao.save(entity);
    }

    public List<BasFinanceOrgRight> findByAccountid(Long accountid) {
        return this.basfinanceorgrightDao.findByAccountId(accountid);
    }

    public void saveFinanceOrgRight(String accountFinanceId, Long accountid) {
        this.basfinanceorgrightDao.deleteByAccountId(accountid);
        if (StrKit.notBlank(accountFinanceId)) {
            String[] ids;
            for (String id : ids = accountFinanceId.split(",")) {
                if (!StrKit.notBlank(id)) continue;
                Long financeorgid = Long.parseLong(id);
                BasFinanceOrgRight finorg = new BasFinanceOrgRight();
                finorg.setAccountId(accountid);
                finorg.setIsUse("Y");
                finorg.setOrgId(financeorgid);
                finorg.setModifyTime(new Date());
                this.basfinanceorgrightDao.save(finorg);
            }
        }
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select * from BAS_FINANCE_ORG_RIGHT t where t.is_use=:isUse ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and  (");
            sql.append("  upper(t.FINANCE_ORG_RIGHT_ID) like :search ");
            sql.append(" or upper(t.ACCOUNT_ID) like :search ");
            sql.append(" or upper(t.ORG_ID) like :search ");
            sql.append(" or upper(t.MEMO) like :search ");
            sql.append(" or upper(t.MODIFY_ACCOUNT) like :search ");
            sql.append(" or upper(t.MODIFY_TIME) like :search ");
            sql.append(" or upper(t.IS_USE) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.FINANCE_ORG_RIGHT_ID");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("IS_USE", "IS_USE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<ComboxNode> getAllComboxList() {
        String sql = "select distinct o.org_id value,\n\to.sort,\n\to.org_name text\n\t from  BAS_ORG o\n where o.IS_FINANCE_UNIT = 'Y' and o.is_use='Y' \n";
        sql = sql + "  order by o.sort ";
        List list = this.sqlHelper.queryByNativeSQL(sql, new int[0]);
        return ComboxUtils.buildComboxNodes(list, new ComboxUtils.DefineNode());
    }

    public List<ComboxNode> getComboxList(Long accountId, Long orgId, String isFinancial, Boolean isdetail) {
        String tempSql = "";
        if (orgId != null) {
            tempSql = ",(case t.org_id when" + orgId + " then 'true' else 'false' end) selected";
        }
        String sql = "select distinct t.org_id value,\n\to.ABBR text, o.sort \n" + tempSql + "\t from BAS_FINANCE_ORG_RIGHT t \n  left join BAS_ORG o\n    on t.org_id = o.org_id\n where t.is_use = 'Y' and o.is_use='Y' \n";
        if (!(accountId == null || isdetail != null && isdetail.booleanValue())) {
            sql = sql + " and t.ACCOUNT_ID = '" + accountId + "' \n";
        }
        if (StrKit.isBlank(isFinancial) || "N".equals(isFinancial)) {
            sql = sql + "\tand (o.IS_FINANCIAL is null or o.IS_FINANCIAL ='N') \n";
        }
        sql = sql + "  order by o.sort ";
        List list = this.sqlHelper.queryByNativeSQL(sql, new int[0]);
        return ComboxUtils.buildComboxNodes(list, new ComboxUtils.DefineNode());
    }
}

