/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasEmpApplyEditDao;
import com.ustc.base.entity.BasEmpApplyEdit;
import com.ustc.base.service.BasMessageService;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.doc.service.DocFormFileService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.workflow.service.FlowUtilService;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasEmpApplyEditService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasMessageService msgService;
    @Autowired
    private BasEmpApplyEditDao basempapplyeditDao;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private FlowUtilService flowUtilService;

    public BasEmpApplyEdit findBasEmpApplyEdit(Long id) {
        BasEmpApplyEdit entity = (BasEmpApplyEdit)this.basempapplyeditDao.getOne(id);
        return entity;
    }

    public void saveBasEmpApplyEdit(BasEmpApplyEdit entity) {
        this.basempapplyeditDao.save(entity);
    }

    public void saveBasEmpApplyEdit(BasEmpApplyEdit entity, FormFileBean formfile) {
        this.basempapplyeditDao.save(entity);
        if (formfile != null) {
            formfile.setPrimaryKey(entity.getId());
            formfile.setAccountid(entity.getModifyAccount());
            this.docFormFileService.SaveFormFileBean(formfile);
        }
    }

    public void delBasEmpApplyEdit(Long id) {
        BasEmpApplyEdit entity = (BasEmpApplyEdit)this.basempapplyeditDao.getOne(id);
        entity.setIsUse("N");
        entity.setModifyTime(new Date());
        this.basempapplyeditDao.save(entity);
        this.msgService.delMydealByProcessinstid(entity.getProcessinstid(), id.toString());
    }

    public PageObject PageAll(Long flowDone, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (flowDone != null) {
            params.put("flowsql", " and t.processinstid in (" + this.flowUtilService.queryDealedProcess(flowDone) + ") \n");
        } else {
            params.put("flowsql", " and t.workflow_status='3' \n");
        }
        return this.bSqlHelper.searchPage("base.BasEmpApplyEdit.select", params, PageRequest.of((int)page, (int)rows));
    }
}

