/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasDicTypeDao;
import com.ustc.base.entity.BasDicType;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasDicTypeService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasDicTypeDao basdictypeDao;

    public BasDicType findBasDicType(Long id) {
        BasDicType entity = (BasDicType)this.basdictypeDao.findById(id).get();
        return entity;
    }

    @CacheEvict(cacheNames={"DicCache"}, allEntries=true)
    public void saveBasDicType(BasDicType entity) {
        this.basdictypeDao.save(entity);
    }

    @CacheEvict(cacheNames={"DicCache"}, allEntries=true)
    public void delBasDicType(Long id) {
        BasDicType entity = (BasDicType)this.basdictypeDao.findById(id).get();
        entity.setIsUse("N");
        this.basdictypeDao.save(entity);
    }

    public PageObject PageAll(String search, Long businessTypeId, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (businessTypeId != null) {
            params.put("businessTypeId", businessTypeId);
        }
        return this.bSqlHelper.serachPage("base.dic.pageAllType", params, PageRequest.of((int)page, (int)rows));
    }
}

