/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.BasDeviceUserDao;
import com.ustc.base.entity.BasDeviceUser;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasDeviceUserService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasDeviceUserDao basdeviceuserDao;

    public BasDeviceUser findBasDeviceUser(Long id) {
        BasDeviceUser entity = (BasDeviceUser)this.basdeviceuserDao.findById(id).get();
        return entity;
    }

    public List<BasDeviceUser> findByAccountId(Long accountId) {
        return this.basdeviceuserDao.findByAccountIdOrderByIdDesc(accountId);
    }

    public void saveBasDeviceUser(BasDeviceUser entity) {
        this.basdeviceuserDao.save(entity);
    }

    public BasDeviceUser save(String clientId) {
        BasDeviceUser entity;
        List<BasDeviceUser> devs = this.basdeviceuserDao.findByClientId(clientId);
        if (devs.isEmpty()) {
            entity = new BasDeviceUser();
            entity.setClientId(clientId);
        } else {
            entity = devs.get(0);
        }
        entity.setAccountId(SysUtils.getLoginAccountId());
        return (BasDeviceUser)this.basdeviceuserDao.save(entity);
    }

    public void delBasDeviceUser(Long id) {
        BasDeviceUser entity = (BasDeviceUser)this.basdeviceuserDao.findById(id).get();
        this.basdeviceuserDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("base.BasDeviceUser.select", params, PageRequest.of((int)page, (int)rows));
    }
}

