/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.ComboxNode;
import com.ustc.base.common.util.ComboxUtils;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.BasDeptDao;
import com.ustc.base.dao.BasOrgDao;
import com.ustc.base.entity.BasDept;
import com.ustc.base.service.CommonService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component
@Transactional
public class BasDeptService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasDeptDao basDao;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasOrgDao basorgDao;

    public List<ComBoxTreeNode> getDeptMenu(long pid, long orgId) {
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive dept as\n\t (select m.* from BAS_DEPT m \n\t where   m.PDEPT_ID = ?1  AND m.ORG_ID = ?2 and m.is_use='Y' \n\t union all\n\t select m.* from BAS_DEPT m,dept  where  m.PDEPT_ID=dept.DEPT_ID and m.is_use='Y'\n\t )\n select \n\t\t\tt.DEPT_ID id, \n\t\t\tT.pdept_id PID, \n\t\t\tt.abbr text, \n      t.org_id,\n      t.DEPT_CODE  as deptcode, \n\t\t\t'open' as state\n from dept t\n ORDER BY t.display_no");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{pid, orgId}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<BasDept> getDept() {
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*\n  from bas_dept t\n where t.is_use = 'Y'\n order by t.display_no ");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), BasDept.class, new int[0]);
        return list;
    }

    public List<ComboxNode> getDeptCombo(Long orgId, String deptLevel) {
        return this.getDeptCombo(orgId, deptLevel, true);
    }

    public List<ComboxNode> getDeptCombo(Long orgId, String deptLevel, boolean showBusinessUnit) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("SELECT t.DEPT_ID id,\n      t.abbr text,\n      t.DEPT_ID value,\n      t.org_id,\n      t.DEPT_CODE  as deptcode \nFROM  BAS_DEPT t WHERE  t.IS_USE='Y' \n");
        if (orgId != null) {
            sql.append(" AND T.ORG_ID = :orgId \n");
            params.put("orgId", orgId);
        }
        if (!showBusinessUnit) {
            sql.append(" AND not exists(select 1 from bas_org o where o.belong_dept = t.DEPT_ID and o.is_use='Y') \n");
        }
        if (StrKit.notBlank(deptLevel)) {
            sql.append(" and t.dept_level = :deptLevel ");
            params.put("deptLevel", deptLevel);
        }
        sql.append("order by t.display_no");
        List list = new ArrayList();
        list = this.sqlHelper.queryByNativeSQL(sql.toString(), params, new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }

    public List<ComboxNode> findArchivesDept() {
        String sql = "select t.dept_id as ID,\nT.DEPT_NAME AS TEXT,\nT.DEPT_ID AS VALUE\n  from bas_dept t\n where t.dept_id in\n (select c.dept_id\n                       from bas_roles_account a\n                       left join bas_emp_account b\n                         on a.account_id = b.account_id\n                       left join bas_emp c\n                         on b.emp_id = c.emp_id\n                      where a.role_id = 6)\n                      order by t.display_no ";
        List list = this.sqlHelper.queryByNativeSQL(sql, new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }

    public JsonMsg saveDept(BasDept basDept) {
        this.basDao.save(basDept);
        return new JsonMsg(true, "\u6570\u636e\u64cd\u4f5c\u6210\u529f!", basDept);
    }

    public BasDept findByDeptId(Long deptId) {
        if (this.basDao.findById(deptId).isPresent()) {
            return (BasDept)this.basDao.findById(deptId).get();
        }
        BasDept basDept1 = new BasDept();
        return basDept1;
    }

    public boolean delDepts(Long searchId) {
        StringBuilder sql = new StringBuilder();
        sql.append("\tUPDATE \tBAS_DEPT m \n\tSET\t\tm.IS_USE='N' \n\tWHERE \tm.DEPT_ID in ( \n\t\tSELECT \tT.DEPT_ID \n\t\tFROM \tBAS_DEPT T \n\t\tWHERE \tT.IS_USE = 'Y' \n \tstart with t.PDEPT_ID = ?1 \n\t\tconnect by prior t.DEPT_ID = t.PDEPT_ID ) \n");
        this.sqlHelper.exeNativeSQL(sql.toString(), new Object[]{searchId});
        return true;
    }

    public PageObject PageAll(Long orgId, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        String sql = "select s.org_name, t.*\n  from BAS_DEPT t,bas_org s\n where t.org_id=s.org_id    and  t.is_use = :isUse\n   and (t.org_id = :orgId or\n       t.org_id in (with recursive tmp as \n                       (select A.org_id id from bas_org A where A.porg_id =:orgId   \n                     UNION ALL  \n                     select B.org_id id from bas_org B,tmp t  where t.id = B.porg_id)select *  from tmp p ))\n";
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((Object)search)) {
            sql = sql + "and  (  upper(t.DEPT_ID) like :search  or upper(t.DEPT_CODE) like :search  or upper(t.DEPT_NAME) like :search  or upper(t.ORG_ID) like :search  or upper(t.PDEPT_ID) like :search  or upper(t.DEPT_LEVEL) like :search  or upper(t.DEPT_TYPE_ID) like :search  or upper(t.IS_USE) like :search  or upper(t.DISPLAY_NO) like :search  or upper(t.REMARK) like :search  or upper(t.ABBR) like :search  or upper(t.ESTABLISH_DATE) like :search  or upper(t.MASTER_ORG_ID) like :search  or upper(s.org_name) like :search )";
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql = sql + " order by ifnull(s.sort,999999999999),ifnull(t.display_No,999999999999)";
        params.put("orgId", orgId);
        pageobject = this.sqlHelper.pagerNativeSQL(sql, params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("DEPT_LEVEL", "DEPT_LEVEL");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public Long queryEmpDeptId(Long accountId) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("  select GETROOTDEPTID(:accountId) from dual ");
        params.put("accountId", accountId);
        Object o = this.sqlHelper.getSingal(sql.toString(), params);
        if (o != null && StrKit.notBlank(o.toString())) {
            return Long.valueOf(o.toString());
        }
        return null;
    }

    public BasDept findByOrgIdAndDeptName(Long orgId, String deptName) {
        return this.basDao.findByDeptNameAndOrgIdAndIsUse(deptName, orgId, "Y");
    }

    public String findDeptTextById(String deptId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deptId", deptId);
        return this.bSqlHelper.getStringValue("base.BasDept.findDeptTextById", params);
    }

    public String findDeptNameById(String orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deptId", orgId);
        return this.bSqlHelper.getStringValue("base.BasDept.findDeptNameById", params);
    }

    public String findOrgNameById(String orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        return this.bSqlHelper.getStringValue("base.BasDept.findOrgNameById", params);
    }

    public List<ComboxNode> getComboxListForDeptAndOrg(Long deptId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LoginUser user = SysUtils.getLoginUser();
        params.put("deptId", deptId);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasDept.getComboxListForApplyOrg", params);
        return ComboxUtils.buildComboxNodes(list);
    }

    public String queryDeptAndOrgNameById(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("id", id);
            return this.bSqlHelper.getStringValue("base.BasDept.queryDeptAndOrgNameById", params);
        }
        return "";
    }
}

