/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasContactPeopleDao;
import com.ustc.base.entity.BasContactPeople;
import com.ustc.base.service.CommonService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasContactPeopleService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasContactPeopleDao bascontactpeopleDao;

    public BasContactPeople findBasContactPeople(Long id) {
        BasContactPeople entity = (BasContactPeople)this.bascontactpeopleDao.findById(id).get();
        return entity;
    }

    public List<BasContactPeople> findByContactOrgId(Long contactOrgId) {
        return this.bascontactpeopleDao.findByContactOrgId(contactOrgId);
    }

    public void saveBasContactPeople(BasContactPeople entity) {
        this.bascontactpeopleDao.save(entity);
    }

    public void delBasContactPeople(Long id) {
        this.bascontactpeopleDao.deleteById(id);
    }

    public void delBasContactPeople(List<BasContactPeople> entities, Long userId) {
        for (BasContactPeople entity : entities) {
            entity.setIsUse("N");
            entity.setModifyAccount(userId);
            entity.setModifyTime(new Date());
        }
        this.bascontactpeopleDao.saveAll(entities);
    }

    public void delContactPeople(List<BasContactPeople> entities) {
        this.bascontactpeopleDao.deleteAll(entities);
    }

    public PageObject PageAll(String contactOrgId, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        Object[] params = new Object[]{contactOrgId};
        StringBuffer sqlBuf = new StringBuffer("select t.*, a.account_name ,\n\tDATE_FORMAT(t.modify_time,'%Y-%m-%d %H:%i:%s') MODIFY_TIME_F \n\tfrom BAS_CONTACT_PEOPLE t \n  left join bas_emp_account a\n    on t.modify_account = a.account_id\n where t.contact_org_id = ?1 and t.is_use='Y' ");
        if (!StringUtils.isEmpty((String)search)) {
            sqlBuf.append("and  (  upper(t.CONTACT_PEOPLE_ID) like ?2  or upper(t.CONTACT_ORG_ID) like ?2  or upper(t.PEOPLE_NAME) like ?2  or upper(t.PEOPLE_TEL) like ?2  or upper(t.STATUS) like ?2  or upper(t.MEMO) like ?2  or upper(t.MODIFY_ACCOUNT) like ?2  or upper(t.MODIFY_TIME) like ?2  or upper(t.IS_USE) like ?2 )");
            params = new Object[]{contactOrgId, "%" + search.toUpperCase() + "%"};
        }
        sqlBuf.append(" order by t.CONTACT_PEOPLE_ID");
        pageobject = this.sqlHelper.pagerNativeSQL(sqlBuf.toString(), params, page, rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("STATUS", "DATA_STATUS");
        dicmapper.put("IS_USE", "IS_USE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }
}

