/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.BasBizResetBackupDao;
import com.ustc.base.entity.BasBizResetBackup;
import com.ustc.base.service.CommonService;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasBizResetBackupService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasBizResetBackupDao basbizresetbackupDao;

    public BasBizResetBackup findBasBizResetBackup(Long id) {
        BasBizResetBackup entity = (BasBizResetBackup)this.basbizresetbackupDao.findById(id).get();
        return entity;
    }

    public void saveBasBizResetBackup(BasBizResetBackup entity) {
        this.basbizresetbackupDao.save(entity);
    }

    public void delBasBizResetBackup(Long id) {
        BasBizResetBackup entity = (BasBizResetBackup)this.basbizresetbackupDao.findById(id).get();
        this.basbizresetbackupDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*  ");
        sql.append(" from BAS_BIZ_RESET_BACKUP t  ");
        sql.append(" where t.is_use=:isUse ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and  (");
            sql.append("  upper(t.ID) like :search ");
            sql.append(" or upper(t.FORM_CODE) like :search ");
            sql.append(" or upper(t.ACCOUNT_ID) like :search ");
            sql.append(" or upper(t.BUSI_MAIN_ID) like :search ");
            sql.append(" or upper(t.PROCESSINSTID) like :search ");
            sql.append(" or upper(t.REMARK) like :search ");
            sql.append(" or upper(t.MODIFY_ACCOUNT) like :search ");
            sql.append(" or upper(t.MODIFY_TIME) like :search ");
            sql.append(") ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.ID");
        if (StrKit.notBlank(sort)) {
            String exesql = "select * from (" + sql.toString() + ") " + SysUtils.genOrderBy(sort, order);
            pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public void saveRestBackup(String formCode, Long accountId, Long bizMainId, Long processinstid) {
        BasBizResetBackup entity = new BasBizResetBackup();
        entity.setAccountId(accountId);
        entity.setFormCode(formCode);
        entity.setBusiMainId(bizMainId);
        entity.setProcessinstid(processinstid);
        entity.setModifyAccount(accountId);
        entity.setModifyTime(new Date());
        this.basbizresetbackupDao.save(entity);
    }
}

