/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasAreaDao;
import com.ustc.base.entity.BasArea;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasAreaService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BasAreaDao basareaDao;

    public BasArea findBasArea(Long id) {
        BasArea entity = (BasArea)this.basareaDao.getOne(id);
        return entity;
    }

    public void saveBasArea(BasArea entity) {
        this.basareaDao.save(entity);
    }

    public void delBasArea(Long id) {
        this.basareaDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        String sql = "select * from BAS_AREA t  order by t.AREA_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from BAS_AREA t where   upper(t.AREA_TYPE) like ?1  or upper(t.COUNTRY_ID) like ?1  or upper(t.AREA_ID) like ?1  or upper(t.AREA_CODE) like ?1  or upper(t.AREA_NAME) like ?1  or upper(t.PAREA_ID) like ?1  or upper(t.IN_OUTSIDE_CODE) like ?1  or upper(t.IN_OUTSIDE) like ?1  or upper(t.DELTA_AREA_CODE) like ?1  or upper(t.DELTA_AREA_NAME) like ?1  or upper(t.COUNTRY_PROVINCE_ID) like ?1  or upper(t.COUNTRY_PROVINCE_CODE) like ?1  or upper(t.COUNTRY_PROVINCE_NAME) like ?1  or upper(t.UNION_CODE) like ?1  or upper(t.UNION_NAME) like ?1  or upper(t.IS_USE) like ?1  or upper(t.AREA_FULL_NAME) like ?1  order by t.AREA_ID";
            return this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        }
        return this.sqlHelper.pagerNativeSQL(sql, page, rows);
    }

    public void delBasAreaAndChild(Long id) {
        StringBuilder sql = new StringBuilder();
        sql.append("\tDELETE FROM \tBAS_AREA T \n\tWHERE \tT.AREA_ID in ( \n    with recursive cte as(\n    select A.AREA_ID \n    from  BAS_AREA A\n    where A.AREA_ID = ?1\n    union all \n    select B.AREA_ID\n    from BAS_AREA B\n    join cte c on c.AREA_ID = B.PAREA_ID and B.AREA_ID = ?1\n)select AREA_ID from cte )");
        this.sqlHelper.exeNativeSQL(sql.toString(), new Object[]{id});
    }

    public List<ComBoxTreeNode> treeBasArea(Long pid) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT \tt.AREA_ID id, \n\t\t\tT.PAREA_ID PID, \n     \tt.AREA_NAME text, \n     \tt.area_full_name,         (case (select count(1) from BAS_AREA a where a.PAREA_ID=t.AREA_ID and a.is_use='Y') when 0 then 'open' else 'closed' end) state\n FROM \tBAS_AREA T \n where  T.PAREA_ID = ?1 \n and T.AREA_ID = T.PAREA_ID ");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{pid}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> treeBasAreaAnsy(Long pid) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT \tt.AREA_ID id, \n\t\t\tT.PAREA_ID PID, \n     \tt.AREA_NAME text, \n     \t decode((select count(1) from BAS_AREA where parea_id = t.area_id),0,'open','closed') as state, \n     \tt.area_full_name \n FROM \tBAS_AREA T where T.PAREA_ID = ?1 and t.is_use='Y' order by t.area_code");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{pid}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> queryTreeByProvince(Long pid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasArea.queryTreeByProvince", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public PageObject getCityByProvince(String search, int page, int rows, String sort, String order, String pid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)pid)) {
            params.put("pid", pid);
        }
        return this.bSqlHelper.searchPage("base.BasArea.getCityByProvince", params, PageRequest.of((int)page, (int)rows));
    }
}

