/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.ustc.base.common.spring.SpringContextHolder;
import com.ustc.base.common.util.GenerateRandomKeyUtil;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasMenu;
import com.ustc.base.service.BasMenuLinkService;
import com.ustc.base.service.BasMenuService;
import com.ustc.base.service.BasRolesAccountService;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IndexController
extends BaseController {
    public static Logger loger = Logger.getLogger(IndexController.class);
    @Autowired
    private BasMenuService basMenuService;
    @Autowired
    private BasMenuLinkService basMenuLinkService;
    @Autowired
    private BasRolesAccountService basrolesaccountService;

    @RequestMapping(value={"/"})
    public ModelAndView index(HttpServletRequest request) {
        LoginUser loginuser = this.getLoginUser(request);
        String isAdmin = "N";
        if (this.basrolesaccountService.findByRoleIdAndAccountId(SysContent.ROLE_ID_SUPER_ADMIN, SysUtils.getLoginAccountId()) != null) {
            isAdmin = "Y";
        }
        ModelAndView view = new ModelAndView();
        if (loginuser != null) {
            view.setViewName("mainframelayui");
            view.addObject("fontSize", (Object)loginuser.getFontSize());
            view.addObject("themes", (Object)loginuser.getThemes());
            view.addObject("loginuser", (Object)loginuser);
            view.addObject("isAdmin", (Object)isAdmin);
            view.addObject("defaultpassword", (Object)"123");
            view.addObject("menulist", this.basMenuService.getAccountBasMenu(loginuser.getAccountid()));
            view.addObject("menuLinklist", (Object)this.basMenuLinkService.getMenuLink());
            view.addObject("queryAddrlist", (Object)this.basMenuLinkService.getqueryAddr());
            view.addObject("navCount", (Object)this.getNavCount(request));
            view.addObject("profiles", (Object)SpringContextHolder.getProperty("spring.profiles.active"));
        } else {
            if (request.getSession().getAttribute("sessionSalt") == null) {
                request.getSession().setAttribute("sessionSalt", (Object)GenerateRandomKeyUtil.getRandomKey(16));
            }
            view.setViewName("index");
        }
        return view;
    }

    @RequestMapping(value={"/help/index"})
    public ModelAndView helpindex(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        view.setViewName("help");
        return view;
    }

    @RequestMapping(value={"/errorpage/{errorcode}"})
    public String errorpage(@PathVariable(value="errorcode") String errorcode) {
        return "/errorpage/" + errorcode;
    }

    @RequestMapping(value={"/view/{page}"}, method={RequestMethod.GET})
    public String viewpage(Model model, HttpServletRequest request, @PathVariable(value="page") String page) {
        this.fillModel(model, request);
        return page;
    }

    @RequestMapping(value={"/view/{page1}/{page2}"}, method={RequestMethod.GET})
    public String viewpage2(Model model, HttpServletRequest request, @PathVariable(value="page1") String page1, @PathVariable(value="page2") String page2) {
        this.fillModel(model, request);
        return page1 + "/" + page2;
    }

    @RequestMapping(value={"/view/{page1}/{page2}/{page3}"}, method={RequestMethod.GET})
    public String viewpage3(Model model, HttpServletRequest request, @PathVariable(value="page1") String page1, @PathVariable(value="page2") String page2, @PathVariable(value="page3") String page3) {
        this.fillModel(model, request);
        return page1 + "/" + page2 + "/" + page3;
    }

    private void fillModel(Model model, HttpServletRequest request) {
        BasMenu menu;
        String menuId = request.getParameter("menuId");
        if (menuId != null && !menuId.equals("0") && (menu = this.basMenuService.findBasMenu(Long.valueOf(menuId))) != null) {
            model.addAttribute("menuIco", (Object)menu.getMenuIco());
            model.addAttribute("menuName", (Object)menu.getMenuName());
            model.addAttribute("menuColor", (Object)(StringUtils.isBlank((CharSequence)menu.getBackgroundColor()) ? "#409EFF" : menu.getBackgroundColor()));
        }
        Map map = request.getParameterMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            model.addAttribute(key, (Object)(map.get(key = (String)iterator.next()) == null ? "" : StrKit.join((String[])map.get(key), ",")));
        }
        LoginUser loginuser = this.getLoginUser(request);
        if (loginuser != null) {
            model.addAttribute("loginuser", (Object)loginuser);
            model.addAttribute("accountName", (Object)loginuser.getAccountName());
            model.addAttribute("accountId", (Object)loginuser.getAccountid());
            model.addAttribute("fontSize", (Object)loginuser.getFontSize());
            model.addAttribute("WebIMServer", (Object)loginuser.getWebIMServer());
        }
    }
}

