/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.HtmlSignature;
import com.ustc.base.service.HtmlSignatureService;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/signature"})
public class ISignatureController
extends BaseController {
    @Autowired
    private HtmlSignatureService signatureService;

    @RequestMapping(value={"/service"})
    @ResponseBody
    public String service(HttpServletResponse response, HttpServletRequest request) throws UnsupportedEncodingException {
        request.setCharacterEncoding("gb2312");
        String COMMAND = request.getParameter("COMMAND");
        String DOCUMENTID = request.getParameter("DOCUMENTID");
        String SIGNATUREID = request.getParameter("SIGNATUREID");
        String msg = "";
        if ("SAVESIGNATURE".equalsIgnoreCase(COMMAND)) {
            HtmlSignature signature;
            byte[] SIGNATURE = request.getParameter("SIGNATURE").getBytes();
            List<HtmlSignature> list = this.signatureService.findByDocumentidAndSignatureid(DOCUMENTID, SIGNATUREID);
            if (list.isEmpty()) {
                signature = new HtmlSignature();
                Date dt = new Date();
                signature.setDocumentid(DOCUMENTID);
                signature.setIsUse("Y");
                signature.setSignatureid(String.valueOf(dt.getTime()));
            } else {
                signature = list.get(0);
            }
            signature.setSignature(SIGNATURE);
            signature.setSignaturesize(new Long(SIGNATURE.length));
            this.signatureService.saveHtmlSignature(signature);
            msg = "SIGNATUREID=" + signature.getSignatureid() + "\r\nRESULT=OK";
        } else if ("GETNOWTIME".equalsIgnoreCase(COMMAND)) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String mDateTime = formatter.format(new Date());
            msg = "NOWTIME=" + mDateTime + "\r\nRESULT=OK";
        } else if ("SHOWSIGNATURE".equalsIgnoreCase(COMMAND)) {
            String mSignatures = "";
            List<HtmlSignature> list = this.signatureService.findByDocumentid(DOCUMENTID);
            for (HtmlSignature signature : list) {
                mSignatures = mSignatures + signature.getSignatureid() + ";";
            }
            msg = "SIGNATURES=" + mSignatures + "\r\nRESULT=OK";
        } else if ("LOADSIGNATURE".equalsIgnoreCase(COMMAND)) {
            List<HtmlSignature> list = this.signatureService.findByDocumentidAndSignatureid(DOCUMENTID, SIGNATUREID);
            if (!list.isEmpty()) {
                msg = new String(list.get(0).getSignature()) + "\r\nRESULT=OK";
            }
        } else if ("DELESIGNATURE".equalsIgnoreCase(COMMAND)) {
            List<HtmlSignature> list = this.signatureService.findByDocumentidAndSignatureid(DOCUMENTID, SIGNATUREID);
            for (HtmlSignature signature : list) {
                this.signatureService.delHtmlSignature(signature);
            }
            msg = "RESULT=OK";
        } else if ("GETSIGNATUREDATA".equalsIgnoreCase(COMMAND)) {
            msg = msg + "SIGNATUREDATA=\r\n";
            msg = msg + "RESULT=OK";
        } else if ("PUTSIGNATUREDATA".equalsIgnoreCase(COMMAND)) {
            byte[] SIGNATURE = request.getParameter("SIGNATURE").getBytes();
            HtmlSignature signature = new HtmlSignature();
            Date dt = new Date();
            signature.setDocumentid(DOCUMENTID);
            signature.setIsUse("Y");
            signature.setSignatureid(String.valueOf(dt.getTime()));
            signature.setSignature(SIGNATURE);
            signature.setSignaturesize(new Long(SIGNATURE.length));
            this.signatureService.saveHtmlSignature(signature);
            msg = msg + "SIGNATUREID=" + signature.getSignatureid() + "\r\n";
            msg = msg + "RESULT=OK";
        } else if ("SAVEHISTORY".equalsIgnoreCase(COMMAND)) {
            msg = msg + "RESULT=OK";
        }
        return msg;
    }

    @RequestMapping(value={"/getUUID"})
    @ResponseBody
    public String getUUID(HttpServletResponse response, HttpServletRequest request) {
        return UUID.randomUUID().toString();
    }
}

