/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.ibm.icu.math.BigDecimal;
import com.ibm.icu.text.DateFormat;
import com.ustc.base.common.util.ComboxNode;
import com.ustc.base.common.util.DateUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasDic;
import com.ustc.base.entity.BasMessage;
import com.ustc.base.entity.GmSpaceComponentAssociated;
import com.ustc.base.entity.GmSpaceDefine;
import com.ustc.base.entity.GmSpaceManagement;
import com.ustc.base.entity.GmSpaceUse;
import com.ustc.base.service.BasDicService;
import com.ustc.base.service.BasMessageService;
import com.ustc.base.service.CommonService;
import com.ustc.base.service.FirstPageService;
import com.ustc.base.service.GmSpaceComponentAssociatedService;
import com.ustc.base.service.GmSpaceComponentCustomService;
import com.ustc.base.service.GmSpaceComponentDefinitionService;
import com.ustc.base.service.GmSpaceDefineService;
import com.ustc.base.service.GmSpaceManagementService;
import com.ustc.base.service.GmSpaceUseService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.ocpsoft.prettytime.PrettyTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/GmSpaceDefine"})
public class GmSpaceDefineController
extends BaseController {
    @Autowired
    private GmSpaceDefineService gmspacedefineService;
    @Autowired
    private GmSpaceUseService gmspaceuseService;
    @Autowired
    private GmSpaceManagementService gmSpaceManagementService;
    @Autowired
    private GmSpaceComponentAssociatedService gmSpaceComponentAssociatedService;
    @Autowired
    private GmSpaceComponentDefinitionService gmSpaceComponentDefinitionService;
    @Autowired
    private BasMessageService basMessageService;
    @Autowired
    private FirstPageService firstPageService;
    @Autowired
    private CommonService comService;
    @Autowired
    private BasDicService basDicService;
    @Autowired
    private GmSpaceComponentCustomService gmSpaceComponentCustomService;

    @RequestMapping(value={"/pageGmSpaceDefine"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageGmSpaceDefine(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order, String spaceTypeText) {
        return this.gmspacedefineService.PageAll(search, page, rows, sort, order, spaceTypeText);
    }

    @RequestMapping(value={"/findGmSpaceDefine"})
    @ResponseBody
    public Object findGmSpaceDefine(Long id) {
        GmSpaceDefine entity = this.gmspacedefineService.findGmSpaceDefine(id);
        return entity;
    }

    @RequestMapping(value={"/saveGmSpaceDefine"})
    @ResponseBody
    public Object saveGmSpaceDefine(HttpServletRequest request, GmSpaceDefine entity) {
        String[] idArray;
        Boolean flag;
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        if (entity.getSpaceId() == null) {
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
        }
        if (("2".equals(entity.getSpaceType()) || "3".equals(entity.getSpaceType()) || "4".equals(entity.getSpaceType())) && !(flag = this.gmspacedefineService.checkGmSpaceDefine(entity)).booleanValue()) {
            msg.setSuccess(false);
            msg.setMsg("\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u5355\u4f4d\u6216\u90e8\u95e8\u5df2\u5b58\u5728\u83dc\u5355\u5bf9\u5e94\u7684\u7a7a\u95f4");
            return msg;
        }
        this.gmspacedefineService.saveGmSpaceDefine(entity);
        this.gmspaceuseService.deleteBySpaceId(entity.getSpaceId());
        if (StringUtils.isNotBlank((CharSequence)entity.getUseUserId()) && !":".equals(entity.getUseUserId())) {
            for (String string : entity.getUseUserId().split(",")) {
                idArray = string.split(":");
                GmSpaceUse gmSpaceUse = new GmSpaceUse();
                gmSpaceUse.setSpaceId(entity.getSpaceId());
                gmSpaceUse.setUserType(idArray[0]);
                gmSpaceUse.setUserId(Long.parseLong(idArray[1]));
                gmSpaceUse.setModifyAccount(this.getLoginUser(request).getAccountid());
                gmSpaceUse.setModifyTime(new Date());
                gmSpaceUse.setIsUse("Y");
                if (gmSpaceUse.getSpaceUseId() == null) {
                    gmSpaceUse.setCreateAccount(this.getLoginUser(request).getAccountid());
                    gmSpaceUse.setCreateTime(new Date());
                }
                this.gmspaceuseService.saveGmSpaceUse(gmSpaceUse);
            }
        }
        this.gmSpaceManagementService.deleteBySpaceId(entity.getSpaceId());
        if (StringUtils.isNotBlank((CharSequence)entity.getManageUserId())) {
            for (String string : entity.getManageUserId().split(",")) {
                idArray = string.split(":");
                GmSpaceManagement gmSpaceManagement = new GmSpaceManagement();
                gmSpaceManagement.setSpaceId(entity.getSpaceId());
                gmSpaceManagement.setUserType(idArray[0]);
                gmSpaceManagement.setUserId(Long.parseLong(idArray[1]));
                gmSpaceManagement.setModifyAccount(this.getLoginUser(request).getAccountid());
                gmSpaceManagement.setModifyTime(new Date());
                gmSpaceManagement.setIsUse("Y");
                if (gmSpaceManagement.getSpaceManagementId() == null) {
                    gmSpaceManagement.setCreateAccount(this.getLoginUser(request).getAccountid());
                    gmSpaceManagement.setCreateTime(new Date());
                }
                this.gmSpaceManagementService.saveGmSpaceManagement(gmSpaceManagement);
            }
        }
        if (entity.getDataList() != null) {
            for (GmSpaceComponentAssociated gmSpaceComponentAssociated : entity.getDataList()) {
                gmSpaceComponentAssociated.setSpaceId(entity.getSpaceId());
                if (gmSpaceComponentAssociated.getCreateAccount() == null) {
                    gmSpaceComponentAssociated.setCreateAccount(this.getLoginUser(request).getAccountid());
                    gmSpaceComponentAssociated.setCreateTime(new Date());
                }
                gmSpaceComponentAssociated.setModifyAccount(this.getLoginUser(request).getAccountid());
                gmSpaceComponentAssociated.setModifyTime(new Date());
                if (StringUtils.isBlank((CharSequence)gmSpaceComponentAssociated.getIsUse())) {
                    gmSpaceComponentAssociated.setIsUse("Y");
                }
                this.gmSpaceComponentAssociatedService.saveGmSpaceComponentAssociated(gmSpaceComponentAssociated);
            }
        }
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delGmSpaceDefine"})
    @ResponseBody
    public Object delGmSpaceDefine(Long id) {
        this.gmspacedefineService.delGmSpaceDefine(id);
        this.gmspaceuseService.deleteBySpaceId(id);
        this.gmSpaceManagementService.deleteBySpaceId(id);
        this.gmSpaceComponentAssociatedService.deleteBySpaceId(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/priewSpace"})
    public Object priewSpace(Model model, HttpServletRequest request, Long spaceId) throws UnsupportedEncodingException {
        boolean flag = false;
        if (spaceId == null || flag) {
            return "/errorpage/463";
        }
        GmSpaceDefine space = this.gmspacedefineService.findGmSpaceDefineById(spaceId);
        List<Object> list = new ArrayList();
        list = this.gmSpaceComponentCustomService.findCountByUserAndSpace(this.getLoginUser(request).getAccountid(), spaceId) > 0 ? this.gmSpaceComponentCustomService.findByUserAndSpace(this.getLoginUser(request).getAccountid(), spaceId) : this.gmSpaceComponentAssociatedService.findBySpaceId(spaceId);
        if (StringUtils.isNotBlank((CharSequence)space.getSpaceLink()) && list.isEmpty()) {
            return "redirect:" + space.getSpaceLink();
        }
        for (Map map : list) {
            String contentHeight = Long.parseLong(Objects.toString(map.get("componentHeight")).replace("px", "")) - 108L + "px";
            map.put("linkAddress", "/GmSpaceComponentDefinition/viewContentListByIds?contentHeight=" + contentHeight + "&componentIds=" + map.get("componentId").toString() + "&type=" + Objects.toString(map.get("componentType")));
            if (map.get("displayName") != null) {
                map.put("linkAddress", map.get("linkAddress").toString() + "&title=" + URLEncoder.encode(map.get("displayName").toString(), "utf-8"));
            }
            map.put("contentHeight", contentHeight);
        }
        model.addAttribute("itemList", list);
        model.addAttribute("isModify", (Object)space.getIsModify());
        model.addAttribute("loginuser", (Object)this.getLoginUser(request));
        model.addAttribute("spaceId", (Object)spaceId);
        return "/space/spaceMain";
    }

    @RequestMapping(value={"/previewSpaceDrag"})
    public Object previewSpaceDrag(Model model, HttpServletRequest request, Long spaceId) throws UnsupportedEncodingException {
        if (spaceId == null) {
            return "/errorpage/463";
        }
        List<Map<String, Object>> list = this.gmSpaceComponentAssociatedService.findBySpaceId(spaceId);
        for (Map<String, Object> map : list) {
            String contentHeight = Long.parseLong(Objects.toString(map.get("componentHeight")).replace("px", "")) - 55L + "px";
            map.put("linkAddress", "/GmSpaceComponentDefinition/viewContentListByIds?contentHeight=" + contentHeight + "&componentIds=" + map.get("componentId").toString() + "&type=" + Objects.toString(map.get("componentType")));
            if (map.get("displayName") != null) {
                map.put("linkAddress", map.get("linkAddress").toString() + "&title=" + URLEncoder.encode(map.get("displayName").toString(), "utf-8"));
            }
            map.put("content", SysUtils.GetHttpContent(request, map.get("linkAddress").toString()));
            map.put("contentHeight", contentHeight);
        }
        model.addAttribute("itemList", list);
        List<ComboxNode> comboxNodeList = this.comService.getDicComboWithDefault("COMPONENT_WIDTH");
        model.addAttribute("comboxNodeList", comboxNodeList);
        return "business/gm/PreviewSpaceDrag";
    }

    @RequestMapping(value={"/todo"})
    @ResponseBody
    public ModelAndView todo(HttpServletRequest request) throws ParseException {
        ModelAndView view = new ModelAndView();
        LoginUser loginUser = this.getLoginUser(request);
        List<Map<String, Object>> msglist = this.firstPageService.findAccountTodoList(loginUser.getAccountid());
        int msgsize = msglist.size();
        String contentHeight = request.getParameter("contentHeight");
        if (StringUtils.isBlank((CharSequence)contentHeight)) {
            contentHeight = "300px";
        }
        int maxsize = Integer.parseInt(contentHeight.replaceAll("px", "")) / 40;
        view.addObject("todosize", (Object)msglist.size());
        view.addObject("todotimestamp", (Object)System.currentTimeMillis());
        if (msglist.size() > maxsize) {
            msglist = msglist.subList(0, maxsize);
        }
        for (Map<String, Object> basMessage : msglist) {
            PrettyTime p = new PrettyTime(Locale.CHINESE);
            basMessage.put("prettysendtime", p.format((Date)basMessage.get("sendtime")).replaceAll(" ", ""));
        }
        view.setViewName("/space/model/todo");
        view.addObject("msglist", msglist);
        view.addObject("msgsize", (Object)msgsize);
        view.addObject("msgurl", (Object)"msgurl");
        return view;
    }

    @RequestMapping(value={"/done"})
    @ResponseBody
    public ModelAndView done(HttpServletRequest request) throws ParseException {
        ModelAndView view = new ModelAndView();
        LoginUser loginUser = this.getLoginUser(request);
        List<BasMessage> msgHaveDoneList = this.basMessageService.queryHaveDoneList(loginUser.getAccountid(), "", 1, 20);
        String contentHeight = request.getParameter("contentHeight");
        if (StringUtils.isBlank((CharSequence)contentHeight)) {
            contentHeight = "300px";
        }
        int maxsize = Integer.parseInt(contentHeight.replaceAll("px", "")) / 46;
        if (msgHaveDoneList.size() > maxsize) {
            msgHaveDoneList = msgHaveDoneList.subList(0, maxsize);
        }
        for (BasMessage basMessage : msgHaveDoneList) {
            PrettyTime p = new PrettyTime(Locale.CHINESE);
            basMessage.setPrettysendtime(p.format(DateUtils.parseDate(basMessage.getDealtime())));
        }
        view.setViewName("/space/model/done");
        view.addObject("havelist", msgHaveDoneList);
        view.addObject("havesize", (Object)msgHaveDoneList.size());
        view.addObject("haveurl", (Object)"haveurl");
        return view;
    }

    @RequestMapping(value={"/message"})
    @ResponseBody
    public ModelAndView message(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        LoginUser loginUser = this.getLoginUser(request);
        List<BasMessage> messagelist = this.firstPageService.getAccountMessageList(loginUser.getAccountid(), SysContent.MSG_ALERT);
        int messagesize = messagelist.size();
        String contentHeight = request.getParameter("contentHeight");
        if (StringUtils.isBlank((CharSequence)contentHeight)) {
            contentHeight = "300px";
        }
        int maxsize = Integer.parseInt(contentHeight.replaceAll("px", "")) / 46;
        if (messagelist.size() > maxsize) {
            messagelist = messagelist.subList(0, maxsize);
        }
        for (BasMessage basMessage : messagelist) {
            PrettyTime p = new PrettyTime(Locale.CHINESE);
            basMessage.setPrettysendtime(p.format(basMessage.getSendtime()));
        }
        view.setViewName("/space/model/message");
        view.addObject("messagelist", messagelist);
        view.addObject("messagesize", (Object)messagesize);
        view.addObject("messageurl", (Object)"messageurl");
        return view;
    }

    @RequestMapping(value={"/messageAndWarning"})
    @ResponseBody
    public ModelAndView messageAndWarning(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        LoginUser loginUser = this.getLoginUser(request);
        List<BasMessage> messageAndWarns = new ArrayList<BasMessage>();
        List<BasMessage> messagelist = this.firstPageService.getAccountMessageList(loginUser.getAccountid(), SysContent.MSG_ALERT);
        List<BasMessage> warninglist = this.basMessageService.findAccountWarningList(loginUser.getAccountid(), null);
        Comparator<BasMessage> comparator = new Comparator<BasMessage>(){

            @Override
            public int compare(BasMessage o1, BasMessage o2) {
                if (o1.getSendtime() != null && o2.getSendtime() != null) {
                    return o2.getSendtime().compareTo(o1.getSendtime());
                }
                return 1;
            }
        };
        Collections.sort(warninglist, comparator);
        messageAndWarns.addAll(warninglist);
        messageAndWarns.addAll(messagelist);
        int messagesize = messageAndWarns.size();
        String contentHeight = request.getParameter("contentHeight");
        if (StringUtils.isBlank((CharSequence)contentHeight)) {
            contentHeight = "300px";
        }
        int maxsize = Integer.parseInt(contentHeight.replaceAll("px", "")) / 46;
        if (messageAndWarns.size() > maxsize) {
            messageAndWarns = messageAndWarns.subList(0, maxsize);
        }
        for (BasMessage messageAndWarn : messageAndWarns) {
            List<BasDic> basDics;
            if (messageAndWarn.getMsgType() != null && (basDics = this.basDicService.findByDicCodeAndValue("MSG_TYPE", messageAndWarn.getMsgType().toString())) != null && basDics.size() > 0) {
                messageAndWarn.setMsgTypeText(basDics.get(0).getDicText());
            }
            PrettyTime p = new PrettyTime(Locale.CHINESE);
            messageAndWarn.setPrettysendtime(DateUtils.dateToStr(messageAndWarn.getSendtime(), "MM-dd"));
        }
        view.setViewName("/space/model/messageAndWarning");
        view.addObject("messageAndWarns", messageAndWarns);
        return view;
    }

    @RequestMapping(value={"/warning"})
    @ResponseBody
    public ModelAndView warning(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        LoginUser loginUser = this.getLoginUser(request);
        List<BasMessage> warninglist = this.basMessageService.findAccountWarningList(loginUser.getAccountid(), null);
        Comparator<BasMessage> comparator = new Comparator<BasMessage>(){

            @Override
            public int compare(BasMessage o1, BasMessage o2) {
                if (o1.getSendtime() != null && o2.getSendtime() != null) {
                    return o2.getSendtime().compareTo(o1.getSendtime());
                }
                return 1;
            }
        };
        Collections.sort(warninglist, comparator);
        int warningsize = warninglist.size();
        String contentHeight = request.getParameter("contentHeight");
        if (StringUtils.isBlank((CharSequence)contentHeight)) {
            contentHeight = "300px";
        }
        int maxsize = Integer.parseInt(contentHeight.replaceAll("px", "")) / 46;
        if (warninglist.size() > maxsize) {
            warninglist = warninglist.subList(0, maxsize);
        }
        for (BasMessage basMessage : warninglist) {
            basMessage.setPrettysendtime(DateFormat.getDateInstance().format(basMessage.getSendtime()));
        }
        view.setViewName("/space/model/warning");
        view.addObject("warningurl", (Object)"warningurl");
        view.addObject("warninglist", warninglist);
        view.addObject("warningsize", (Object)warningsize);
        return view;
    }

    @RequestMapping(value={"/calander"})
    @ResponseBody
    public Object ModelAndView(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        view.setViewName("/space/model/calendar");
        return view;
    }

    @RequestMapping(value={"/myApply"})
    public Object myApply(Model model, String contentHeight, String search) {
        if (StringUtils.isBlank((CharSequence)contentHeight)) {
            contentHeight = "300px";
        }
        int maxsize = Integer.parseInt(contentHeight.replaceAll("px", "")) / 46;
        List<Map<String, Object>> list = this.gmspacedefineService.getMyApply(search);
        if (list.size() > maxsize) {
            list = list.subList(0, maxsize);
        }
        model.addAttribute("applyList", list);
        return "/space/model/myApply";
    }

    @RequestMapping(value={"/myWork"})
    public Object myWork(Model model, String contentHeight, String search) {
        if (StringUtils.isBlank((CharSequence)contentHeight)) {
            contentHeight = "300px";
        }
        int maxsize = Integer.parseInt(contentHeight.replaceAll("px", "")) / 46;
        List<Map<String, Object>> list = this.gmspacedefineService.getMyWork(search);
        if (list.size() > maxsize) {
            list = list.subList(0, maxsize);
        }
        model.addAttribute("workList", list);
        return "/space/model/myWork";
    }

    @RequestMapping(value={"/findImgForFundManage"})
    public Object findImgForFundManage(Model model, String typeIds, String componentId, String contentHeight) {
        if (StringUtils.isBlank((CharSequence)contentHeight)) {
            contentHeight = "300px";
        }
        model.addAttribute("componentId", (Object)componentId);
        model.addAttribute("contentHeight", (Object)contentHeight);
        return "/space/model/ImgForFundManage";
    }

    @RequestMapping(value={"/findMyReimburseData"})
    public Object findMyReimburseData(Model model, String typeIds, String componentId, String contentHeight) {
        List<Map<String, Object>> list = this.gmspacedefineService.findMyReimburseData(typeIds);
        int maxsize = Integer.parseInt(contentHeight.replaceAll("px", "")) / 46;
        if (list.size() > maxsize) {
            list = list.subList(0, maxsize);
        }
        model.addAttribute("applyList", list);
        if (StringUtils.isBlank((CharSequence)contentHeight)) {
            contentHeight = "300px";
        }
        model.addAttribute("componentId", (Object)componentId);
        model.addAttribute("contentHeight", (Object)contentHeight);
        return "/space/model/MyReimburseData";
    }

    @RequestMapping(value={"/getReimburseReminder"})
    public Object getReimburseReminder(Model model) {
        Map<String, Object> financeMoneyInfo = this.gmspacedefineService.getFinanceMoneyInfo();
        model.addAttribute("financeMoneyInfo", financeMoneyInfo);
        return "/space/model/ReimburseReminder";
    }

    @RequestMapping(value={"/findReimburseLevel"})
    public Object findReimburseLevel(Model model) {
        Map<String, Object> financeMoneyInfo = this.gmspacedefineService.getFinanceMoneyInfo();
        model.addAttribute("financeMoneyInfo", financeMoneyInfo);
        return "/space/model/ReimburseLevel";
    }

    @RequestMapping(value={"/findReimburseHouseLevel"})
    public Object findReimburseHouseLevel(Model model) {
        return "/space/model/ReimburseHouseLevel";
    }

    @RequestMapping(value={"/myKnowledgeDocument"})
    public Object myKnowledgeDocument(Model model, String contentHeight, String search) {
        if (StringUtils.isBlank((CharSequence)contentHeight)) {
            contentHeight = "300px";
        }
        int maxsize = Integer.parseInt(contentHeight.replaceAll("px", "")) / 46;
        List<Map<String, Object>> list = this.gmspacedefineService.getMyKnowledgeDocument(search);
        if (list.size() > maxsize) {
            list = list.subList(0, maxsize);
        }
        model.addAttribute("documentList", list);
        return "/space/model/knowledgeDocument";
    }

    @RequestMapping(value={"/getMyApplyList"})
    @ResponseBody
    public Object getMyApplyList(HttpServletRequest request, String startDate, String endDate, Long flowDone) {
        String page = request.getParameter("page");
        String rows = request.getParameter("rows");
        String msgType = request.getParameter("msgType");
        String search = request.getParameter("search");
        return this.gmspacedefineService.getMyApplyNew(page, rows, search, startDate, endDate, flowDone);
    }

    @RequestMapping(value={"/findFirstMenuSpace"})
    @ResponseBody
    public Object findFirstMenuSpace(HttpServletRequest request, Long menuId) {
        Long deptId;
        Long orgId;
        List<Map<String, Object>> list;
        LoginUser loginUser = this.getLoginUser(request);
        String station = loginUser.getStation();
        if (menuId == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)station)) {
            station = "3";
        }
        if ((list = this.gmspacedefineService.findFirstMenuSpace(menuId, station, orgId = loginUser.getOrgid(), deptId = loginUser.getDeptid())) != null && list.size() > 0) {
            Map<String, Object> map = list.get(0);
            return map.get("spaceId");
        }
        return null;
    }

    @RequestMapping(value={"/myFlowXL"})
    @ResponseBody
    public Object myFlowXL(HttpServletRequest request, Long accountId) {
        ModelAndView view = new ModelAndView();
        Object fq = this.basMessageService.getMyFlow(accountId, "1");
        Object yb = this.basMessageService.getMyFlow(accountId, "2");
        Object wb = this.basMessageService.getMyFlow(accountId, "3");
        Object cq = this.basMessageService.getMyFlow(accountId, "0");
        view.addObject("fqCount", fq);
        view.addObject("ybCount", yb);
        view.addObject("wbCount", wb);
        view.addObject("cqCount", cq);
        view.setViewName("/space/model/myFlowXL");
        return view;
    }

    @RequestMapping(value={"/myFlowDB"})
    @ResponseBody
    public Object myFlowDB(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        view.setViewName("/space/model/myFlowDB");
        return view;
    }

    @RequestMapping(value={"/myFlowQX"})
    @ResponseBody
    public Object myFlowQX(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        view.setViewName("/space/model/myFlowQX");
        return view;
    }

    @RequestMapping(value={"/task"})
    public Object task(HttpServletRequest request, Model model) {
        LoginUser loginUser = this.getLoginUser(request);
        model.addAttribute("copycou", (Object)this.firstPageService.getAccountMessageList(loginUser.getAccountid(), SysContent.MSG_COPY).size());
        model.addAttribute("msgcou", (Object)this.firstPageService.getAccountMessageList(loginUser.getAccountid()).size());
        return "/space/model/task";
    }

    @RequestMapping(value={"/myCommonProcesses"})
    public Object myCommonProcesses(Model model, String contentHeight, String search) {
        if (StringUtils.isBlank((CharSequence)contentHeight)) {
            contentHeight = "300px";
        }
        int maxsize = Integer.parseInt(contentHeight.replaceAll("px", "")) / 46;
        List<Map<String, Object>> list = this.gmspacedefineService.getMyCommonProcesses(search);
        if (list.size() > maxsize) {
            list = list.subList(0, maxsize);
        }
        model.addAttribute("processesList", list);
        return "/space/model/myCommonProcesses";
    }

    @RequestMapping(value={"/getBaCockpit"})
    public Object getBaCockpit(Model model) {
        List<Map<String, Object>> income = this.gmspacedefineService.getIncomeList("income");
        model.addAttribute("income", income);
        List<Map<String, Object>> cost = this.gmspacedefineService.getIncomeList("cost");
        model.addAttribute("cost", cost);
        List<Map<String, Object>> yearList = this.gmspacedefineService.getIncomeListByYear();
        model.addAttribute("yearList", yearList);
        BigDecimal incomeValueTotal = new BigDecimal("0");
        BigDecimal costValueTotal = new BigDecimal("0");
        for (Map<String, Object> map : yearList) {
            if (map.get("incomeValue") != null) {
                incomeValueTotal = incomeValueTotal.add(new BigDecimal(map.get("incomeValue").toString()));
            }
            if (map.get("costValue") == null) continue;
            costValueTotal = costValueTotal.add(new BigDecimal(map.get("costValue").toString()));
        }
        model.addAttribute("incomeValueTotal", (Object)incomeValueTotal);
        model.addAttribute("costValueTotal", (Object)costValueTotal);
        List<Map<String, Object>> assetsList = this.gmspacedefineService.getGmAssetsInventory();
        model.addAttribute("assetsList", assetsList);
        Map<String, Object> wgmap = this.gmspacedefineService.getGmAssetsInventoryWG();
        model.addAttribute("wgmap", wgmap);
        Map<String, Object> coninfo = this.gmspacedefineService.getConIncomeInfo();
        model.addAttribute("coninfo", coninfo);
        return "/space/ba/baCockpit";
    }

    @RequestMapping(value={"/getZcCockpit"})
    public Object getZcCockpit(Model model) {
        Map<String, Object> houseInfo = this.gmspacedefineService.getHouseInfo();
        model.addAttribute("houseInfo", houseInfo);
        Map<String, Object> moneyInfo = this.gmspacedefineService.getMoneyInfo();
        model.addAttribute("moneyInfo", moneyInfo);
        Map<String, Object> conInfo = this.gmspacedefineService.getConInfo();
        model.addAttribute("conInfo", conInfo);
        Map<String, Object> financeMoneyInfo = this.gmspacedefineService.getFinanceMoneyInfo();
        model.addAttribute("financeMoneyInfo", financeMoneyInfo);
        return "/space/zc/zcCockpit";
    }

    @RequestMapping(value={"/getFundCockpit"})
    public Object getFundCockpit(Model model) {
        model.addAttribute("fund", this.gmspacedefineService.getFundMoney());
        return "/space/fund/index";
    }

    @RequestMapping(value={"/getFundBalanceDetail"})
    public Object getFundBalanceDetail(Model model) {
        return "/space/fund/FundBalanceDetail";
    }

    @RequestMapping(value={"/getConCockpit"})
    public Object getConCockpit(Model model) {
        model.addAttribute("conInfo", this.gmspacedefineService.getConCockpit());
        return "/query/contract/pubConQuery";
    }

    @RequestMapping(value={"/copyList"})
    @ResponseBody
    public ModelAndView copyList(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        LoginUser loginUser = this.getLoginUser(request);
        List<BasMessage> copylist = this.firstPageService.getAccountMessageList(loginUser.getAccountid(), SysContent.MSG_COPY);
        int messagesize = copylist.size();
        String contentHeight = request.getParameter("contentHeight");
        if (StringUtils.isBlank((CharSequence)contentHeight)) {
            contentHeight = "300px";
        }
        int maxsize = Integer.parseInt(contentHeight.replaceAll("px", "")) / 46;
        if (copylist.size() > maxsize) {
            copylist = copylist.subList(0, maxsize);
        }
        for (BasMessage basMessage : copylist) {
            PrettyTime p = new PrettyTime(Locale.CHINESE);
            basMessage.setPrettysendtime(p.format(basMessage.getSendtime()));
        }
        view.setViewName("/space/model/copyList");
        view.addObject("copylist", copylist);
        view.addObject("copytimestamp", (Object)System.currentTimeMillis());
        view.addObject("messagesize", (Object)messagesize);
        view.addObject("messageurl", (Object)"messageurl");
        return view;
    }
}

