/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.ustc.base.common.exception.GEPSBisException;
import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.controller.BaseController;
import com.ustc.base.dao.GmInfoReadDao;
import com.ustc.base.entity.GmInfoContent;
import com.ustc.base.entity.GmInfoPraise;
import com.ustc.base.entity.GmInfoPublishScope;
import com.ustc.base.entity.GmInfoRead;
import com.ustc.base.service.BasEmpService;
import com.ustc.base.service.GmInfoCommentService;
import com.ustc.base.service.GmInfoContentService;
import com.ustc.base.service.GmInfoPraiseService;
import com.ustc.base.service.GmInfoPublishScopeService;
import com.ustc.base.service.GmInfoReadService;
import com.ustc.base.service.GmInfoTypeService;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.doc.service.DocFileVersionService;
import com.ustc.workflow.service.FlowUtilService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/GmInfoContent"})
public class GmInfoContentController
extends BaseController {
    @Autowired
    private GmInfoPublishScopeService gmInfoPublishScopeService;
    @Autowired
    private GmInfoContentService gminfocontentService;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private GmInfoReadService gmInfoReadService;
    @Autowired
    private GmInfoReadDao gmInfoReadDao;
    @Autowired
    private GmInfoTypeService gminfotypeService;
    @Autowired
    private DocFileVersionService docFileVersionService;
    @Autowired
    private BasEmpService basEmpService;
    @Autowired
    private GmInfoPraiseService gmInfoPraiseService;
    @Autowired
    private GmInfoCommentService gmInfoCommentService;

    @RequestMapping(value={"/pageGmInfoContent"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageGmInfoContent(HttpServletRequest request, Long flowDone, String keyWord, Boolean myPublish, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order, Long infoTypeId, @RequestParam(value="contentTitle", defaultValue="") String contentTitle, @RequestParam(value="publishPerson", defaultValue="") String publishPerson, String publishStart, String publishEnd, String query) {
        Long accountid = this.getLoginUser(request).getAccountid();
        return this.gminfocontentService.PageAll(flowDone, search, query, page, rows, sort, order, accountid, infoTypeId, contentTitle, publishPerson, publishStart, publishEnd, keyWord, myPublish);
    }

    @RequestMapping(value={"/pageHistoryGmInfoContent"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageHistoryGmInfoContent(HttpServletRequest request, Long infoId, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order, Long infoTypeId, @RequestParam(value="contentTitle", defaultValue="") String contentTitle, @RequestParam(value="publishPerson", defaultValue="") String publishPerson, String publishStart, String publishEnd, String query) {
        Long accountid = this.getLoginUser(request).getAccountid();
        return this.gminfocontentService.PageHistory(search, query, page, rows, sort, order, infoId);
    }

    @RequestMapping(value={"/findGmInfoContent"})
    @ResponseBody
    public Object findGmInfoContent(Long id) {
        GmInfoContent entity = this.gminfocontentService.findGmInfoContent(id);
        return entity;
    }

    @RequestMapping(value={"/saveGmInfoContent"})
    @ResponseBody
    public Object saveGmInfoContent(HttpServletRequest request, GmInfoContent entity, FormFileBean formfile, String formcode, String isApprove, String flowCode, Long bussinessId) throws GEPSBisException {
        String text;
        JsonMsg msg = new JsonMsg();
        if (entity.getWorkflowStatus() != null && entity.getWorkflowStatus() == 3L && (entity.getIsYulan() == null || "N".equals(entity.getIsYulan())) && entity.getPublishDate() == null) {
            entity.setPublishDate(new Date());
        }
        if (StringUtils.isNotEmpty((String)(text = request.getParameter("text")))) {
            entity.setContent(text);
        }
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        if (bussinessId != null) {
            entity.setBussinessid(bussinessId);
        }
        if (entity.getInfoId() == null) {
            entity.setIsHistory("N");
            if (entity.getWorkflowStatus() != null && entity.getWorkflowStatus().intValue() == 3) {
                entity.setVersionNo("1.0");
                if (entity.getPublishDate() == null) {
                    entity.setPublishDate(new Date());
                }
            }
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
            entity.setPublishAccontId(this.getLoginUser(request).getAccountid());
            entity.setPublishDeptId(this.getLoginUser(request).getDeptid());
            if (entity.getWorkflowStatus() == null) {
                entity.setWorkflowStatus(SysContent.DEFAULT_STATUS);
            }
        } else {
            String[] oe = this.gminfocontentService.findGmInfoContent(entity.getInfoId());
            entity.setCreateAccount(oe.getCreateAccount());
            entity.setCreateTime(oe.getCreateTime());
        }
        if (entity.getInfoId() != null && entity.getWorkflowStatus().intValue() == 3 && (entity.getIsYulan() == null || "N".equals(entity.getIsYulan()))) {
            entity = this.gminfocontentService.saveHistoryData(entity);
        }
        entity = this.gminfocontentService.saveGmInfoContent(entity, formfile, formcode);
        if ("Y".equals(isApprove) && entity.getProcessinstid() == null) {
            this.flowUtilService.createAndStartProcess(this.getLoginUser(request).getAccountid(), flowCode, "GM_INFO_CONTENT", entity.getInfoId());
        }
        this.gmInfoPublishScopeService.deleteByInfoId(entity.getInfoId());
        if (!StringUtils.isEmpty((String)entity.getPublishScope())) {
            for (String id : entity.getPublishScope().split(",")) {
                GmInfoPublishScope info = new GmInfoPublishScope();
                String[] idArray = id.split(":");
                info.setInfoId(entity.getInfoId());
                info.setUserType(idArray[0]);
                info.setUserId(Long.parseLong(idArray[1]));
                info.setModifyAccount(SysUtils.getLoginUser().getAccountid());
                info.setModifyTime(new Date());
                info.setIsUse("Y");
                info.setCreateAccount(SysUtils.getLoginUser().getAccountid());
                info.setCreateTime(new Date());
                this.gmInfoPublishScopeService.saveGmInfoPublishScope(info);
            }
        }
        if (entity.getWorkflowStatus() != null && entity.getWorkflowStatus().intValue() == 3 && "Y".equals(entity.getIsNotice())) {
            this.gminfocontentService.publishEvent(entity.getInfoId());
        }
        Map<String, Object> map = this.gminfocontentService.findGmInfoContentInfo(entity.getInfoId());
        map.remove("content");
        msg.setO(map);
        return msg;
    }

    @RequestMapping(value={"/delGmInfoContent"})
    @ResponseBody
    public Object delGmInfoContent(Long id) {
        this.gmInfoPublishScopeService.deleteByInfoId(id);
        this.gminfocontentService.delGmInfoContent(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/toContentFormView"})
    public Object toContentFormView(HttpServletRequest request, Model model, Long id, String type) {
        if ("WPS".equals(type) || "WORD".equals(type)) {
            return "/doc/iweboffice/OpenAndSave_Word";
        }
        return "";
    }

    @RequestMapping(value={"/viewGmInfoContent"})
    public Object viewGmInfoContent(HttpServletRequest request, Model model, Long id, Boolean isdetail) {
        GmInfoContent gmInfoContent = new GmInfoContent();
        gmInfoContent.setCanPraise("Y");
        gmInfoContent.setCanComment("Y");
        if (id != null) {
            gmInfoContent = this.gminfocontentService.findGmInfoContent(id);
            Map<String, Object> map = this.gminfocontentService.findGmInfoContentInfo(id);
            model.addAttribute("map", map);
            if (StringUtils.isNotEmpty((String)gmInfoContent.getPicUrl())) {
                model.addAttribute("picName", (Object)this.docFileVersionService.findDocFileVersion(Long.parseLong(gmInfoContent.getPicUrl())).getOriginalName());
            }
        }
        model.addAttribute("entity", (Object)gmInfoContent);
        model.addAttribute("isdetail", (Object)isdetail);
        if (isdetail != null) {
            return "/business/gm/GmInfoContentformDtl";
        }
        return "/business/gm/GmInfoContentform";
    }

    @RequestMapping(value={"/previewGmInfoContent"})
    public Object previewGmInfoContent(HttpServletRequest request, Model model, Long id) {
        GmInfoContent gmInfoContent = new GmInfoContent();
        if (id != null) {
            gmInfoContent = this.gminfocontentService.findGmInfoContent(id);
            if ("URL".equals(gmInfoContent.getContentFormat())) {
                if (gmInfoContent.getContent().contains("http")) {
                    return "redirect:" + gmInfoContent.getContent().replace("<p>", "").replace("</p>", "");
                }
                return "redirect: http://" + gmInfoContent.getContent().replace("<p>", "").replace("</p>", "");
            }
            Map<String, Object> map = this.gminfocontentService.findGmInfoContentInfo(id);
            if (!gmInfoContent.getPanelfilelist().isEmpty()) {
                model.addAttribute("fileList", gmInfoContent.getPanelfilelist());
            }
            map.put("isReadingPeople", "Y");
            map.put("isReleasePeople", "Y");
            model.addAttribute("entity", map);
            GmInfoRead read = new GmInfoRead();
            read.setAccountId(this.getLoginUser(request).getAccountid());
            read.setInfoId(gmInfoContent.getInfoId());
            read.setInfoSource("PC");
            read.setOrgId(this.getLoginUser(request).getOrgid());
            read.setReadDate(new Date());
            this.gmInfoReadService.saveGmInfoRead(read);
            GmInfoPraise praise = this.gmInfoPraiseService.findPraiseDataByInfoId(this.getLoginUser(request).getAccountid(), id, "1");
            model.addAttribute("praise", (Object)praise);
            GmInfoPraise collect = this.gmInfoPraiseService.findPraiseDataByInfoId(this.getLoginUser(request).getAccountid(), id, "2");
            model.addAttribute("collect", (Object)collect);
            int praiseCount = this.gmInfoPraiseService.findPraiseCountByInfoId(id);
            model.addAttribute("praiseCount", (Object)praiseCount);
            int commentCount = this.gmInfoCommentService.findCommentCount(id);
            model.addAttribute("commentCount", (Object)commentCount);
            if ("Y".equals(gmInfoContent.getExternalOa())) {
                // empty if block
            }
            this.gmInfoReadDao.flush();
            List<Map<String, Object>> list = this.gmInfoReadService.getReadList(gmInfoContent.getInfoId());
            model.addAttribute("readList", list);
            model.addAttribute("readNum", (Object)list.size());
            int connectFlowCount = this.gmInfoReadService.findConnectFlowCount(gmInfoContent.getInfoId(), "GmInfoContent");
            model.addAttribute("connectFlowCount", (Object)connectFlowCount);
        }
        return "/business/gm/content";
    }

    @RequestMapping(value={"/previewList"})
    public Object previewList(HttpServletRequest request, Model model, Long typeId) {
        Long accountId = this.getLoginUser(request).getAccountid();
        Long hrEmId = this.getLoginUser(request).getHrEmp().getEmpId();
        model.addAttribute("typeId", (Object)typeId);
        Integer createCount = this.gminfocontentService.findCreateByAccountId(accountId);
        model.addAttribute("createCount", (Object)createCount);
        Integer checkCount = this.gminfocontentService.findCheckByAccountId(accountId);
        model.addAttribute("checkCount", (Object)checkCount);
        return "/business/gm/list";
    }

    @RequestMapping(value={"/gmInfoContentSearch"})
    public Object gmInfoContentSearch(HttpServletRequest request, Model model) {
        Long accountId = this.getLoginUser(request).getAccountid();
        List<Object> infoTypeList = new ArrayList();
        Long orgid = this.getLoginUser(request).getOrgid();
        infoTypeList = this.gminfotypeService.getInfoTypeListForSearch(orgid);
        model.addAttribute("infoTypeList", infoTypeList);
        return "/business/gm/gmInfoContentSearch";
    }

    @RequestMapping(value={"/findTypeList"})
    @ResponseBody
    public Object findTypeList(HttpServletRequest request, String typeId) {
        JsonMsg msg = new JsonMsg();
        Long accountId = this.getLoginUser(request).getAccountid();
        List<Map<String, Object>> list = this.gminfotypeService.getInfoTypeList(typeId, accountId, this.getLoginUser(request).getOrgid(), this.getLoginUser(request).getDeptid());
        msg.setO(list);
        return msg;
    }

    @RequestMapping(value={"/findContentById"})
    @ResponseBody
    public Object findContentById(HttpServletRequest request, String typeId, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        JsonMsg msg = new JsonMsg();
        List<Map<String, Object>> conList = this.gminfocontentService.findContentById(typeId, this.getLoginUser(request).getAccountid(), this.getLoginUser(request).getOrgid(), this.getLoginUser(request).getDeptid(), page, rows);
        msg.setO(conList);
        return msg;
    }

    @RequestMapping(value={"/viewContentListByIds"})
    public Object viewContentListByIds(Model model, HttpServletRequest request, String typeIds, String title) {
        String contentHeight = request.getParameter("contentHeight");
        if (StringUtils.isBlank((String)contentHeight)) {
            contentHeight = "300px";
        }
        model.addAttribute("contentHeight", (Object)contentHeight);
        model.addAttribute("maxsize", (Object)(Integer.parseInt(contentHeight.replaceAll("px", "")) / 46));
        if (StringUtils.isNotBlank((String)typeIds)) {
            ArrayList list = new ArrayList(typeIds.split(",").length);
            for (String typeId : typeIds.split(",")) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                List<Map<String, Object>> conList = this.gminfocontentService.findTenContentById(typeId, this.getLoginUser(request).getAccountid(), this.getLoginUser(request).getOrgid(), this.getLoginUser(request).getDeptid());
                map.put("info", this.gminfotypeService.findGmInfoType(Long.parseLong(typeId)));
                map.put("list", conList);
                list.add(map);
            }
            model.addAttribute("typeIds", (Object)typeIds);
            model.addAttribute("infoList", list);
        }
        return "/space/model/newsAndNotice";
    }

    @RequestMapping(value={"/findImgContent"})
    public Object findImgContent(Model model, String typeIds, String componentId, String contentHeight) {
        List<Map<String, Object>> imgs = this.gminfocontentService.findImgContent(typeIds);
        model.addAttribute("infoList", imgs);
        if (StringUtils.isBlank((String)contentHeight)) {
            contentHeight = "300px";
        }
        model.addAttribute("componentId", (Object)componentId);
        model.addAttribute("contentHeight", (Object)contentHeight);
        return "/space/model/picNews";
    }

    @RequestMapping(value={"/findPicNewsContent"})
    public Object findPicNewsContent(Model model, String typeIds, String componentId, String contentHeight) {
        List<Map<String, Object>> imgs = this.gminfocontentService.findPicNewsContent();
        List<Map<String, Object>> picNews = this.gminfocontentService.findImgContent(null);
        model.addAttribute("infoList", imgs);
        model.addAttribute("infoPicList", picNews);
        if (StringUtils.isBlank((String)contentHeight)) {
            contentHeight = "300px";
        }
        model.addAttribute("componentId", (Object)componentId);
        model.addAttribute("contentHeight", (Object)contentHeight);
        return "/space/model/picNewsContent";
    }

    @RequestMapping(value={"/viewEdit"})
    public Object viewEdit(HttpServletRequest request, Model model, Long id, Boolean isdetail) {
        GmInfoContent gmInfoContent = new GmInfoContent();
        if (id != null) {
            gmInfoContent = this.gminfocontentService.findGmInfoContent(id);
        }
        model.addAttribute("entity", (Object)gmInfoContent);
        model.addAttribute("isdetail", (Object)isdetail);
        return "/business/gm/editor";
    }

    @RequestMapping(value={"/findAllBussinessId"})
    @ResponseBody
    public Object findAllBussinessId(Long id) {
        JsonMsg msg = new JsonMsg();
        GmInfoContent entity = this.gminfocontentService.findGmInfoContentBussiness(id);
        msg.setMsg(entity);
        return msg;
    }

    @RequestMapping(value={"/updateGmInfoContent"})
    @ResponseBody
    public Object updateGmInfoContent(Long businessMainId) {
        GmInfoContent entity = this.gminfocontentService.findGmInfoContent(businessMainId);
        entity.setWorkflowStatus(3L);
        if (entity.getPublishDate() == null) {
            entity.setVersionNo("1.0");
            entity.setPublishDate(new Date());
        } else {
            entity = this.gminfocontentService.saveHistoryData(entity);
        }
        this.gminfocontentService.saveGmInfoContent(entity);
        return new JsonMsg(true, "\u63d0\u4ea4\u6210\u529f");
    }

    @RequestMapping(value={"/findGmInfoTypeData"})
    @ResponseBody
    public Object findGmInfoTypeData(@RequestParam(value="pid", defaultValue="0") Long pid) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        List<ComBoxTreeNode> treelist = this.gminfocontentService.findGmInfoTypeData(pid);
        root.setId("0");
        root.setText("\u6240\u6709\u4fe1\u606f");
        root.setChecked(false);
        root.setChildren(treelist);
        list.add(root);
        return list;
    }
}

