/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.alibaba.fastjson.JSONObject;
import com.ibm.icu.text.DateFormat;
import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasMenu;
import com.ustc.base.entity.BasMessage;
import com.ustc.base.entity.BasModel;
import com.ustc.base.service.BasMenuService;
import com.ustc.base.service.BasMessageService;
import com.ustc.base.service.BasRolesMenuTopService;
import com.ustc.base.service.BasRolesModelService;
import com.ustc.base.service.FirstPageService;
import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.prettytime.PrettyTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/firstpage"})
public class FirstPageController
extends BaseController {
    @Autowired
    private BasRolesModelService basRolesModelService;
    @Autowired
    private BasMessageService basMessageService;
    @Autowired
    private BasMenuService basMenuService;
    @Autowired
    private FirstPageService firstPageService;
    @Autowired
    private BasRolesMenuTopService BasRolesMenuTopService;

    @RequestMapping(value={"/findHomePages"})
    @ResponseBody
    public ModelAndView findHomePages(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        LoginUser loginUser = this.getLoginUser(request);
        List<BasModel> modellist = this.basRolesModelService.findAccountModel(loginUser.getAccountid());
        view.setViewName("/firstpage/HomePage");
        view.addObject("modellist", modellist);
        return view;
    }

    @RequestMapping(value={"/todo"})
    @ResponseBody
    public ModelAndView todo(HttpServletRequest request) throws ParseException {
        PrettyTime p;
        ModelAndView view = new ModelAndView();
        LoginUser loginUser = this.getLoginUser(request);
        List<Map<String, Object>> msglist = this.firstPageService.findAccountTodoList(loginUser.getAccountid());
        List<BasMessage> msgHaveDoneList = this.basMessageService.queryHaveDoneList(loginUser.getAccountid(), "", 1, 10);
        int msgsize = msglist.size();
        int havesize = msgHaveDoneList.size();
        if (msglist.size() > 9) {
            msglist = msglist.subList(0, 9);
        }
        for (Map<String, Object> map : msglist) {
            p = new PrettyTime(Locale.CHINESE);
            map.put("prettysendtime", p.format((Date)map.get("sendtime")));
        }
        if (msgHaveDoneList.size() > 9) {
            msgHaveDoneList = msgHaveDoneList.subList(0, 9);
        }
        for (BasMessage basMessage : msgHaveDoneList) {
            p = new PrettyTime(Locale.CHINESE);
            basMessage.setPrettysendtime(p.format(basMessage.getSendtime()));
        }
        view.setViewName("/firstpage/model/todo");
        view.addObject("msglist", msglist);
        view.addObject("msgsize", (Object)msgsize);
        view.addObject("msgurl", (Object)"msgurl");
        view.addObject("oaurl", (Object)"oaurl");
        view.addObject("havelist", msgHaveDoneList);
        view.addObject("havesize", (Object)havesize);
        view.addObject("haveurl", (Object)"haveurl");
        return view;
    }

    @RequestMapping(value={"/message"})
    @ResponseBody
    public ModelAndView message(HttpServletRequest request, String search) {
        ModelAndView view = new ModelAndView();
        LoginUser loginUser = this.getLoginUser(request);
        List<BasMessage> messagelist = this.firstPageService.getAccountMessageList(loginUser.getAccountid(), SysContent.MSG_ALERT);
        List<BasMessage> warninglist = this.basMessageService.findAccountWarningList(loginUser.getAccountid(), null);
        Comparator<BasMessage> comparator = new Comparator<BasMessage>(){

            @Override
            public int compare(BasMessage o1, BasMessage o2) {
                if (o1.getSendtime() != null && o2.getSendtime() != null) {
                    return o2.getSendtime().compareTo(o1.getSendtime());
                }
                return 1;
            }
        };
        Collections.sort(warninglist, comparator);
        int messagesize = messagelist.size();
        int warningsize = warninglist.size();
        if (messagelist.size() > 9) {
            messagelist = messagelist.subList(0, 9);
        }
        if (warninglist.size() > 9) {
            warninglist = warninglist.subList(0, 9);
        }
        for (BasMessage basMessage : messagelist) {
            PrettyTime p = new PrettyTime(Locale.CHINESE);
            basMessage.setPrettysendtime(p.format(basMessage.getSendtime()));
        }
        for (BasMessage basMessage : warninglist) {
            basMessage.setPrettysendtime(DateFormat.getDateInstance().format(basMessage.getSendtime()));
        }
        view.setViewName("/firstpage/model/message");
        view.addObject("messagelist", messagelist);
        view.addObject("messagesize", (Object)messagesize);
        view.addObject("messageurl", (Object)"messageurl");
        view.addObject("warningurl", (Object)"warningurl");
        view.addObject("warninglist", warninglist);
        view.addObject("warningsize", (Object)warningsize);
        return view;
    }

    @RequestMapping(value={"/todoForBD"})
    @ResponseBody
    public Object todoForBD(HttpServletRequest request) {
        PrettyTime p;
        LoginUser loginUser = this.getLoginUser(request);
        List<Map<String, Object>> msglist = this.firstPageService.findAccountTodoList(loginUser.getAccountid());
        List<BasMessage> msgHaveDoneList = this.basMessageService.queryHaveDoneList(loginUser.getAccountid(), "", 1, 10);
        Comparator<BasMessage> comparator = new Comparator<BasMessage>(){

            @Override
            public int compare(BasMessage o1, BasMessage o2) {
                if (o1.getSendtime() != null && o2.getSendtime() != null) {
                    return o2.getSendtime().compareTo(o1.getSendtime());
                }
                return 1;
            }
        };
        Collections.sort(msgHaveDoneList, comparator);
        int msgsize = msglist.size();
        int havesize = msgHaveDoneList.size();
        if (msglist.size() > 9) {
            msglist = msglist.subList(0, 9);
        }
        for (Map<String, Object> map : msglist) {
            p = new PrettyTime(Locale.CHINESE);
            map.put("prettysendtime", p.format((Date)map.get("sendtime")));
        }
        if (msgHaveDoneList.size() > 9) {
            msgHaveDoneList = msgHaveDoneList.subList(0, 9);
        }
        for (BasMessage basMessage : msgHaveDoneList) {
            p = new PrettyTime(Locale.CHINESE);
            basMessage.setPrettysendtime(p.format(basMessage.getSendtime()));
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("msglist", msglist);
        jsonObj.put("msgsize", (Object)msgsize);
        jsonObj.put("msgurl", (Object)"msgurl");
        jsonObj.put("oaurl", (Object)"oaurl");
        jsonObj.put("havelist", msgHaveDoneList);
        jsonObj.put("havesize", (Object)havesize);
        jsonObj.put("haveurl", (Object)"haveurl");
        return jsonObj;
    }

    @RequestMapping(value={"/messagebd"})
    @ResponseBody
    public Object messagebd(HttpServletRequest request) {
        PrettyTime p;
        LoginUser loginUser = this.getLoginUser(request);
        List<BasMessage> messagelist = this.firstPageService.getAccountMessageList(loginUser.getAccountid(), SysContent.MSG_ALERT);
        List<BasMessage> warninglist = this.basMessageService.findAccountWarningList(loginUser.getAccountid(), null);
        Comparator<BasMessage> comparator = new Comparator<BasMessage>(){

            @Override
            public int compare(BasMessage o1, BasMessage o2) {
                if (o1.getSendtime() != null && o2.getSendtime() != null) {
                    return o2.getSendtime().compareTo(o1.getSendtime());
                }
                return 1;
            }
        };
        Collections.sort(warninglist, comparator);
        int messagesize = messagelist.size();
        int warningsize = warninglist.size();
        if (messagelist.size() > 9) {
            messagelist = messagelist.subList(0, 9);
        }
        for (BasMessage basMessage : messagelist) {
            p = new PrettyTime(Locale.CHINESE);
            basMessage.setPrettysendtime(p.format(basMessage.getSendtime()));
        }
        if (warninglist.size() > 9) {
            warninglist = warninglist.subList(0, 9);
        }
        for (BasMessage basMessage : warninglist) {
            p = new PrettyTime(Locale.CHINESE);
            basMessage.setPrettysendtime(DateFormat.getDateInstance().format(basMessage.getSendtime()));
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("messagelist", messagelist);
        jsonObj.put("messagesize", (Object)messagesize);
        jsonObj.put("messageurl", (Object)"messageurl");
        jsonObj.put("warninglist", warninglist);
        jsonObj.put("warningsize", (Object)warningsize);
        jsonObj.put("warningurl", (Object)"warningurl");
        return jsonObj;
    }

    @RequestMapping(value={"/secondtop"})
    @ResponseBody
    public ModelAndView secondtop(HttpServletRequest request, Long menuid) {
        ModelAndView view = new ModelAndView();
        LoginUser loginUser = this.getLoginUser(request);
        List<ComBoxTreeNode> menulist = this.basMenuService.getAccountSecondTopMenu(loginUser.getAccountid(), menuid);
        view.setViewName("/firstpage/model/secondtop");
        view.addObject("menulist", menulist);
        return view;
    }

    @RequestMapping(value={"/pageBRiska"})
    @ResponseBody
    public Object pageBRiska(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order, String riskType) {
        Long accountid = this.getLoginUser(request).getAccountid();
        return this.firstPageService.pageBRiska(accountid, search, page, rows, sort, order, riskType);
    }

    @RequestMapping(value={"/pageBRisk"})
    @ResponseBody
    public Object pageBRisk(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order, String riskType, String risklevel, String startDate, String endDate) throws ParseException {
        return this.firstPageService.pageBRisk(search, page, rows, sort, order, riskType, risklevel, startDate, endDate);
    }

    @RequestMapping(value={"/oamodel"})
    @ResponseBody
    public ModelAndView oamodel(HttpServletRequest request, String id, String spaceType, String spaceId) {
        ModelAndView view = new ModelAndView();
        return view;
    }

    @RequestMapping(value={"/oanews/ct"})
    @ResponseBody
    public ModelAndView oanewsct(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        return view;
    }

    @RequestMapping(value={"/oabuls/ct"})
    @ResponseBody
    public ModelAndView oabulsct(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        return view;
    }

    @RequestMapping(value={"/oanews/hc"})
    @ResponseBody
    public ModelAndView oanewshc(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        return view;
    }

    @RequestMapping(value={"/oabuls/hc"})
    @ResponseBody
    public ModelAndView oabulshc(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        return view;
    }

    @RequestMapping(value={"/oanews/hy"})
    @ResponseBody
    public ModelAndView oanewshy(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        return view;
    }

    @RequestMapping(value={"/oabuls/hy"})
    @ResponseBody
    public ModelAndView oabulshy(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        return view;
    }

    @RequestMapping(value={"/topmodel"})
    @ResponseBody
    public ModelAndView topmodel(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        LoginUser loginUser = this.getLoginUser(request);
        List<BasMenu> menulist = this.BasRolesMenuTopService.findMenuTop(20L, loginUser.getAccountid());
        Double topwidth = 96.0;
        if (menulist.size() > 0) {
            topwidth = topwidth / (double)menulist.size();
        }
        view.setViewName("/firstpage/model/topmodel");
        view.addObject("topwidth", (Object)topwidth);
        view.addObject("menulist", menulist);
        return view;
    }

    @RequestMapping(value={"/projectInfo"})
    @ResponseBody
    public ModelAndView projectInfo(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        Map<String, Object> map = this.firstPageService.getProjectInfo();
        view.setViewName("/firstpage/model/projectinfo");
        view.addObject("map", map);
        return view;
    }
}

