/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.PageUtil;
import com.alibaba.fastjson.JSONObject;
import com.ustc.base.common.spring.SpringContextHolder;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.controller.BaseController;
import com.ustc.base.dao.BasEmpAccountDao;
import com.ustc.base.dao.BasEmpDao;
import com.ustc.base.entity.BasEmp;
import com.ustc.base.entity.BasMessage;
import com.ustc.base.service.BasMessageService;
import com.ustc.gen.common.BuildType;
import com.ustc.gen.entity.GenForm;
import com.ustc.gen.entity.GenFormPanel;
import com.ustc.gen.service.GenFormFlowService;
import com.ustc.gen.service.GenFormPanelService;
import com.ustc.gen.service.GenFormService;
import com.ustc.workflow.entity.ComparatorLine;
import com.ustc.workflow.entity.WfActivityParams;
import com.ustc.workflow.service.FlowUtilService;
import com.ustc.workflow.service.StfBusinessProcessService;
import com.ustcsoft.usiflow.engine.model.WorkItem;
import com.ustcsoft.usiflow.engine.model.elements.ActivityElement;
import com.ustcsoft.usiflow.engine.model.elements.ProcessElement;
import com.ustcsoft.usiflow.engine.repository.IWorkItemRepository;
import com.ustcsoft.usiflow.engine.xml.ProcessDefineParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/BasMessage"})
public class BasMessageController
extends BaseController {
    @Autowired
    private BasMessageService basmessageService;
    @Autowired
    private BasEmpDao basEmpDao;
    @Autowired
    private BasEmpAccountDao basEmpAccountDao;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private GenFormService genformService;
    @Autowired
    private GenFormFlowService genFormFlowService;
    @Autowired
    private StfBusinessProcessService sbpservice;
    @Autowired
    private GenFormPanelService formPanelService;

    @RequestMapping(value={"/pageBasMessage"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBasMessage(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.basmessageService.PageAll(search, page, rows);
    }

    @RequestMapping(value={"/pageToDoList"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageToDoList(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String msgType) {
        String subject = request.getParameter("subject");
        String startDate = request.getParameter("startDate");
        String endDate = request.getParameter("endDate");
        List<Map<String, Object>> msglist = this.basmessageService.PageToDoList(this.getLoginUser(request).getAccountid(), search, subject, startDate, endDate);
        int resultSize = msglist.size();
        if (resultSize <= rows) {
            return msglist;
        }
        PageUtil.setFirstPageNo((int)1);
        int[] startEnd = PageUtil.transToStartEnd((int)page, (int)rows);
        if (startEnd[1] > resultSize) {
            startEnd[1] = resultSize;
        }
        List<Map<String, Object>> rowslist = msglist.subList(startEnd[0], startEnd[1]);
        PageObject<Map<String, Object>> pageobject = new PageObject<Map<String, Object>>();
        int totalPage = msglist.size() % rows == 0 ? msglist.size() / rows : msglist.size() / rows + 1;
        pageobject.setTotal(msglist.size());
        pageobject.setPageNumber(totalPage);
        pageobject.setCurrpage(page);
        pageobject.setRows(rowslist);
        return pageobject;
    }

    @RequestMapping(value={"/pageHaveDoneList"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageHaveDoneList(HttpServletRequest request, String startDate, String endDate, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.basmessageService.pageHaveDoneList("true", this.getLoginUser(request).getAccountid(), startDate, endDate, search, page, rows);
    }

    @RequestMapping(value={"/pageBusHaveDoneList"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBusHaveDoneList(HttpServletRequest request, String startDate, String endDate, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.basmessageService.pageHaveDoneList("false", this.getLoginUser(request).getAccountid(), startDate, endDate, search, page, rows);
    }

    @RequestMapping(value={"/pageAccountMessageList"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageAccountMessageList(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, String msgType, String isRead, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.basmessageService.pageAccountMessageList(this.getLoginUser(request).getAccountid(), msgType, isRead, search, page, rows);
    }

    @RequestMapping(value={"/pageAccountWarningList"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageAccountWarningList(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        List<BasMessage> list = this.basmessageService.findAccountWarningList(this.getLoginUser(request).getAccountid(), search);
        PageObject<BasMessage> pageobject = new PageObject<BasMessage>();
        pageobject.setCurrpage(page);
        pageobject.setPageNumber(rows);
        pageobject.setRows(list);
        pageobject.setTotal(list.size());
        return pageobject;
    }

    @RequestMapping(value={"/pageBasSysMessage"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBasSysMessage(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.basmessageService.PageSysMessageAll(search, page, rows);
    }

    @RequestMapping(value={"/findBasMessage"})
    @ResponseBody
    public Object findBasMessage(Long id) {
        return this.basmessageService.findBasMessage(id);
    }

    @RequestMapping(value={"/saveBasMessage"})
    @ResponseBody
    public Object saveBasMessage(BasMessage entity) {
        JsonMsg msg = new JsonMsg();
        this.basmessageService.saveBasMessage(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/saveBasSysMessage"})
    @ResponseBody
    public Object saveBasSysMessage(HttpServletRequest request, BasMessage entity) {
        JsonMsg msg = new JsonMsg();
        entity.setMsgType(2L);
        entity.setBusiType(0L);
        entity.setIsUse("Y");
        entity.setSender(this.getLoginUser(request).getAccountid());
        entity.setBusiMainId("0");
        entity.setFormCode("0");
        entity.setIsPublic("Y");
        this.basmessageService.saveBasMessage(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delBasMessage"})
    @ResponseBody
    public Object delBasMessage(Long id) {
        this.basmessageService.delBasMessage(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/isHaveTodo"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageHaveDoneList(HttpServletRequest request, Long accountId) {
        BasEmp basEmp = this.basEmpDao.findByHrEmpIdAndIsUse(accountId, "Y");
        if (basEmp != null) {
            Long accountId1 = this.basEmpAccountDao.findByEmpId(basEmp.getEmpId()).getAccountId();
            return this.basmessageService.isHaveTodo(accountId1);
        }
        return 0;
    }

    @RequestMapping(value={"/todoDetail"})
    @ResponseBody
    public ModelAndView todoDetail(HttpServletRequest request, Long msgid, @RequestParam(value="signlePage", defaultValue="true") boolean signlePage) {
        ModelAndView view = new ModelAndView();
        String isLayer = request.getParameter("isLayer");
        view.addObject("isLayer", (Object)isLayer);
        Long accountId = this.getLoginUser(request).getAccountid();
        BasMessage message = this.basmessageService.findBasMessageByAccountId(msgid, accountId);
        view.addObject("isdetail", (Object)"true");
        if (message != null) {
            if (StrKit.isBlank(message.getMsgUrl())) {
                if (message.getProcessinstid() != null) {
                    GenForm form = this.genformService.findGenFormByCode(message.getFormCode());
                    view.addObject("form", (Object)form);
                    if (StrKit.notBlank(form.getExtraJsUrl())) {
                        view.addObject("urlList", (Object)form.getExtraJsUrl().split(";"));
                    }
                    List<GenFormPanel> panellist = this.formPanelService.findByFormID(form.getId());
                    for (GenFormPanel p : panellist) {
                        if (!BuildType.PANEL_FORM_PS.equals(p.getPanelType())) continue;
                        view.addObject("isHavePishi", (Object)"Y");
                        break;
                    }
                    ProcessElement pe = ProcessDefineParser.createProcessXml((String)this.sbpservice.queryFlowContent(null, message.getProcessinstid()));
                    IWorkItemRepository workitemrep = (IWorkItemRepository)SpringContextHolder.getApplicationContext().getBean(IWorkItemRepository.class);
                    WorkItem workItem = workitemrep.findWorkItem(message.getWorkitemid().longValue());
                    if ("1".equals(workItem.getBackoptions()) && workItem.getSourceworkItemId() != 0L) {
                        view.addObject("isback", (Object)"Y");
                        WorkItem backworkItem = workitemrep.findWorkItem(workItem.getSourceworkItemId());
                        view.addObject("backActName", (Object)backworkItem.getWorkItemName());
                    }
                    view.addObject("workitems", this.flowUtilService.queryWorkItemByDefid(message.getProcessinstid(), null));
                    String actId = workItem.getActivityDefId();
                    ActivityElement ae = (ActivityElement)pe.getActivitys().get(actId);
                    view.addObject("actDesc", (Object)ae.getDescription());
                    view.addObject("isAllowAddParticipants", (Object)ae.getIsAllowAddParticipants());
                    view.addObject("isdetail", (Object)(!actId.equals(this.flowUtilService.getFirstAct(message.getProcessinstid())) + ""));
                    view.addObject("freeact", (Object)ae.getIsFreeActivity());
                    if (StringUtils.isNotEmpty((CharSequence)form.getSubmitUrl())) {
                        view.addObject("delurl", form != null ? form.getSubmitUrl().replace("save", "del") : null);
                    }
                    HashMap<String, Object> cond = new HashMap<String, Object>();
                    cond.put("formCode", message.getFormCode());
                    cond.put("businessMainId", message.getBusiMainId());
                    cond.put("msgtitle", message.getMsgTitle());
                    WfActivityParams params = this.flowUtilService.getLineCondition(message.getProcessinstid(), SysUtils.getLoginAccountId(), cond, message.getFormCode());
                    String opinionTexts = this.genformService.getActOpinionTexts(message.getFormCode(), params.getActId());
                    String flowCode = this.genformService.getFlowCodeByFormCode(message.getFormCode());
                    view.addObject("flow", (Object)this.sbpservice.queryWorkFlowPublicVersion(flowCode));
                    if (StringUtils.isNotBlank((CharSequence)opinionTexts)) {
                        String[] opinionText = opinionTexts.split(",");
                        opinionTexts = "";
                        for (String itemId : opinionText) {
                            opinionTexts = opinionTexts + itemId + ",";
                        }
                        if (opinionTexts.length() > 0) {
                            view.addObject("opinionTexts", (Object)opinionTexts.substring(0, opinionTexts.length() - 1));
                        }
                        ComparatorLine comparator = new ComparatorLine();
                        Collections.sort(params.getLines(), comparator);
                        view.addObject("params", (Object)params);
                    }
                }
                view.addObject("signlePage", (Object)signlePage);
                view.setViewName("/common/todoDetail");
                view.addObject("msg", (Object)message);
            } else {
                RedirectView redirectView = new RedirectView(message.getMsgUrl(), true);
                view = new ModelAndView((View)redirectView, request.getParameterMap());
                view.addObject("msg", (Object)message);
            }
        } else {
            view.setViewName("404");
        }
        return view;
    }

    @RequestMapping(value={"/messageDetail"})
    @ResponseBody
    public ModelAndView messageDetail(HttpServletRequest request, Long msgid) {
        Long accountId = this.getLoginUser(request).getAccountid();
        BasMessage message = this.basmessageService.findBasMessageByAccountId(msgid, accountId);
        ModelAndView view = new ModelAndView();
        if (message != null) {
            if (StrKit.isBlank(message.getMsgUrl())) {
                view.setViewName("/common/messageDetail");
                view.addObject("msg", (Object)message);
                String excludeitems = "";
                if (StringUtils.isNotBlank((CharSequence)message.getFormCode())) {
                    view.addObject("form", (Object)this.genformService.findGenFormByCode(message.getFormCode()));
                }
                view.addObject("excludeitems", (Object)excludeitems);
            } else {
                RedirectView redirectView = new RedirectView(message.getMsgUrl(), true);
                view = new ModelAndView((View)redirectView, request.getParameterMap());
                view.addObject("msg", (Object)message);
            }
        } else {
            view.setViewName("404");
        }
        return view;
    }

    @RequestMapping(value={"/haveDoneDetail"})
    @ResponseBody
    public ModelAndView haveDoneDetail(HttpServletRequest request, Long msgid) {
        BasMessage message = this.basmessageService.findBasMessage(msgid);
        ModelAndView view = new ModelAndView();
        view.addObject("isLayer", (Object)request.getParameter("isLayer"));
        if (message != null) {
            view.setViewName("/common/havedoDetail");
            view.addObject("msg", (Object)message);
            String excludeitems = "";
            view.addObject("excludeitems", (Object)excludeitems);
        } else {
            view.setViewName("404");
        }
        return view;
    }

    @RequestMapping(value={"/todoEditableCheck"})
    @ResponseBody
    public ModelAndView todoEditableCheck(HttpServletRequest request, BasMessage message, Long msgid) {
        ModelAndView view = new ModelAndView();
        String isLayer = request.getParameter("isLayer");
        view.addObject("isLayer", (Object)isLayer);
        if (msgid != null) {
            message = this.basmessageService.findBasMessage(msgid);
        }
        if (message != null) {
            String activitydefid = "";
            if (message.getProcessinstid() != null) {
                ProcessElement pe = ProcessDefineParser.createProcessXml((String)this.sbpservice.queryFlowContent(null, message.getProcessinstid()));
                IWorkItemRepository workitemrep = (IWorkItemRepository)SpringContextHolder.getApplicationContext().getBean(IWorkItemRepository.class);
                activitydefid = workitemrep.findWorkItem(message.getWorkitemid().longValue()).getActivityDefId();
            }
            String excludepanels = "";
            String excludeitems = "";
            view.setViewName("/common/todoEditableCheck");
            view.addObject("excludepanels", (Object)excludepanels);
            view.addObject("excludeitems", (Object)excludeitems);
            view.addObject("activitydefid", (Object)activitydefid);
            view.addObject("msg", (Object)message);
        } else {
            view.setViewName("404");
        }
        return view;
    }

    @RequestMapping(value={"/todoArchives"})
    @ResponseBody
    public ModelAndView todoArchives(HttpServletRequest request, Long msgid, @RequestParam(value="isArchive", defaultValue="true") Boolean isArchive) {
        BasMessage message = this.basmessageService.findBasMessage(msgid);
        ModelAndView view = new ModelAndView();
        if (message != null) {
            view.setViewName("/common/todoArchives");
            view.addObject("msg", (Object)message);
            view.addObject("isArchive", (Object)isArchive);
        } else {
            view.setViewName("404");
        }
        return view;
    }

    @RequestMapping(value={"/viewDetail"})
    @ResponseBody
    public ModelAndView viewDetail(HttpServletRequest request, String formcode, String id, Long processinstid) {
        BasMessage message = new BasMessage();
        message.setBusiMainId(id);
        message.setFormCode(formcode);
        message.setProcessinstid(processinstid);
        message.setMsgTitle("\u626b\u63cf\u4fe1\u606f");
        ModelAndView view = new ModelAndView();
        view.setViewName("/common/todoDetail");
        view.addObject("msg", (Object)message);
        view.addObject("hidedoflow", (Object)true);
        return view;
    }

    @RequestMapping(value={"/setMsgIsRead"})
    @ResponseBody
    public Object setMsgIsRead(HttpServletRequest request, String msgIds) {
        Long accountid = this.getLoginUser(request).getAccountid();
        if (StrKit.notBlank(msgIds)) {
            String[] msgs;
            for (String msgid : msgs = msgIds.split(",")) {
                this.basmessageService.setMsgIsRead(accountid, Long.parseLong(msgid));
            }
        } else {
            this.basmessageService.setMsgIsRead(accountid);
        }
        return new JsonMsg();
    }

    @RequestMapping(value={"/delMydeal"})
    @ResponseBody
    public Object delMydeal(HttpServletRequest request, Long processinstid, String businessMainId) {
        this.basmessageService.delMydealByProcessinstid(processinstid, businessMainId);
        return new JsonMsg();
    }

    @RequestMapping(value={"/todoOutDetail"})
    public ModelAndView todoOutDetail(HttpServletRequest request, BasMessage msg) {
        ModelAndView view = new ModelAndView();
        if (SysContent.APP_TYPE_OA == msg.getBusiType()) {
            RedirectView redirectView = new RedirectView(msg.getMsgUrl(), true);
            view = new ModelAndView((View)redirectView, request.getParameterMap());
            return view;
        }
        view.setViewName("404");
        return view;
    }

    @RequestMapping(value={"/getAccountMessageList"})
    @ResponseBody
    public Object getAccountMessageList(HttpServletRequest request) {
        LoginUser loginUser = super.getLoginUser(request);
        List<BasMessage> msglist = this.basmessageService.getAccountMessageList(loginUser.getAccountid(), SysContent.MSG_ALERT);
        for (BasMessage msg : msglist) {
            if (!StringUtils.isBlank((CharSequence)msg.getMsgUrl())) continue;
            msg.setMsgUrl("/BasMessage/todoDetail?msgid=" + msg.getMsgId());
        }
        return msglist;
    }

    @RequestMapping(value={"/getAccountMessageMapList"})
    @ResponseBody
    public Object getAccountMessageMapList(HttpServletRequest request, String type, String queryFormCode, String search) {
        LoginUser loginUser = super.getLoginUser(request);
        List<Map<String, Object>> msglist = this.basmessageService.getAccountMessageMapList(loginUser.getAccountid(), "Y".equals(type) || "N".equals(type) ? type : "A", queryFormCode, search);
        for (Map<String, Object> msg : msglist) {
            if (msg.get("msgUrl") != null) continue;
            msg.put("msgUrl", "/BasMessage/todoDetail?msgid=" + msg.get("msgId"));
        }
        return msglist;
    }

    @RequestMapping(value={"/getAccountMessageMapInfo"})
    @ResponseBody
    public Object getAccountMessageMapInfo(HttpServletRequest request) {
        LoginUser loginUser = super.getLoginUser(request);
        List<Map<String, Object>> msglist = this.basmessageService.getAccountMessageMapInfo(loginUser.getAccountid());
        for (Map<String, Object> msg : msglist) {
            Long read = Long.parseLong(msg.get("read").toString());
            Long notRead = Long.parseLong(msg.get("notRead").toString());
            if (read == 0L && notRead == 0L) {
                return new ArrayList();
            }
            List<Map<String, Object>> list1 = this.basmessageService.findByformCode(loginUser.getAccountid());
            for (Map<String, Object> msg1 : list1) {
                msg.putAll(msg1);
            }
        }
        return msglist;
    }

    @RequestMapping(value={"/getMsgInfoAll"})
    @ResponseBody
    public Object getMsgInfoAll(HttpServletRequest request, String type) {
        LoginUser loginUser = super.getLoginUser(request);
        List<Map<String, Object>> msglist = this.basmessageService.getMsgInfoAll(loginUser.getAccountid(), type.equals("Y") || type.equals("N") ? type : "A");
        for (Map<String, Object> msg : msglist) {
            if (msg.get("msgUrl") != null) continue;
            msg.put("msgUrl", "/BasMessage/todoDetail?msgid=" + msg.get("msgId"));
        }
        return msglist;
    }

    @RequestMapping(value={"/clearMessageList"})
    @ResponseBody
    public Object clearMessageList(HttpServletRequest request) {
        LoginUser loginUser = super.getLoginUser(request);
        this.basmessageService.clearMessageList(loginUser.getAccountid());
        return new JsonMsg();
    }

    @RequestMapping(value={"/setAccountMessageFormReaded"})
    @ResponseBody
    public Object setAccountMessageFormReaded(HttpServletRequest request, String formCode) {
        LoginUser loginUser = super.getLoginUser(request);
        this.basmessageService.setAccountMessageFormReaded(loginUser.getAccountid(), formCode);
        return new JsonMsg();
    }

    @RequestMapping(value={"/setAccountMessageWorkReaded"})
    @ResponseBody
    public Object setAccountMessageWorkReaded(HttpServletRequest request) {
        LoginUser loginUser = super.getLoginUser(request);
        this.basmessageService.setAccountMessageWorkReaded(loginUser.getAccountid());
        return new JsonMsg();
    }

    @RequestMapping(value={"/getAccountMessageAndWarnMapList"})
    @ResponseBody
    public Object getAccountMessageAndWarnMapList(HttpServletRequest request, String type, String queryFormCode, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String msgType) {
        LoginUser loginUser = super.getLoginUser(request);
        ArrayList<BasMessage> messageAndWarns = new ArrayList<BasMessage>();
        List<BasMessage> msglist = this.basmessageService.getAccountMessageAndWarnMapList(loginUser.getAccountid(), "Y".equals(type) || "N".equals(type) ? type : "A", queryFormCode, search, msgType);
        List<BasMessage> warninglist = this.basmessageService.findAccountWarningList(loginUser.getAccountid(), null);
        messageAndWarns.addAll(warninglist);
        messageAndWarns.addAll(msglist);
        for (BasMessage msg : messageAndWarns) {
            if (msg.getMsgUrl() != null) continue;
            msg.setMsgUrl("/BasMessage/todoDetail?msgid=" + msg.getMsgId());
        }
        Comparator<BasMessage> comparator = new Comparator<BasMessage>(){

            @Override
            public int compare(BasMessage o1, BasMessage o2) {
                if (o1.getSendtime() != null && o2.getSendtime() != null) {
                    return o2.getSendtime().compareTo(o1.getSendtime());
                }
                return 1;
            }
        };
        Collections.sort(messageAndWarns, comparator);
        int resultSize = messageAndWarns.size();
        if (resultSize <= rows) {
            return messageAndWarns;
        }
        int[] startEnd = PageUtil.transToStartEnd((int)page, (int)rows);
        if (startEnd[1] > resultSize) {
            startEnd[1] = resultSize;
        }
        List subList = messageAndWarns.subList(startEnd[0], startEnd[1]);
        PageObject pageobject = new PageObject();
        int totalPage = messageAndWarns.size() % rows == 0 ? messageAndWarns.size() / rows : messageAndWarns.size() / rows + 1;
        pageobject.setTotal(messageAndWarns.size());
        pageobject.setPageNumber(totalPage);
        pageobject.setCurrpage(page);
        pageobject.setRows(subList);
        return pageobject;
    }

    @RequestMapping(value={"/setAccountMessageAllReaded"})
    @ResponseBody
    public Object setAccountMessageAllReaded(HttpServletRequest request, String msgId) {
        LoginUser loginUser = super.getLoginUser(request);
        this.basmessageService.setAccountMessageAllReaded(loginUser.getAccountid(), msgId);
        return new JsonMsg();
    }

    @RequestMapping(value={"/getAccountWarningList"})
    @ResponseBody
    public Object getAccountWarningList(HttpServletRequest request) {
        LoginUser loginUser = super.getLoginUser(request);
        List<BasMessage> msglist = this.basmessageService.findAccountWarningList(loginUser.getAccountid(), null);
        return msglist;
    }

    @RequestMapping(value={"/getAccountgetProjectList"})
    @ResponseBody
    public Object getAccountgetProjectList(HttpServletRequest request) {
        Object list = request.getSession().getAttribute("projectList");
        return list;
    }

    @RequestMapping(value={"/getMsgInfo"})
    @ResponseBody
    public Object getMsgInfo(HttpServletRequest request, String itemTypeId) {
        JsonMsg msg = new JsonMsg();
        PageObject pageobject = new PageObject();
        pageobject = this.basmessageService.PageToDoListApp(SysUtils.getLoginAccountId(), itemTypeId, null, null, null);
        List<BasMessage> ammsglist = this.basmessageService.getAccountMessageList(SysUtils.getLoginAccountId(), SysContent.MSG_ALERT);
        List<BasMessage> awmmsglist = this.basmessageService.findAccountWarningList(SysUtils.getLoginAccountId(), null);
        JSONObject msgjson = new JSONObject();
        msgjson.put("msgsize", (Object)pageobject.getTotal());
        msgjson.put("ammsgsize", (Object)ammsglist.size());
        msgjson.put("awmmsgsize", (Object)awmmsglist.size());
        msg.setO(msgjson);
        return msg;
    }

    @RequestMapping(value={"/pageBaseFlowSendInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public PageObject pageBaseFlowSendInfo(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String status) {
        return this.basmessageService.pageBaseFlowSendInfo(search, page, rows, status);
    }

    @RequestMapping(value={"/getUrgePersons"})
    @ResponseBody
    public Object getUrgePersons(String actId, Long processInstId) {
        return MapUtil.of((Object)"rows", this.basmessageService.getUrgePersons(actId, processInstId));
    }

    @RequestMapping(value={"/urge"})
    @ResponseBody
    public Object urge(HttpServletRequest request, String actId, Long processInstId, String ids) {
        return this.basmessageService.sendurge(actId, processInstId, ids);
    }

    @RequestMapping(value={"/getMyAgentInfo"})
    @ResponseBody
    public Object getMyAgentInfo(HttpServletRequest request, String itemTypeId) {
        JsonMsg msg = new JsonMsg();
        PageObject pageobject = new PageObject();
        pageobject = this.basmessageService.PageToDoListApp(SysUtils.getLoginAccountId(), itemTypeId, null, null, null);
        List msgList = pageobject.getRows();
        List<BasMessage> amsglist = this.basmessageService.getAccountMessageList(SysUtils.getLoginAccountId(), SysContent.MSG_ALERT);
        JSONObject msgjson = new JSONObject();
        msgjson.put("lastmsg", msgList.isEmpty() ? null : msgList.get(0));
        msgjson.put("msgsize", (Object)pageobject.getTotal());
        msgjson.put("amsgsize", (Object)amsglist.size());
        msg.setO(msgjson);
        return msg;
    }

    @RequestMapping(value={"/getUndoAccounts"})
    @ResponseBody
    public Object getUndoAccounts(HttpServletRequest request, Long processinstid) {
        return this.basmessageService.getUndoAccounts(processinstid);
    }

    @RequestMapping(value={"/updateMsgAccount"})
    @ResponseBody
    public Object updateMsgAccount(HttpServletRequest request, Long workitemid, Long accountId, Long msgId, Long newaccountId, String newActId, String newActName) {
        this.basmessageService.updateMsgAccount(workitemid, accountId, msgId, newaccountId, newActId, newActName);
        return new JsonMsg();
    }

    @RequestMapping(value={"/updateMsgDeal"})
    @ResponseBody
    public Object updateMsgDeal(HttpServletRequest request, Long processinstid, Long day) {
        this.basmessageService.updateMsgDeal(processinstid, day);
        return new JsonMsg();
    }

    @RequestMapping(value={"/SendMessageToHr"})
    @ResponseBody
    public Object SendMessageToHr(HttpServletRequest request, String accountIds, String checkMonth, String msgTitleType) {
        BasMessage basMessage = new BasMessage();
        JsonMsg msg = new JsonMsg();
        if (!StringUtils.isEmpty((CharSequence)accountIds)) {
            String url = "";
            if ("\u8003\u6838\u6307\u6807".equals(msgTitleType)) {
                url = "/view/business/hr/HrPerformanceCheckMan";
            } else if ("\u7ee9\u6548\u81ea\u8bc4".equals(msgTitleType)) {
                url = "/view/business/hr/HrPerformanceSelfMain";
            }
            List<Long> reciveIds = Arrays.asList(this.StringArray2LongArray(accountIds.split(",")));
            this.basmessageService.saveMessage(null, null, "\u60a8" + checkMonth + "\u7684" + msgTitleType + "\u672a\u5b8c\u6210,\u8bf7\u60a8\u5c3d\u5feb\u5b8c\u6210!", "", SysUtils.getLoginAccountId(), reciveIds, url, "3", "ffff", "-99999", 0L, "", false);
            msg.setMsg("\u6d88\u606f\u63d0\u9192\u6210\u529f!");
            return msg;
        }
        msg.setMsg("\u53d1\u9001\u6d88\u606f\u5931\u8d25!");
        msg.setSuccess(false);
        return msg;
    }

    public Long[] StringArray2LongArray(String[] stringArray) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (String str : stringArray) {
            try {
                list.add(Long.parseLong(str));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        Long[] longArray = list.toArray(new Long[list.size()]);
        return longArray;
    }

    @RequestMapping(value={"/findMsgByProcessinstid"})
    @ResponseBody
    public Object findMsgByProcessinstid(Long processinstid) {
        return this.basmessageService.findMsgByProcessinstid(SysUtils.getLoginAccountId(), processinstid);
    }
}

