/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasMenuButton;
import com.ustc.base.service.BasMenuButtonService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/BasMenuButton"})
public class BasMenuButtonController
extends BaseController {
    @Autowired
    private BasMenuButtonService basmenubuttonService;

    @RequestMapping(value={"/pageBasMenuButton"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBasMenuButton(@RequestParam(value="menuid", defaultValue="0", required=true) Long menuid, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.basmenubuttonService.PageAll(menuid, page, rows);
    }

    @RequestMapping(value={"/findBasMenuButton"})
    @ResponseBody
    public Object findBasMenuButton(Long id) {
        return this.basmenubuttonService.findBasMenuButton(id);
    }

    @RequestMapping(value={"/saveBasMenuButton"})
    @ResponseBody
    public Object saveBasMenuButton(HttpServletRequest request, BasMenuButton entity) {
        JsonMsg msg = new JsonMsg();
        entity.setIsUse("Y");
        if (entity.getButtonId() != null) {
            BasMenuButton oldentity = this.basmenubuttonService.findBasMenuButton(entity.getButtonId());
            entity.setDisplayNo(oldentity.getDisplayNo());
        } else {
            entity.setDisplayNo(100L);
        }
        this.basmenubuttonService.saveBasMenuButton(entity);
        return msg;
    }

    @RequestMapping(value={"/delBasMenuButton"})
    @ResponseBody
    public Object delBasMenuButton(Long id) {
        this.basmenubuttonService.delBasMenuButton(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/saveBasMenuButtonDisplayNo"})
    @ResponseBody
    public Object saveBasMenuButtonDisplayNo(HttpServletRequest request) {
        String data = request.getParameter("data");
        JSONArray listData = JSON.parseArray((String)data);
        for (int i = 0; i < listData.size(); ++i) {
            Map m = (Map)listData.get(i);
            String id = m.get("BUTTON_ID").toString();
            BasMenuButton item = this.basmenubuttonService.findBasMenuButton(Long.parseLong(id));
            item.setDisplayNo(Long.valueOf(i + 1));
            this.basmenubuttonService.saveBasMenuButton(item);
        }
        return new JsonMsg();
    }

    @RequestMapping(value={"/saveBasMenuButtonByType"})
    @ResponseBody
    public Object saveBasMenuButtonByType(HttpServletRequest request) {
        JsonMsg jsonMsg = new JsonMsg();
        long menuId = Long.parseLong(request.getParameter("rows[0][MENU_ID]"));
        String type = request.getParameter("type");
        String formcode = this.basmenubuttonService.findFormCodeById(menuId);
        if ("".equals(formcode)) {
            jsonMsg.setSuccess(false);
            jsonMsg.setMsg("\u60a8\u8fd8\u6ca1\u6709\u9009\u62e9\u5bf9\u5e94\u9875\u9762");
            return jsonMsg;
        }
        for (int i = 0; i < Integer.parseInt(request.getParameter("size")); ++i) {
            BasMenuButton entity = new BasMenuButton();
            entity.setButtonText(request.getParameter("rows[" + i + "][BUTTON_TEXT]"));
            entity.setMenuId(menuId);
            entity.setMemo(request.getParameter("rows[" + i + "][MEMO]"));
            entity.setType(type);
            String ischeck = request.getParameter("rows[" + i + "][IS_CHECK]");
            String buttonHtmlidPart = request.getParameter("rows[" + i + "][BUTTON_HTMLID]");
            entity.setButtonHtmlid(buttonHtmlidPart + formcode);
            entity.setIsControl("Y");
            this.basmenubuttonService.saveBasMenuButtonByType(entity, ischeck);
        }
        return new JsonMsg();
    }
}

