/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasEmpAccount;
import com.ustc.base.entity.BasFinanceOrgRight;
import com.ustc.base.service.BasEmpAccountService;
import com.ustc.base.service.BasFinanceOrgRightService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/basEmpAccount"})
public class BasEmpAccountController
extends BaseController {
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private BasFinanceOrgRightService basFinanceOrgRightService;

    @RequestMapping(value={"/findAllEmpAccount"})
    @ResponseBody
    public Object findAllEmpAccount() {
        return this.basEmpAccountService.findAllEmpAccountList();
    }

    @RequestMapping(value={"/findEmpAccountByEmpId"})
    @ResponseBody
    public Object findEmpAccountByEmpId(Long empId) {
        if (empId == null) {
            return new ArrayList();
        }
        return this.basEmpAccountService.findEmpAccountByEmpId(empId);
    }

    @RequestMapping(value={"/saveEmpAccount"})
    @ResponseBody
    public Object saveEmpAccount(HttpServletRequest request, BasEmpAccount basEmpAccount) throws RemoteException {
        basEmpAccount.setIsUse("Y");
        String accountFinanceId = basEmpAccount.getFinanceId();
        basEmpAccount = this.basEmpAccountService.saveBasEmpAccount(basEmpAccount);
        this.basFinanceOrgRightService.saveFinanceOrgRight(accountFinanceId, basEmpAccount.getAccountId());
        return new JsonMsg(true, "\u64cd\u4f5c\u6210\u529f", basEmpAccount);
    }

    @RequestMapping(value={"/saveEmpAccountInt"})
    @ResponseBody
    public Object saveEmpAccountInt(BasEmpAccount basEmpAccount) throws RemoteException {
        BasEmpAccount account = this.basEmpAccountService.findById(basEmpAccount.getAccountId());
        account.setEasUser(basEmpAccount.getEasUser());
        account.setHrUser(basEmpAccount.getHrUser());
        account.setRtxUser(basEmpAccount.getRtxUser());
        account.setReserveUser1(basEmpAccount.getReserveUser1());
        account.setReserveUser2(basEmpAccount.getReserveUser2());
        account.setReserveUser3(basEmpAccount.getReserveUser3());
        account = this.basEmpAccountService.saveBasEmpAccount(account);
        return new JsonMsg(true, "\u64cd\u4f5c\u6210\u529f", basEmpAccount);
    }

    @RequestMapping(value={"/delEmpAccount"})
    @ResponseBody
    public Object delEmpAccount(String empAccountId) {
        BasEmpAccount basEmpAccount = this.basEmpAccountService.findEmpAccountById(Long.parseLong(empAccountId));
        basEmpAccount.setIsUse("N");
        this.basEmpAccountService.saveBasEmpAccount(basEmpAccount);
        return new JsonMsg(true, "\u64cd\u4f5c\u6210\u529f", basEmpAccount);
    }

    @RequestMapping(value={"/setEmpAccountDefault"})
    @ResponseBody
    public Object setEmpAccountDefault(Long empAccountId) {
        this.basEmpAccountService.setEmpAccountDefault(empAccountId);
        return new JsonMsg(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/queryEmpAccountById"})
    @ResponseBody
    public Object queryEmpAccountById(Long accountId) {
        BasEmpAccount account = this.basEmpAccountService.findEmpAccountById(accountId);
        List<BasFinanceOrgRight> list = this.basFinanceOrgRightService.findByAccountid(accountId);
        String financeids = "";
        for (BasFinanceOrgRight entity : list) {
            financeids = financeids + entity.getOrgId() + ",";
        }
        if (list.size() > 0) {
            financeids = financeids.substring(0, financeids.length() - 1);
        }
        account.setFinanceId(financeids);
        return account;
    }

    @RequestMapping(value={"/queryAccountNameById"})
    @ResponseBody
    public Object queryEmpAccountById(String accountId) {
        String[] ids = accountId.split(",");
        String accountName = "";
        for (String id : ids) {
            BasEmpAccount account = this.basEmpAccountService.findEmpAccountById(Long.parseLong(id));
            if (account == null) continue;
            accountName = accountName + "," + account.getAccountName();
        }
        if (StringUtils.isNotBlank((CharSequence)accountName)) {
            accountName = accountName.substring(1);
        }
        return accountName;
    }

    @RequestMapping(value={"/pageall"})
    @ResponseBody
    public Object quertAllEmp(HttpServletRequest request, String filterDeptIds, Long orgidNew, Long orgid, Long deptid, Long processinstid, String toActId, String isCopy, String formCode, String search, int page, int rows, @RequestParam(value="isViceStation", defaultValue="") String isViceStation, String showVisual, String roleId, String isHaveOrgAndRole) {
        return (PageObject)this.basEmpAccountService.pageall(filterDeptIds, orgidNew, orgid, deptid, processinstid, toActId, isCopy, formCode, search, page, rows, isViceStation, roleId, isHaveOrgAndRole, showVisual, null);
    }

    @RequestMapping(value={"/getEmpStatisticsMap"})
    @ResponseBody
    public Map<String, Object> getEmpStatisticsMap() {
        return this.basEmpAccountService.getEmpStatisticsMap();
    }

    @RequestMapping(value={"/findByOrgOrBizId"})
    @ResponseBody
    public List findByOrgOrBizId(Long id) {
        return this.basEmpAccountService.findByOrgOrBizIdnew(id);
    }
}

