/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.ustc.base.common.util.ComboxNode;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasDic;
import com.ustc.base.service.BasDicService;
import com.ustc.base.service.CommonService;
import com.ustc.gen.common.BuildItemEnum;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dic"})
public class BasDicController
extends BaseController {
    @Autowired
    private CommonService comService;
    @Autowired
    private BasDicService dicService;

    @RequestMapping(value={"/getalltype"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getAllType(Long typeId, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.dicService.PageAll(typeId, search, page, rows);
    }

    @RequestMapping(value={"/findDic"})
    @ResponseBody
    public Object findDic(Long dicId) {
        return this.dicService.findDic(dicId);
    }

    @RequestMapping(value={"/findDicDB"})
    @ResponseBody
    public Object findDicDB(Long dicId) {
        return this.dicService.findDicDB(dicId);
    }

    @RequestMapping(value={"/saveDic"})
    @ResponseBody
    public Object saveDic(BasDic entity) {
        entity.setDicCode(entity.getDicCode().trim());
        entity.setDicName(entity.getDicName().trim());
        entity.setDicText(entity.getDicText().trim());
        entity.setDicValue(entity.getDicValue().trim());
        JsonMsg msg = this.dicService.checkRepeat(entity);
        if (msg.isSuccess()) {
            if (entity.getIsDefault() == null) {
                entity.setIsDefault(0L);
            }
            this.dicService.saveDic(entity);
            msg.setO(entity);
        }
        return msg;
    }

    @RequestMapping(value={"/delDic"}, method={RequestMethod.GET})
    @ResponseBody
    public Object delDic(String dicids) {
        this.dicService.delDic(dicids);
        return new JsonMsg(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/alldiccode"})
    @ResponseBody
    public List<ComboxNode> getAllDicCode() {
        return this.comService.getAllDicCode();
    }

    @RequestMapping(value={"/dic"})
    @ResponseBody
    public List<ComboxNode> getDicCombo(String typeCode) {
        return this.comService.getDicCombo(typeCode);
    }

    @RequestMapping(value={"/dicPart"})
    @ResponseBody
    public List<ComboxNode> getDicComboPart(String typeCode, String includeValue) {
        return this.comService.getDicComboWithPart(typeCode, includeValue);
    }

    @RequestMapping(value={"/dicdefault"})
    @ResponseBody
    public List<ComboxNode> getDicComboWithDefault(String typeCode) {
        return this.comService.getDicComboWithDefault(typeCode);
    }

    @RequestMapping(value={"/findPayAndReceiveBills"})
    @ResponseBody
    public List<ComboxNode> findPayAndReceiveBills() {
        return this.comService.findPayAndReceiveBills();
    }

    @RequestMapping(value={"/dicwithall"})
    @ResponseBody
    public List<ComboxNode> getDicComboWithAll(String typeCode) {
        return this.comService.getDicComboWithAll(typeCode);
    }

    @RequestMapping(value={"/dicempty"})
    @ResponseBody
    public List<ComboxNode> getDicComboWithEmpty(String typeCode) {
        return this.comService.getDicComboWithEmpty(typeCode);
    }

    @RequestMapping(value={"/dics"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getDictionaryOfTypes(String dicType) {
        String[] types = dicType.split(",");
        return this.comService.getDictionary(types);
    }

    @RequestMapping(value={"/multdics"}, method={RequestMethod.POST})
    @ResponseBody
    public Object multdics(String dicType) {
        String[] types = dicType.split(",");
        return this.comService.multdics(types);
    }

    @RequestMapping(value={"/findTop"})
    @ResponseBody
    public List<ComboxNode> getTopData(String typeCode) {
        return this.comService.getTopData(typeCode);
    }

    @RequestMapping(value={"/getEnumType"})
    @ResponseBody
    public Object getEnumType(String type) {
        ArrayList<ComboxNode> list;
        block4: {
            block5: {
                block3: {
                    list = new ArrayList<ComboxNode>();
                    if (!"item".equals(type)) break block3;
                    for (BuildItemEnum item : BuildItemEnum.values()) {
                        list.add(new ComboxNode(item.getName(), item.getValue()));
                    }
                    break block4;
                }
                if (!"panel".equals(type)) break block5;
                for (BuildItemEnum item : BuildItemEnum.values()) {
                    list.add(new ComboxNode(item.getName(), item.getValue()));
                }
                break block4;
            }
            if (!"formtype".equals(type)) break block4;
            for (BuildItemEnum item : BuildItemEnum.values()) {
                list.add(new ComboxNode(item.getName(), item.getValue()));
            }
        }
        return list;
    }

    @RequestMapping(value={"/findByDicCodeAndValue"})
    @ResponseBody
    public Object findByDicCodeAndValue(String dicCode, String dicValue) {
        JsonMsg msg = new JsonMsg();
        List<BasDic> byDicCodeAndValue = this.dicService.findByDicCodeAndValue(dicCode, dicValue);
        if (!byDicCodeAndValue.isEmpty()) {
            msg.setO(byDicCodeAndValue.get(0).getDicText());
        } else {
            msg.setSuccess(false);
        }
        return msg;
    }

    @RequestMapping(value={"/findDicByDicCode"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBasMenuButton(@RequestParam(value="menuid", defaultValue="0", required=true) Long menuid, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String dicCode) {
        return this.dicService.PageDicByDicCode(menuid, page, rows, dicCode);
    }
}

