/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasArea;
import com.ustc.base.service.BasAreaService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/BasArea"})
public class BasAreaController
extends BaseController {
    @Autowired
    private BasAreaService basareaService;

    @RequestMapping(value={"/pageBasArea"})
    @ResponseBody
    public Object pageBasArea(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.basareaService.PageAll(search, page, rows);
    }

    @RequestMapping(value={"/findBasArea"})
    @ResponseBody
    public Object findBasArea(Long id) {
        return this.basareaService.findBasArea(id);
    }

    @RequestMapping(value={"/saveBasArea"})
    @ResponseBody
    public Object saveBasArea(BasArea entity) {
        JsonMsg msg = new JsonMsg();
        entity.setIsUse("Y");
        this.basareaService.saveBasArea(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delBasArea"})
    @ResponseBody
    public Object delBasArea(Long id) {
        BasArea entity = this.basareaService.findBasArea(id);
        entity.setIsUse("N");
        this.basareaService.saveBasArea(entity);
        return new JsonMsg();
    }

    @RequestMapping(value={"/treeBasAreaWithRoot"})
    @ResponseBody
    public Object treeBasAreaWithRoot(@RequestParam(value="id", defaultValue="0") Long id) {
        List<ComBoxTreeNode> treelist = this.basareaService.treeBasArea(id);
        if (id.intValue() != 0) {
            return treelist;
        }
        ComBoxTreeNode root = new ComBoxTreeNode();
        root.setId("0");
        root.setText("\u6839\u8282\u70b9");
        root.setChecked(false);
        root.setChildren(treelist);
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        list.add(root);
        return list;
    }

    @RequestMapping(value={"/treeBasArea"})
    @ResponseBody
    public Object treeBasArea(@RequestParam(value="pid", defaultValue="0") Long pid) {
        return this.basareaService.treeBasArea(pid);
    }

    @RequestMapping(value={"/treeBasAreaAnsy"})
    @ResponseBody
    public Object listBasArea(@RequestParam(value="id", defaultValue="0") Long id) {
        if (id == 0L) {
            List<ComBoxTreeNode> treelist = this.basareaService.treeBasAreaAnsy(id);
            ComBoxTreeNode root = new ComBoxTreeNode();
            root.setId("0");
            root.setText("\u6839\u8282\u70b9");
            root.setChecked(false);
            root.setChildren(treelist);
            root.setState("open");
            ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
            list.add(root);
            return list;
        }
        return this.basareaService.treeBasAreaAnsy(id);
    }

    @RequestMapping(value={"/delBasAreaAndChild"})
    @ResponseBody
    public Object delBasAreaAndChild(Long id) {
        this.basareaService.delBasAreaAndChild(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/queryTreeByProvince"})
    @ResponseBody
    public Object queryTreeByProvince(@RequestParam(value="id", defaultValue="0") Long id) {
        if (id == 0L) {
            List<ComBoxTreeNode> treelist = this.basareaService.queryTreeByProvince(id);
            ComBoxTreeNode root = new ComBoxTreeNode();
            root.setId("0");
            root.setText("\u6839\u8282\u70b9");
            root.setChecked(false);
            root.setChildren(treelist);
            root.setState("open");
            ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
            list.add(root);
            return list;
        }
        return this.basareaService.treeBasAreaAnsy(id);
    }

    @RequestMapping(value={"/getCityByProvince"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getCityByProvince(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order, String pid) {
        return this.basareaService.getCityByProvince(search, page, rows, sort, order, pid);
    }
}

