/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.common.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.ustc.base.common.util.SysUtils;
import java.awt.FontMetrics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import org.apache.commons.codec.binary.Base64;

public class PdfWaterMark {
    private static int interval = -150;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waterMark(String inputFile, String outputFile, String waterMarkName) {
        PdfReader reader = null;
        PdfStamper stamper = null;
        try {
            PdfContentByte under;
            reader = new PdfReader(inputFile);
            stamper = new PdfStamper(reader, (OutputStream)new FileOutputStream(outputFile));
            BaseFont base = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)true);
            Rectangle pageRect = null;
            PdfGState gs = new PdfGState();
            gs.setFillOpacity(0.7f);
            gs.setStrokeOpacity(0.7f);
            int total = reader.getNumberOfPages() + 1;
            JLabel label = new JLabel();
            int textH = 0;
            int textW = 0;
            label.setText(waterMarkName);
            FontMetrics metrics = label.getFontMetrics(label.getFont());
            textH = metrics.getHeight();
            textW = metrics.stringWidth(label.getText());
            for (int i = 1; i < total; ++i) {
                pageRect = reader.getPageSizeWithRotation(i);
                under = stamper.getOverContent(i);
                under.saveState();
                under.setGState(gs);
                under.beginText();
                under.setFontAndSize(base, 20.0f);
                int height = 200;
                while ((float)height < pageRect.getHeight()) {
                    int width = 200;
                    while ((float)width < pageRect.getWidth() + (float)textW) {
                        width += 400;
                    }
                    height += 200;
                }
                under.endText();
            }
            PdfGState gs1 = new PdfGState();
            gs1.setFillOpacity(0.5f);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)SysUtils.genQRCode(waterMarkName), "gif", out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Image img = Image.getInstance((byte[])out.toByteArray());
            img.setAbsolutePosition(450.0f, 770.0f);
            img.scaleAbsolute(30.0f, 30.0f);
            int pageSize = reader.getNumberOfPages();
            for (int i = 1; i < total; ++i) {
                pageRect = reader.getPageSizeWithRotation(i);
                under = stamper.getOverContent(i);
                under.saveState();
                under.setGState(gs);
                under.beginText();
                under.setFontAndSize(base, 20.0f);
                img.setAbsolutePosition(pageRect.getWidth() - 50.0f, pageRect.getHeight() - 50.0f);
                under.setGState(gs1);
                under.addImage(img);
            }
            stamper.close();
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stamper != null) {
                try {
                    stamper.close();
                }
                catch (DocumentException | IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static void addPdfImgMark(String InPdfFile, String outPdfFile, String markImagePath, int imgWidth, int imgHeight) throws Exception {
        PdfReader reader = new PdfReader(InPdfFile, "PDF".getBytes());
        PdfStamper stamp = new PdfStamper(reader, (OutputStream)new FileOutputStream(new File(outPdfFile)));
        PdfGState gs1 = new PdfGState();
        gs1.setFillOpacity(0.5f);
        Image img = Image.getInstance((String)markImagePath);
        img.setAbsolutePosition((float)imgWidth, (float)imgHeight);
        img.setRotation(-20);
        img.setRotationDegrees(45.0f);
        int pageSize = reader.getNumberOfPages();
        for (int i = 1; i <= pageSize; ++i) {
            PdfContentByte under = stamp.getUnderContent(i);
            under.setGState(gs1);
            under.addImage(img);
        }
        stamp.close();
    }

    public static void genQRCode(String text) {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.MARGIN, 1);
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(Base64.encodeBase64String((byte[])text.getBytes()), BarcodeFormat.QR_CODE, 250, 250, hints);
            int width = bitMatrix.getWidth();
            int height = bitMatrix.getHeight();
            BufferedImage image = new BufferedImage(width, height, 1);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
                }
            }
            ImageIO.write((RenderedImage)image, "gif", new File("C:/Users/Administrator/Desktop/1.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        String ss = "123456";
        System.out.println(ss.substring(ss.indexOf("2345") + 4));
        String filePath = "E:\\\u9879\u76ee\u6587\u6863\\\u6ee8\u6e56\u57ce\u5e02\u6295\u8d44\\\u5de2\u6e56\u57ce\u5e02\u5efa\u8bbe\u6295\u8d44\u6709\u9650\u516c\u53f8\u6587\u4ef6\u53d1\u6587\u7a3f\u7eb8.xsn";
        String command = "\"D:\\Program Files\\7-Zip\\7z.exe\" x " + filePath + " -oE:\\\u9879\u76ee\u6587\u6863\\\u6ee8\u6e56\u57ce\u5e02\u6295\u8d44\\test ";
        System.out.println(command);
        System.out.println(PdfWaterMark.execCommand(command));
        System.out.println("1111");
    }

    public static String execCommand(String command) {
        String line = "";
        StringBuilder sb = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(command).getInputStream()));){
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line + "\r\n");
            }
        }
        catch (IOException e) {
            return "Invalid command.";
        }
        return sb.toString();
    }
}

