/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.common.util;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.entity.enmus.ExcelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUtils {
    private static Logger log = LoggerFactory.getLogger(FileUtils.class);
    public static final int BIG_DATA_EXPORT_MIN = 50000;
    public static final int BIG_DATA_EXPORT_MAX = 2000000;
    public static HashSet<String> transClassSet = new HashSet();

    public static void exportExcel(List<?> list, String title, String sheetName, Class<?> pojoClass, String fileName, boolean isCreateHeader, HttpServletResponse response) {
        ExportParams exportParams = new ExportParams(title, sheetName);
        exportParams.setCreateHeadRows(isCreateHeader);
        FileUtils.defaultExport(list, pojoClass, fileName, response, title, sheetName);
    }

    public static void exportExcel(List<?> list, String title, String sheetName, Class<?> pojoClass, String fileName, HttpServletResponse response) {
        long startTime = System.currentTimeMillis();
        if (!transClassSet.contains(String.valueOf(pojoClass))) {
            FileUtils.initProperties(pojoClass);
            transClassSet.add(String.valueOf(pojoClass));
        }
        FileUtils.defaultExport(list, pojoClass, fileName, response, title, sheetName);
        log.info("\u6b64\u6587\u4ef6[{}]\u5bfc\u51fa\u8017\u65f6\uff1a{}ms", (Object)fileName, (Object)(System.currentTimeMillis() - startTime));
    }

    public static void exportExcel(List<Map<String, Object>> list, String fileName, HttpServletResponse response) {
        FileUtils.defaultExport(list, fileName, response);
    }

    private static void defaultExport(List<?> list, Class<?> pojoClass, String fileName, HttpServletResponse response, String title, String sheetName) {
        Workbook workbook = null;
        ExportParams exportParams = new ExportParams(title, sheetName);
        if (list != null && list.size() > 2000000) {
            FileUtils.sizeBeyondError(response);
            return;
        }
        workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(title, sheetName), pojoClass, list);
        if (workbook == null) {
            return;
        }
        FileUtils.downLoadExcel(fileName, response, workbook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downLoadExcel(String fileName, HttpServletResponse response, Workbook workbook) {
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json");
            try {
                response.getWriter().println("{\"code\":597,\"message\":\"export error!\",\"data\":\"\"}");
                response.getWriter().flush();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            finally {
                FileUtils.closeIo(response);
            }
        }
    }

    private static void sizeBeyondError(HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        try {
            response.getWriter().println("{\"code\":599,\"message\":\"\u6587\u4ef6\u8fc7\u5927!\",\"data\":\"\"}");
            response.getWriter().flush();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            FileUtils.closeIo(response);
        }
    }

    private static void defaultExport(List<Map<String, Object>> list, String fileName, HttpServletResponse response) {
        Workbook workbook = ExcelExportUtil.exportExcel(list, (String)ExcelType.HSSF.name());
        if (workbook != null) {
            // empty if block
        }
        FileUtils.downLoadExcel(fileName, response, workbook);
    }

    public static <T> List<T> importExcel(String filePath, Integer titleRows, Integer headerRows, Class<T> pojoClass) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return null;
        }
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        List list = null;
        try {
            list = ExcelImportUtil.importExcel((File)new File(filePath), pojoClass, (ImportParams)params);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            System.out.println("\u6a21\u7248\u4e3a\u7a7a");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static <T> List<T> importExcel(MultipartFile file, Integer titleRows, Integer headerRows, Class<T> pojoClass) {
        if (file == null) {
            return null;
        }
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        List list = null;
        try {
            list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), pojoClass, (ImportParams)params);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            System.out.println("\u6587\u4ef6\u4e3a\u7a7a");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static synchronized void initProperties(Class cl) {
        try {
            Field[] fields;
            for (Field field : fields = cl.getDeclaredFields()) {
                JsonFormat jsonFormat;
                if (!field.isAnnotationPresent(Excel.class)) continue;
                field.setAccessible(true);
                Excel excel = field.getAnnotation(Excel.class);
                InvocationHandler h = Proxy.getInvocationHandler(excel);
                Field hField = h.getClass().getDeclaredField("memberValues");
                hField.setAccessible(true);
                Map memberValues = (Map)hField.get(h);
                if (!field.isAnnotationPresent(JsonFormat.class) || !StringUtils.isNotEmpty((CharSequence)(jsonFormat = field.getAnnotation(JsonFormat.class)).pattern())) continue;
                memberValues.put("format", jsonFormat.pattern());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void closeIo(HttpServletResponse response) {
        try {
            if (response.getWriter() != null) {
                response.getWriter().close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

