/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.common.util;

import com.alibaba.druid.DbType;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.JdbcConstants;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.SysUtils;
import com.ustc.gen.util.FreeMarkerUtil;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DataSourceutil {
    @Autowired
    private DruidDataSource dataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, Object>> getColunms(String sql) {
        LinkedHashMap<String, Map<String, Object>> list = new LinkedHashMap<String, Map<String, Object>>();
        DruidPooledConnection connect = null;
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData rmd = null;
        try {
            connect = this.dataSource.getConnection();
            stmt = connect.createStatement();
            sql = sql.replaceAll("(=|<|>|<=|>=|like)\\s*:\\w+\\b", " is null ");
            sql = sql.replaceAll("(=|<|>|<=|>=|)\\s*\\$\\{.+\\}", " is null ");
            HashMap<String, LoginUser> params = new HashMap<String, LoginUser>(2);
            params.put("loginuser", SysUtils.getLoginUser());
            sql = FreeMarkerUtil.instance().genString(sql, params);
            rs = stmt.executeQuery(sql);
            rmd = rs.getMetaData();
            for (int i = 1; i <= rmd.getColumnCount(); ++i) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("name", rmd.getColumnName(i));
                map.put("type", rmd.getColumnType(i));
                map.put("precision", rmd.getPrecision(i));
                list.put(rmd.getColumnName(i), map);
            }
            stmt.close();
            connect.close();
            LinkedHashMap<String, Map<String, Object>> linkedHashMap = list;
            return linkedHashMap;
        }
        catch (Exception e) {
            LinkedHashMap<String, Map<String, Object>> linkedHashMap = list;
            return linkedHashMap;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connect != null) {
                try {
                    connect.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static List<String> getColunms2(String sql) {
        List stmtList = SQLUtils.parseStatements((String)sql, (DbType)JdbcConstants.MYSQL);
        for (int i = 0; i < stmtList.size(); ++i) {
            SQLStatement stmt = (SQLStatement)stmtList.get(i);
            MySqlSchemaStatVisitor visitor = new MySqlSchemaStatVisitor();
            stmt.accept((SQLASTVisitor)visitor);
            System.out.println("Manipulation : " + visitor.getTables());
            System.out.println("fields : " + visitor.getColumns());
        }
        return null;
    }

    public static void main(String[] args) {
        String sql = " select * from (SELECT\n\tto_number( t.people_id ) people_id,\n\tgetaccountname ( people_id ) AS NAME_TEXT,\n\tb.GWMC AS JOBNAME_TEXT\nFROM\n\t(\n\tSELECT\n\t\ts.*,\n\t\tregexp_substr( s.NAME, '[^,]+', 1, LEVEL ) people_id\n\tFROM\n\t\tPM_PLOT_PEOPLE s\n\tWHERE\n\t\ts.is_use = 'Y'\n\t\tAND s.NAME IS NOT NULL\n\t\tAND upper( s.PROJECT_ID ) = 1000820 CONNECT BY LEVEL <= regexp_count ( s.NAME, ',' ) + 1\n\t\tAND s.PROJECT_PEOPLES_ID = PRIOR s.PROJECT_PEOPLES_ID\n\t\tAND PRIOR dbms_random.value IS NOT NULL\n  ) t\n  LEFT JOIN PM_PERSON b ON TO_CHAR( b.ID ) = t.JOBNAME UNION\nSELECT\n  m.project_mgr,\n  getaccountname ( m.project_mgr ) NAME_TEXT,\n  '\u9879\u76ee\u7ecf\u7406' JOBNAME_TEXT\nFROM\n  B_PM_PROJECT m\nWHERE\n  m.PROJECT_ID = 1000820  )p where 1=1\n and  (  upper(p.JOBNAME_TEXT ) like '%\u9879\u76ee\u7ecf\u7406%' )";
        DataSourceutil.getColunms2(sql);
    }
}

