/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.common.spring.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class MaxIdHelper {
    private static ThreadLocal<Boolean> getCodeStarted = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Set<String>> threadLockedKey = new ThreadLocal();
    private static volatile Map<String, ReentrantLock> globalLocks = new HashMap<String, ReentrantLock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lock(String orgCode, String tableName, String codeName) {
        String lockKey = orgCode + "|" + tableName + "|" + codeName;
        ReentrantLock curLock = null;
        Map<String, ReentrantLock> map = globalLocks;
        synchronized (map) {
            curLock = globalLocks.get(lockKey);
            if (curLock == null) {
                curLock = new ReentrantLock();
                globalLocks.put(lockKey, curLock);
            }
        }
        if (threadLockedKey.get() == null) {
            threadLockedKey.set(new HashSet());
        }
        if (!curLock.isHeldByCurrentThread()) {
            try {
                curLock.tryLock(180L, TimeUnit.SECONDS);
                threadLockedKey.get().add(lockKey);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("\u83b7\u53d6\u6d41\u6c34\u53f7\u65f6\u52a0\u9501\u5931\u8d25\uff01\u53ef\u80fd\u5b58\u5728\u7a0b\u5e8f\u5f02\u5e38");
            }
        }
        if (!getCodeStarted.get().booleanValue()) {
            getCodeStarted.set(true);
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                    public void afterCompletion(int status) {
                        for (String key : (Set)threadLockedKey.get()) {
                            ReentrantLock lock = (ReentrantLock)globalLocks.get(key);
                            lock.unlock();
                        }
                        ((Set)threadLockedKey.get()).clear();
                        getCodeStarted.set(false);
                    }
                });
            }
        }
    }
}

