/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.common.spring;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ustc.base.common.spring.SystemControllerLog;
import com.ustc.base.common.spring.SystemServiceLog;
import com.ustc.base.common.spring.ThirdPartyInterfaceLog;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.entity.BasSysOptlog;
import com.ustc.base.service.BasSysOptlogService;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class SystemLogAspect {
    @Autowired
    private BasSysOptlogService optlogService;
    private static final Logger logger = LoggerFactory.getLogger(SystemLogAspect.class);

    @Pointcut(value="@annotation(com.ustc.base.common.spring.SystemServiceLog)")
    public void serviceAspect() {
    }

    @Pointcut(value="@annotation(com.ustc.base.common.spring.SystemControllerLog)")
    public void controllerAspect() {
    }

    @Pointcut(value="@annotation(com.ustc.base.common.spring.ThirdPartyInterfaceLog)")
    public void ThirdPartyInterfaceLog() {
    }

    @Before(value="controllerAspect()")
    public void doBefore(JoinPoint joinPoint) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        HttpSession session = request.getSession();
        LoginUser user = (LoginUser)session.getAttribute("LOGIN_USER");
        try {
            BasSysOptlog optlog = new BasSysOptlog();
            if (user != null) {
                optlog.setOperateAccount(user.getAccountName());
            }
            optlog.setOperateIp(SysUtils.getIpAddr(request));
            optlog.setOperateMethod(joinPoint.getTarget().getClass().getSimpleName() + "." + joinPoint.getSignature().getName() + "()");
            optlog.setOperateName(SystemLogAspect.getControllerMethodDescription(joinPoint));
            optlog.setOperateTime(new Date());
            optlog.setOperateResult("Y");
            JSONObject json = JSON.parseObject((String)JSON.toJSONString((Object)request.getParameterMap()));
            json.remove((Object)"passWord");
            optlog.setOperateDetail("\u5730\u5740:" + request.getRequestURI() + " \u53c2\u6570:" + json.toJSONString());
            this.optlogService.saveBasSysOptlog(optlog);
            String str = JSONObject.toJSONString((Object)optlog);
            logger.info("\u64cd\u4f5c\u4fe1\u606f:{}", (Object)str);
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage());
        }
    }

    @AfterThrowing(pointcut="controllerAspect()||ThirdPartyInterfaceLog()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Throwable e) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        HttpSession session = request.getSession();
        LoginUser user = (LoginUser)session.getAttribute("LOGIN_USER");
        try {
            BasSysOptlog optlog = new BasSysOptlog();
            optlog.setOperateAccount(user.getAccountName());
            optlog.setOperateIp(SysUtils.getIpAddr(request));
            optlog.setOperateMethod(joinPoint.getTarget().getClass().getSimpleName() + "." + joinPoint.getSignature().getName() + "()");
            optlog.setOperateName(SystemLogAspect.getControllerMethodDescription(joinPoint));
            optlog.setOperateTime(new Date());
            optlog.setOperateResult("N");
            JSONObject json = JSON.parseObject((String)JSON.toJSONString((Object)request.getParameterMap()));
            json.remove((Object)"passWord");
            optlog.setOperateDetail("\u5730\u5740:" + request.getRequestURI() + "\n \u53c2\u6570:" + json.toJSONString() + "\n \u5f02\u5e38\u4fe1\u606f:" + SystemLogAspect.getThrowableStrRep(e).toString());
            this.optlogService.saveBasSysOptlog(optlog);
        }
        catch (Exception ex) {
            logger.error("==\u5f02\u5e38\u901a\u77e5\u5f02\u5e38==");
            logger.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)ex.getMessage());
        }
    }

    @AfterThrowing(pointcut="ThirdPartyInterfaceLog()", throwing="e")
    public void doAfterThirdPartyInterfaceThrowing(JoinPoint joinPoint, Throwable e) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        HttpSession session = request.getSession();
        LoginUser user = (LoginUser)session.getAttribute("LOGIN_USER");
        try {
            BasSysOptlog optlog = new BasSysOptlog();
            optlog.setOperateAccount(user.getAccountName());
            optlog.setOperateIp(SysUtils.getIpAddr(request));
            optlog.setOperateMethod(joinPoint.getTarget().getClass().getSimpleName() + "." + joinPoint.getSignature().getName() + "()");
            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
            Method method = methodSignature.getMethod();
            ThirdPartyInterfaceLog annotation = method.getAnnotation(ThirdPartyInterfaceLog.class);
            optlog.setOperateName(annotation.description());
            optlog.setOperateTime(new Date());
            optlog.setOperateResult("N");
            JSONObject json = JSON.parseObject((String)JSON.toJSONString((Object)request.getParameterMap()));
            json.remove((Object)"passWord");
            optlog.setOperateDetail("\u5730\u5740:" + request.getRequestURI() + "\n \u53c2\u6570:" + json.toJSONString() + "\n \u5f02\u5e38\u4fe1\u606f:" + SystemLogAspect.getThrowableStrRep(e).toString());
            this.optlogService.saveBasSysOptlog(optlog);
        }
        catch (Exception ex) {
            logger.error("==\u5f02\u5e38\u901a\u77e5\u5f02\u5e38==");
            logger.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)ex.getMessage());
        }
    }

    @AfterReturning(pointcut="ThirdPartyInterfaceLog()", returning="res")
    public void AfterReturning(JoinPoint joinPoint, Object res) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        HttpSession session = request.getSession();
        LoginUser user = (LoginUser)session.getAttribute("LOGIN_USER");
        try {
            BasSysOptlog optlog = new BasSysOptlog();
            optlog.setOperateAccount(user.getAccountName());
            optlog.setOperateIp(SysUtils.getIpAddr(request));
            optlog.setOperateMethod(joinPoint.getTarget().getClass().getSimpleName() + "." + joinPoint.getSignature().getName() + "()");
            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
            Method method = methodSignature.getMethod();
            ThirdPartyInterfaceLog annotation = method.getAnnotation(ThirdPartyInterfaceLog.class);
            optlog.setOperateName(annotation.description());
            optlog.setOperateTime(new Date());
            optlog.setOperateResult("Y");
            JSONObject json = JSON.parseObject((String)JSON.toJSONString((Object)request.getParameterMap()));
            json.remove((Object)"passWord");
            optlog.setOperateDetail("\u5730\u5740:" + request.getRequestURI() + "\n \u53c2\u6570:" + json.toJSONString() + "\n \u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)res));
            this.optlogService.saveBasSysOptlog(optlog);
        }
        catch (Exception ex) {
            logger.error("==\u63a5\u53e3\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38==");
            logger.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)ex.getMessage());
        }
    }

    public static String getServiceMthodDescription(JoinPoint joinPoint) throws Exception {
        String targetName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] arguments = joinPoint.getArgs();
        String className = System.getProperty(targetName);
        Class<?> targetClass = Class.forName(className);
        Method[] methods = targetClass.getMethods();
        String description = "";
        for (Method method : methods) {
            Class<?>[] clazzs;
            if (!method.getName().equals(methodName) || (clazzs = method.getParameterTypes()).length != arguments.length) continue;
            description = method.getAnnotation(SystemServiceLog.class).description();
            break;
        }
        return description;
    }

    public static String getControllerMethodDescription(JoinPoint joinPoint) throws Exception {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        SystemControllerLog annotation = method.getAnnotation(SystemControllerLog.class);
        return annotation.description();
    }

    public static String getThrowableStrRep(Throwable throwable) throws IOException {
        return throwable.getMessage();
    }
}

