/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.app.controller;

import com.alibaba.fastjson.JSONObject;
import com.ustc.app.common.AppPush;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasDeviceUser;
import com.ustc.base.entity.BasMessage;
import com.ustc.base.service.BasDeviceUserService;
import com.ustc.base.service.BasMessageService;
import com.ustc.gen.entity.GenAppForm;
import com.ustc.gen.service.GenFormService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/app"})
public class AppController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(AppController.class);
    @Autowired
    private BasMessageService basmessageService;
    @Autowired
    private GenFormService genformService;
    @Autowired
    private BasDeviceUserService basDeviceUserService;

    @RequestMapping(value={"/tododd"})
    @ResponseBody
    public Object tododd(HttpServletRequest request, String itemTypeId) {
        PageObject pageobject = new PageObject();
        pageobject = this.basmessageService.PageToDoListApp(this.getLoginUser(request).getAccountid(), itemTypeId, null, null, null);
        LoginUser loginUser = super.getLoginUser(request);
        List<BasMessage> ammsglist = this.basmessageService.getAccountMessageList(loginUser.getAccountid(), SysContent.MSG_ALERT);
        List<BasMessage> awmmsglist = this.basmessageService.findAccountWarningList(loginUser.getAccountid(), null);
        JSONObject msgjson = new JSONObject();
        msgjson.put("msgsize", (Object)pageobject.getTotal());
        msgjson.put("ammsgsize", (Object)ammsglist.size());
        msgjson.put("awmmsgsize", (Object)awmmsglist.size());
        return msgjson;
    }

    @RequestMapping(value={"/tododdfrom"})
    @ResponseBody
    public Object gettodoDdForm(HttpServletRequest request, HttpServletResponse response, String formcode, String mainid) {
        GenAppForm form = null;
        try {
            form = this.genformService.buildAppForm(formcode, mainid, request, response);
        }
        catch (Exception e) {
            logger.error("\u9489\u9489form\u8868\u5355\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        return form;
    }

    @RequestMapping(value={"/pushMsgByUserIds"})
    @ResponseBody
    public Object pushMsgByUserIds(HttpServletRequest request, HttpServletResponse response, String title, String sender, String content, String params, String receiver) {
        JsonMsg msg = new JsonMsg();
        if (StringUtils.isBlank((CharSequence)receiver)) {
            msg.setSuccess(false);
            msg.setMsg("receiver\u4e0d\u80fd\u4e3a\u7a7a");
            return msg;
        }
        if (StringUtils.isBlank((CharSequence)content)) {
            msg.setSuccess(false);
            msg.setMsg("content\u4e0d\u80fd\u4e3a\u7a7a");
            return msg;
        }
        if (StringUtils.isBlank((CharSequence)title)) {
            title = "\u4f60\u6536\u5230\u4e86\u4e00\u6761\u65b0\u7684\u6d88\u606f";
        }
        ArrayList<String> clientIds = new ArrayList<String>(receiver.split(",").length + 1);
        for (String userId : receiver.split(",")) {
            List<BasDeviceUser> devs = this.basDeviceUserService.findByAccountId(Long.parseLong(userId));
            if (devs.isEmpty()) continue;
            clientIds.add(devs.get(0).getClientId());
        }
        AppPush.pushToList(title, content, params, clientIds);
        return msg;
    }
}

