/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.dubbo.filter;

import com.plumelog.core.TraceId;
import com.plumelog.core.util.IdWorker;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.springframework.util.StringUtils;

@Activate(group={"consumer"})
public class TraceIdConsumerFilter
implements Filter {
    private static final String TRACE_ID = "trace_id";
    private final IdWorker worker = new IdWorker(1L, 1L, 1L);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String traceId = (String)TraceId.logTraceID.get();
        if (StringUtils.isEmpty((Object)traceId)) {
            traceId = String.valueOf(this.worker.nextId());
            TraceId.logTraceID.set((Object)traceId);
        }
        invocation.setAttachment(TRACE_ID, traceId);
        return invoker.invoke(invocation);
    }
}

