/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

public class VaultVenmoExperienceContext {
    private String brandName;
    private String shippingPreference;
    private String vaultInstruction;

    public VaultVenmoExperienceContext() {
        this.shippingPreference = "GET_FROM_FILE";
        this.vaultInstruction = "ON_CREATE_PAYMENT_TOKENS";
    }

    public VaultVenmoExperienceContext(String brandName, String shippingPreference, String vaultInstruction) {
        this.brandName = brandName;
        this.shippingPreference = shippingPreference;
        this.vaultInstruction = vaultInstruction;
    }

    @JsonGetter(value="brand_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBrandName() {
        return this.brandName;
    }

    @JsonSetter(value="brand_name")
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    @JsonGetter(value="shipping_preference")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getShippingPreference() {
        return this.shippingPreference;
    }

    @JsonSetter(value="shipping_preference")
    public void setShippingPreference(String shippingPreference) {
        this.shippingPreference = shippingPreference;
    }

    @JsonGetter(value="vault_instruction")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVaultInstruction() {
        return this.vaultInstruction;
    }

    @JsonSetter(value="vault_instruction")
    public void setVaultInstruction(String vaultInstruction) {
        this.vaultInstruction = vaultInstruction;
    }

    public String toString() {
        return "VaultVenmoExperienceContext [brandName=" + this.brandName + ", shippingPreference=" + this.shippingPreference + ", vaultInstruction=" + this.vaultInstruction + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().brandName(this.getBrandName()).shippingPreference(this.getShippingPreference()).vaultInstruction(this.getVaultInstruction());
        return builder;
    }

    public static class Builder {
        private String brandName;
        private String shippingPreference = "GET_FROM_FILE";
        private String vaultInstruction = "ON_CREATE_PAYMENT_TOKENS";

        public Builder brandName(String brandName) {
            this.brandName = brandName;
            return this;
        }

        public Builder shippingPreference(String shippingPreference) {
            this.shippingPreference = shippingPreference;
            return this;
        }

        public Builder vaultInstruction(String vaultInstruction) {
            this.vaultInstruction = vaultInstruction;
            return this;
        }

        public VaultVenmoExperienceContext build() {
            return new VaultVenmoExperienceContext(this.brandName, this.shippingPreference, this.vaultInstruction);
        }
    }
}

