/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.VaultExperienceContext;
import com.paypal.sdk.models.VaultedDigitalWalletShippingDetails;

public class VaultPayPalWalletRequest {
    private String description;
    private VaultedDigitalWalletShippingDetails shipping;
    private Boolean permitMultiplePaymentTokens;
    private String usageType;
    private String customerType;
    private VaultExperienceContext experienceContext;

    public VaultPayPalWalletRequest() {
        this.permitMultiplePaymentTokens = false;
    }

    public VaultPayPalWalletRequest(String description, VaultedDigitalWalletShippingDetails shipping, Boolean permitMultiplePaymentTokens, String usageType, String customerType, VaultExperienceContext experienceContext) {
        this.description = description;
        this.shipping = shipping;
        this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
        this.usageType = usageType;
        this.customerType = customerType;
        this.experienceContext = experienceContext;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonSetter(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonGetter(value="shipping")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public VaultedDigitalWalletShippingDetails getShipping() {
        return this.shipping;
    }

    @JsonSetter(value="shipping")
    public void setShipping(VaultedDigitalWalletShippingDetails shipping) {
        this.shipping = shipping;
    }

    @JsonGetter(value="permit_multiple_payment_tokens")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getPermitMultiplePaymentTokens() {
        return this.permitMultiplePaymentTokens;
    }

    @JsonSetter(value="permit_multiple_payment_tokens")
    public void setPermitMultiplePaymentTokens(Boolean permitMultiplePaymentTokens) {
        this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
    }

    @JsonGetter(value="usage_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUsageType() {
        return this.usageType;
    }

    @JsonSetter(value="usage_type")
    public void setUsageType(String usageType) {
        this.usageType = usageType;
    }

    @JsonGetter(value="customer_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomerType() {
        return this.customerType;
    }

    @JsonSetter(value="customer_type")
    public void setCustomerType(String customerType) {
        this.customerType = customerType;
    }

    @JsonGetter(value="experience_context")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public VaultExperienceContext getExperienceContext() {
        return this.experienceContext;
    }

    @JsonSetter(value="experience_context")
    public void setExperienceContext(VaultExperienceContext experienceContext) {
        this.experienceContext = experienceContext;
    }

    public String toString() {
        return "VaultPayPalWalletRequest [description=" + this.description + ", shipping=" + this.shipping + ", permitMultiplePaymentTokens=" + this.permitMultiplePaymentTokens + ", usageType=" + this.usageType + ", customerType=" + this.customerType + ", experienceContext=" + this.experienceContext + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().description(this.getDescription()).shipping(this.getShipping()).permitMultiplePaymentTokens(this.getPermitMultiplePaymentTokens()).usageType(this.getUsageType()).customerType(this.getCustomerType()).experienceContext(this.getExperienceContext());
        return builder;
    }

    public static class Builder {
        private String description;
        private VaultedDigitalWalletShippingDetails shipping;
        private Boolean permitMultiplePaymentTokens = false;
        private String usageType;
        private String customerType;
        private VaultExperienceContext experienceContext;

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder shipping(VaultedDigitalWalletShippingDetails shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder permitMultiplePaymentTokens(Boolean permitMultiplePaymentTokens) {
            this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
            return this;
        }

        public Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public Builder customerType(String customerType) {
            this.customerType = customerType;
            return this;
        }

        public Builder experienceContext(VaultExperienceContext experienceContext) {
            this.experienceContext = experienceContext;
            return this;
        }

        public VaultPayPalWalletRequest build() {
            return new VaultPayPalWalletRequest(this.description, this.shipping, this.permitMultiplePaymentTokens, this.usageType, this.customerType, this.experienceContext);
        }
    }
}

