/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum UPCType {
    UPCA,
    UPCB,
    UPCC,
    UPCD,
    UPCE,
    UPC2,
    UPC5,
    _UNKNOWN;

    private static TreeMap<String, UPCType> valueMap;
    private String value;

    @JsonCreator
    public static UPCType constructFromString(String toConvert) throws IOException {
        UPCType enumValue = UPCType.fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    public static UPCType fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public static List<String> toValue(List<UPCType> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (UPCType enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        UPCType.UPCA.value = "UPC-A";
        UPCType.UPCB.value = "UPC-B";
        UPCType.UPCC.value = "UPC-C";
        UPCType.UPCD.value = "UPC-D";
        UPCType.UPCE.value = "UPC-E";
        UPCType.UPC2.value = "UPC-2";
        UPCType.UPC5.value = "UPC-5";
        UPCType._UNKNOWN.value = null;
        valueMap.put("UPC-A", UPCA);
        valueMap.put("UPC-B", UPCB);
        valueMap.put("UPC-C", UPCC);
        valueMap.put("UPC-D", UPCD);
        valueMap.put("UPC-E", UPCE);
        valueMap.put("UPC-2", UPC2);
        valueMap.put("UPC-5", UPC5);
    }
}

