/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.SetupTokenRequest;

public class SetupTokensCreateInput {
    private String payPalRequestId;
    private String contentType;
    private SetupTokenRequest body;

    public SetupTokensCreateInput() {
        this.contentType = "application/json";
    }

    public SetupTokensCreateInput(String payPalRequestId, String contentType, SetupTokenRequest body) {
        this.payPalRequestId = payPalRequestId;
        this.contentType = contentType;
        this.body = body;
    }

    @JsonGetter(value="PayPal-Request-Id")
    public String getPayPalRequestId() {
        return this.payPalRequestId;
    }

    @JsonSetter(value="PayPal-Request-Id")
    public void setPayPalRequestId(String payPalRequestId) {
        this.payPalRequestId = payPalRequestId;
    }

    @JsonGetter(value="Content-Type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonSetter(value="Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonGetter(value="body")
    public SetupTokenRequest getBody() {
        return this.body;
    }

    @JsonSetter(value="body")
    public void setBody(SetupTokenRequest body) {
        this.body = body;
    }

    public String toString() {
        return "SetupTokensCreateInput [payPalRequestId=" + this.payPalRequestId + ", contentType=" + this.contentType + ", body=" + this.body + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.payPalRequestId, this.contentType, this.body);
        return builder;
    }

    public static class Builder {
        private String payPalRequestId;
        private String contentType = "application/json";
        private SetupTokenRequest body;

        public Builder() {
        }

        public Builder(String payPalRequestId, String contentType, SetupTokenRequest body) {
            this.payPalRequestId = payPalRequestId;
            this.contentType = contentType;
            this.body = body;
        }

        public Builder payPalRequestId(String payPalRequestId) {
            this.payPalRequestId = payPalRequestId;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder body(SetupTokenRequest body) {
            this.body = body;
            return this;
        }

        public SetupTokensCreateInput build() {
            return new SetupTokensCreateInput(this.payPalRequestId, this.contentType, this.body);
        }
    }
}

