/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.PayPalExperienceLandingPage;
import com.paypal.sdk.models.PayPalExperienceUserAction;
import com.paypal.sdk.models.PayeePaymentMethodPreference;
import com.paypal.sdk.models.ShippingPreference;

public class PayPalWalletExperienceContext {
    private String brandName;
    private String locale;
    private ShippingPreference shippingPreference;
    private String returnUrl;
    private String cancelUrl;
    private PayPalExperienceLandingPage landingPage;
    private PayPalExperienceUserAction userAction;
    private PayeePaymentMethodPreference paymentMethodPreference;

    public PayPalWalletExperienceContext() {
        this.shippingPreference = ShippingPreference.GET_FROM_FILE;
        this.landingPage = PayPalExperienceLandingPage.NO_PREFERENCE;
        this.userAction = PayPalExperienceUserAction.CONTINUE;
        this.paymentMethodPreference = PayeePaymentMethodPreference.UNRESTRICTED;
    }

    public PayPalWalletExperienceContext(String brandName, String locale, ShippingPreference shippingPreference, String returnUrl, String cancelUrl, PayPalExperienceLandingPage landingPage, PayPalExperienceUserAction userAction, PayeePaymentMethodPreference paymentMethodPreference) {
        this.brandName = brandName;
        this.locale = locale;
        this.shippingPreference = shippingPreference;
        this.returnUrl = returnUrl;
        this.cancelUrl = cancelUrl;
        this.landingPage = landingPage;
        this.userAction = userAction;
        this.paymentMethodPreference = paymentMethodPreference;
    }

    @JsonGetter(value="brand_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBrandName() {
        return this.brandName;
    }

    @JsonSetter(value="brand_name")
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    @JsonGetter(value="locale")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocale() {
        return this.locale;
    }

    @JsonSetter(value="locale")
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @JsonGetter(value="shipping_preference")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ShippingPreference getShippingPreference() {
        return this.shippingPreference;
    }

    @JsonSetter(value="shipping_preference")
    public void setShippingPreference(ShippingPreference shippingPreference) {
        this.shippingPreference = shippingPreference;
    }

    @JsonGetter(value="return_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @JsonSetter(value="return_url")
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @JsonGetter(value="cancel_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCancelUrl() {
        return this.cancelUrl;
    }

    @JsonSetter(value="cancel_url")
    public void setCancelUrl(String cancelUrl) {
        this.cancelUrl = cancelUrl;
    }

    @JsonGetter(value="landing_page")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PayPalExperienceLandingPage getLandingPage() {
        return this.landingPage;
    }

    @JsonSetter(value="landing_page")
    public void setLandingPage(PayPalExperienceLandingPage landingPage) {
        this.landingPage = landingPage;
    }

    @JsonGetter(value="user_action")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PayPalExperienceUserAction getUserAction() {
        return this.userAction;
    }

    @JsonSetter(value="user_action")
    public void setUserAction(PayPalExperienceUserAction userAction) {
        this.userAction = userAction;
    }

    @JsonGetter(value="payment_method_preference")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PayeePaymentMethodPreference getPaymentMethodPreference() {
        return this.paymentMethodPreference;
    }

    @JsonSetter(value="payment_method_preference")
    public void setPaymentMethodPreference(PayeePaymentMethodPreference paymentMethodPreference) {
        this.paymentMethodPreference = paymentMethodPreference;
    }

    public String toString() {
        return "PayPalWalletExperienceContext [brandName=" + this.brandName + ", locale=" + this.locale + ", shippingPreference=" + (Object)((Object)this.shippingPreference) + ", returnUrl=" + this.returnUrl + ", cancelUrl=" + this.cancelUrl + ", landingPage=" + (Object)((Object)this.landingPage) + ", userAction=" + (Object)((Object)this.userAction) + ", paymentMethodPreference=" + (Object)((Object)this.paymentMethodPreference) + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().brandName(this.getBrandName()).locale(this.getLocale()).shippingPreference(this.getShippingPreference()).returnUrl(this.getReturnUrl()).cancelUrl(this.getCancelUrl()).landingPage(this.getLandingPage()).userAction(this.getUserAction()).paymentMethodPreference(this.getPaymentMethodPreference());
        return builder;
    }

    public static class Builder {
        private String brandName;
        private String locale;
        private ShippingPreference shippingPreference = ShippingPreference.GET_FROM_FILE;
        private String returnUrl;
        private String cancelUrl;
        private PayPalExperienceLandingPage landingPage = PayPalExperienceLandingPage.NO_PREFERENCE;
        private PayPalExperienceUserAction userAction = PayPalExperienceUserAction.CONTINUE;
        private PayeePaymentMethodPreference paymentMethodPreference = PayeePaymentMethodPreference.UNRESTRICTED;

        public Builder brandName(String brandName) {
            this.brandName = brandName;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public Builder shippingPreference(ShippingPreference shippingPreference) {
            this.shippingPreference = shippingPreference;
            return this;
        }

        public Builder returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        public Builder cancelUrl(String cancelUrl) {
            this.cancelUrl = cancelUrl;
            return this;
        }

        public Builder landingPage(PayPalExperienceLandingPage landingPage) {
            this.landingPage = landingPage;
            return this;
        }

        public Builder userAction(PayPalExperienceUserAction userAction) {
            this.userAction = userAction;
            return this;
        }

        public Builder paymentMethodPreference(PayeePaymentMethodPreference paymentMethodPreference) {
            this.paymentMethodPreference = paymentMethodPreference;
            return this;
        }

        public PayPalWalletExperienceContext build() {
            return new PayPalWalletExperienceContext(this.brandName, this.locale, this.shippingPreference, this.returnUrl, this.cancelUrl, this.landingPage, this.userAction, this.paymentMethodPreference);
        }
    }
}

