/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.PayPalWalletCustomerRequest;
import com.paypal.sdk.models.PayPalWalletVaultInstruction;

public class PayPalWalletAttributes {
    private PayPalWalletCustomerRequest customer;
    private PayPalWalletVaultInstruction vault;

    public PayPalWalletAttributes() {
    }

    public PayPalWalletAttributes(PayPalWalletCustomerRequest customer, PayPalWalletVaultInstruction vault) {
        this.customer = customer;
        this.vault = vault;
    }

    @JsonGetter(value="customer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PayPalWalletCustomerRequest getCustomer() {
        return this.customer;
    }

    @JsonSetter(value="customer")
    public void setCustomer(PayPalWalletCustomerRequest customer) {
        this.customer = customer;
    }

    @JsonGetter(value="vault")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PayPalWalletVaultInstruction getVault() {
        return this.vault;
    }

    @JsonSetter(value="vault")
    public void setVault(PayPalWalletVaultInstruction vault) {
        this.vault = vault;
    }

    public String toString() {
        return "PayPalWalletAttributes [customer=" + this.customer + ", vault=" + this.vault + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().customer(this.getCustomer()).vault(this.getVault());
        return builder;
    }

    public static class Builder {
        private PayPalWalletCustomerRequest customer;
        private PayPalWalletVaultInstruction vault;

        public Builder customer(PayPalWalletCustomerRequest customer) {
            this.customer = customer;
            return this;
        }

        public Builder vault(PayPalWalletVaultInstruction vault) {
            this.vault = vault;
            return this;
        }

        public PayPalWalletAttributes build() {
            return new PayPalWalletAttributes(this.customer, this.vault);
        }
    }
}

