/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.OrderTrackerRequest;

public class OrdersTrackCreateInput {
    private String id;
    private String contentType;
    private OrderTrackerRequest body;
    private String payPalAuthAssertion;

    public OrdersTrackCreateInput() {
        this.contentType = "application/json";
    }

    public OrdersTrackCreateInput(String id, String contentType, OrderTrackerRequest body, String payPalAuthAssertion) {
        this.id = id;
        this.contentType = contentType;
        this.body = body;
        this.payPalAuthAssertion = payPalAuthAssertion;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonGetter(value="Content-Type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonSetter(value="Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonGetter(value="body")
    public OrderTrackerRequest getBody() {
        return this.body;
    }

    @JsonSetter(value="body")
    public void setBody(OrderTrackerRequest body) {
        this.body = body;
    }

    @JsonGetter(value="PayPal-Auth-Assertion")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPayPalAuthAssertion() {
        return this.payPalAuthAssertion;
    }

    @JsonSetter(value="PayPal-Auth-Assertion")
    public void setPayPalAuthAssertion(String payPalAuthAssertion) {
        this.payPalAuthAssertion = payPalAuthAssertion;
    }

    public String toString() {
        return "OrdersTrackCreateInput [id=" + this.id + ", contentType=" + this.contentType + ", body=" + this.body + ", payPalAuthAssertion=" + this.payPalAuthAssertion + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.contentType, this.body).payPalAuthAssertion(this.getPayPalAuthAssertion());
        return builder;
    }

    public static class Builder {
        private String id;
        private String contentType = "application/json";
        private OrderTrackerRequest body;
        private String payPalAuthAssertion;

        public Builder() {
        }

        public Builder(String id, String contentType, OrderTrackerRequest body) {
            this.id = id;
            this.contentType = contentType;
            this.body = body;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder body(OrderTrackerRequest body) {
            this.body = body;
            return this;
        }

        public Builder payPalAuthAssertion(String payPalAuthAssertion) {
            this.payPalAuthAssertion = payPalAuthAssertion;
            return this;
        }

        public OrdersTrackCreateInput build() {
            return new OrdersTrackCreateInput(this.id, this.contentType, this.body, this.payPalAuthAssertion);
        }
    }
}

