/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.OrderRequest;

public class OrdersCreateInput {
    private String contentType;
    private OrderRequest body;
    private String payPalRequestId;
    private String payPalPartnerAttributionId;
    private String payPalClientMetadataId;
    private String prefer;

    public OrdersCreateInput() {
        this.contentType = "application/json";
        this.prefer = "return=minimal";
    }

    public OrdersCreateInput(String contentType, OrderRequest body, String payPalRequestId, String payPalPartnerAttributionId, String payPalClientMetadataId, String prefer) {
        this.contentType = contentType;
        this.body = body;
        this.payPalRequestId = payPalRequestId;
        this.payPalPartnerAttributionId = payPalPartnerAttributionId;
        this.payPalClientMetadataId = payPalClientMetadataId;
        this.prefer = prefer;
    }

    @JsonGetter(value="Content-Type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonSetter(value="Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonGetter(value="body")
    public OrderRequest getBody() {
        return this.body;
    }

    @JsonSetter(value="body")
    public void setBody(OrderRequest body) {
        this.body = body;
    }

    @JsonGetter(value="PayPal-Request-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPayPalRequestId() {
        return this.payPalRequestId;
    }

    @JsonSetter(value="PayPal-Request-Id")
    public void setPayPalRequestId(String payPalRequestId) {
        this.payPalRequestId = payPalRequestId;
    }

    @JsonGetter(value="PayPal-Partner-Attribution-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPayPalPartnerAttributionId() {
        return this.payPalPartnerAttributionId;
    }

    @JsonSetter(value="PayPal-Partner-Attribution-Id")
    public void setPayPalPartnerAttributionId(String payPalPartnerAttributionId) {
        this.payPalPartnerAttributionId = payPalPartnerAttributionId;
    }

    @JsonGetter(value="PayPal-Client-Metadata-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPayPalClientMetadataId() {
        return this.payPalClientMetadataId;
    }

    @JsonSetter(value="PayPal-Client-Metadata-Id")
    public void setPayPalClientMetadataId(String payPalClientMetadataId) {
        this.payPalClientMetadataId = payPalClientMetadataId;
    }

    @JsonGetter(value="Prefer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return this.prefer;
    }

    @JsonSetter(value="Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    public String toString() {
        return "OrdersCreateInput [contentType=" + this.contentType + ", body=" + this.body + ", payPalRequestId=" + this.payPalRequestId + ", payPalPartnerAttributionId=" + this.payPalPartnerAttributionId + ", payPalClientMetadataId=" + this.payPalClientMetadataId + ", prefer=" + this.prefer + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.contentType, this.body).payPalRequestId(this.getPayPalRequestId()).payPalPartnerAttributionId(this.getPayPalPartnerAttributionId()).payPalClientMetadataId(this.getPayPalClientMetadataId()).prefer(this.getPrefer());
        return builder;
    }

    public static class Builder {
        private String contentType = "application/json";
        private OrderRequest body;
        private String payPalRequestId;
        private String payPalPartnerAttributionId;
        private String payPalClientMetadataId;
        private String prefer = "return=minimal";

        public Builder() {
        }

        public Builder(String contentType, OrderRequest body) {
            this.contentType = contentType;
            this.body = body;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder body(OrderRequest body) {
            this.body = body;
            return this;
        }

        public Builder payPalRequestId(String payPalRequestId) {
            this.payPalRequestId = payPalRequestId;
            return this;
        }

        public Builder payPalPartnerAttributionId(String payPalPartnerAttributionId) {
            this.payPalPartnerAttributionId = payPalPartnerAttributionId;
            return this;
        }

        public Builder payPalClientMetadataId(String payPalClientMetadataId) {
            this.payPalClientMetadataId = payPalClientMetadataId;
            return this;
        }

        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        public OrdersCreateInput build() {
            return new OrdersCreateInput(this.contentType, this.body, this.payPalRequestId, this.payPalPartnerAttributionId, this.payPalClientMetadataId, this.prefer);
        }
    }
}

