/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.Money;
import com.paypal.sdk.models.UniversalProductCode;

public class LineItem {
    private String name;
    private String quantity;
    private String description;
    private String sku;
    private String url;
    private String imageUrl;
    private UniversalProductCode upc;
    private Money unitAmount;
    private Money tax;
    private String commodityCode;
    private Money discountAmount;
    private Money totalAmount;
    private String unitOfMeasure;

    public LineItem() {
    }

    public LineItem(String name, String quantity, String description, String sku, String url, String imageUrl, UniversalProductCode upc, Money unitAmount, Money tax, String commodityCode, Money discountAmount, Money totalAmount, String unitOfMeasure) {
        this.name = name;
        this.quantity = quantity;
        this.description = description;
        this.sku = sku;
        this.url = url;
        this.imageUrl = imageUrl;
        this.upc = upc;
        this.unitAmount = unitAmount;
        this.tax = tax;
        this.commodityCode = commodityCode;
        this.discountAmount = discountAmount;
        this.totalAmount = totalAmount;
        this.unitOfMeasure = unitOfMeasure;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonSetter(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonGetter(value="quantity")
    public String getQuantity() {
        return this.quantity;
    }

    @JsonSetter(value="quantity")
    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonSetter(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonGetter(value="sku")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSku() {
        return this.sku;
    }

    @JsonSetter(value="sku")
    public void setSku(String sku) {
        this.sku = sku;
    }

    @JsonGetter(value="url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUrl() {
        return this.url;
    }

    @JsonSetter(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonGetter(value="image_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getImageUrl() {
        return this.imageUrl;
    }

    @JsonSetter(value="image_url")
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @JsonGetter(value="upc")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public UniversalProductCode getUpc() {
        return this.upc;
    }

    @JsonSetter(value="upc")
    public void setUpc(UniversalProductCode upc) {
        this.upc = upc;
    }

    @JsonGetter(value="unit_amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getUnitAmount() {
        return this.unitAmount;
    }

    @JsonSetter(value="unit_amount")
    public void setUnitAmount(Money unitAmount) {
        this.unitAmount = unitAmount;
    }

    @JsonGetter(value="tax")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTax() {
        return this.tax;
    }

    @JsonSetter(value="tax")
    public void setTax(Money tax) {
        this.tax = tax;
    }

    @JsonGetter(value="commodity_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCommodityCode() {
        return this.commodityCode;
    }

    @JsonSetter(value="commodity_code")
    public void setCommodityCode(String commodityCode) {
        this.commodityCode = commodityCode;
    }

    @JsonGetter(value="discount_amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getDiscountAmount() {
        return this.discountAmount;
    }

    @JsonSetter(value="discount_amount")
    public void setDiscountAmount(Money discountAmount) {
        this.discountAmount = discountAmount;
    }

    @JsonGetter(value="total_amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalAmount() {
        return this.totalAmount;
    }

    @JsonSetter(value="total_amount")
    public void setTotalAmount(Money totalAmount) {
        this.totalAmount = totalAmount;
    }

    @JsonGetter(value="unit_of_measure")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    @JsonSetter(value="unit_of_measure")
    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public String toString() {
        return "LineItem [name=" + this.name + ", quantity=" + this.quantity + ", description=" + this.description + ", sku=" + this.sku + ", url=" + this.url + ", imageUrl=" + this.imageUrl + ", upc=" + this.upc + ", unitAmount=" + this.unitAmount + ", tax=" + this.tax + ", commodityCode=" + this.commodityCode + ", discountAmount=" + this.discountAmount + ", totalAmount=" + this.totalAmount + ", unitOfMeasure=" + this.unitOfMeasure + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.name, this.quantity).description(this.getDescription()).sku(this.getSku()).url(this.getUrl()).imageUrl(this.getImageUrl()).upc(this.getUpc()).unitAmount(this.getUnitAmount()).tax(this.getTax()).commodityCode(this.getCommodityCode()).discountAmount(this.getDiscountAmount()).totalAmount(this.getTotalAmount()).unitOfMeasure(this.getUnitOfMeasure());
        return builder;
    }

    public static class Builder {
        private String name;
        private String quantity;
        private String description;
        private String sku;
        private String url;
        private String imageUrl;
        private UniversalProductCode upc;
        private Money unitAmount;
        private Money tax;
        private String commodityCode;
        private Money discountAmount;
        private Money totalAmount;
        private String unitOfMeasure;

        public Builder() {
        }

        public Builder(String name, String quantity) {
            this.name = name;
            this.quantity = quantity;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder upc(UniversalProductCode upc) {
            this.upc = upc;
            return this;
        }

        public Builder unitAmount(Money unitAmount) {
            this.unitAmount = unitAmount;
            return this;
        }

        public Builder tax(Money tax) {
            this.tax = tax;
            return this;
        }

        public Builder commodityCode(String commodityCode) {
            this.commodityCode = commodityCode;
            return this;
        }

        public Builder discountAmount(Money discountAmount) {
            this.discountAmount = discountAmount;
            return this;
        }

        public Builder totalAmount(Money totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public Builder unitOfMeasure(String unitOfMeasure) {
            this.unitOfMeasure = unitOfMeasure;
            return this;
        }

        public LineItem build() {
            return new LineItem(this.name, this.quantity, this.description, this.sku, this.url, this.imageUrl, this.upc, this.unitAmount, this.tax, this.commodityCode, this.discountAmount, this.totalAmount, this.unitOfMeasure);
        }
    }
}

