/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.ExperienceContext;

public class IDEALPaymentRequest {
    private String name;
    private String countryCode;
    private String bic;
    private ExperienceContext experienceContext;

    public IDEALPaymentRequest() {
    }

    public IDEALPaymentRequest(String name, String countryCode, String bic, ExperienceContext experienceContext) {
        this.name = name;
        this.countryCode = countryCode;
        this.bic = bic;
        this.experienceContext = experienceContext;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonSetter(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonGetter(value="country_code")
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonSetter(value="country_code")
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @JsonGetter(value="bic")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBic() {
        return this.bic;
    }

    @JsonSetter(value="bic")
    public void setBic(String bic) {
        this.bic = bic;
    }

    @JsonGetter(value="experience_context")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ExperienceContext getExperienceContext() {
        return this.experienceContext;
    }

    @JsonSetter(value="experience_context")
    public void setExperienceContext(ExperienceContext experienceContext) {
        this.experienceContext = experienceContext;
    }

    public String toString() {
        return "IDEALPaymentRequest [name=" + this.name + ", countryCode=" + this.countryCode + ", bic=" + this.bic + ", experienceContext=" + this.experienceContext + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.name, this.countryCode).bic(this.getBic()).experienceContext(this.getExperienceContext());
        return builder;
    }

    public static class Builder {
        private String name;
        private String countryCode;
        private String bic;
        private ExperienceContext experienceContext;

        public Builder() {
        }

        public Builder(String name, String countryCode) {
            this.name = name;
            this.countryCode = countryCode;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder bic(String bic) {
            this.bic = bic;
            return this;
        }

        public Builder experienceContext(ExperienceContext experienceContext) {
            this.experienceContext = experienceContext;
            return this;
        }

        public IDEALPaymentRequest build() {
            return new IDEALPaymentRequest(this.name, this.countryCode, this.bic, this.experienceContext);
        }
    }
}

