/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum ECIFlag {
    MASTERCARD_NON_3D_SECURE_TRANSACTION,
    MASTERCARD_ATTEMPTED_AUTHENTICATION_TRANSACTION,
    MASTERCARD_FULLY_AUTHENTICATED_TRANSACTION,
    FULLY_AUTHENTICATED_TRANSACTION,
    ATTEMPTED_AUTHENTICATION_TRANSACTION,
    NON_3D_SECURE_TRANSACTION,
    _UNKNOWN;

    private static TreeMap<String, ECIFlag> valueMap;
    private String value;

    @JsonCreator
    public static ECIFlag constructFromString(String toConvert) throws IOException {
        ECIFlag enumValue = ECIFlag.fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    public static ECIFlag fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public static List<String> toValue(List<ECIFlag> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (ECIFlag enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        ECIFlag.MASTERCARD_NON_3D_SECURE_TRANSACTION.value = "MASTERCARD_NON_3D_SECURE_TRANSACTION";
        ECIFlag.MASTERCARD_ATTEMPTED_AUTHENTICATION_TRANSACTION.value = "MASTERCARD_ATTEMPTED_AUTHENTICATION_TRANSACTION";
        ECIFlag.MASTERCARD_FULLY_AUTHENTICATED_TRANSACTION.value = "MASTERCARD_FULLY_AUTHENTICATED_TRANSACTION";
        ECIFlag.FULLY_AUTHENTICATED_TRANSACTION.value = "FULLY_AUTHENTICATED_TRANSACTION";
        ECIFlag.ATTEMPTED_AUTHENTICATION_TRANSACTION.value = "ATTEMPTED_AUTHENTICATION_TRANSACTION";
        ECIFlag.NON_3D_SECURE_TRANSACTION.value = "NON_3D_SECURE_TRANSACTION";
        ECIFlag._UNKNOWN.value = null;
        valueMap.put("MASTERCARD_NON_3D_SECURE_TRANSACTION", MASTERCARD_NON_3D_SECURE_TRANSACTION);
        valueMap.put("MASTERCARD_ATTEMPTED_AUTHENTICATION_TRANSACTION", MASTERCARD_ATTEMPTED_AUTHENTICATION_TRANSACTION);
        valueMap.put("MASTERCARD_FULLY_AUTHENTICATED_TRANSACTION", MASTERCARD_FULLY_AUTHENTICATED_TRANSACTION);
        valueMap.put("FULLY_AUTHENTICATED_TRANSACTION", FULLY_AUTHENTICATED_TRANSACTION);
        valueMap.put("ATTEMPTED_AUTHENTICATION_TRANSACTION", ATTEMPTED_AUTHENTICATION_TRANSACTION);
        valueMap.put("NON_3D_SECURE_TRANSACTION", NON_3D_SECURE_TRANSACTION);
    }
}

