/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.RefundRequest;

public class CapturesRefundInput {
    private String captureId;
    private String contentType;
    private String payPalRequestId;
    private String prefer;
    private String payPalAuthAssertion;
    private RefundRequest body;

    public CapturesRefundInput() {
        this.contentType = "application/json";
        this.prefer = "return=minimal";
    }

    public CapturesRefundInput(String captureId, String contentType, String payPalRequestId, String prefer, String payPalAuthAssertion, RefundRequest body) {
        this.captureId = captureId;
        this.contentType = contentType;
        this.payPalRequestId = payPalRequestId;
        this.prefer = prefer;
        this.payPalAuthAssertion = payPalAuthAssertion;
        this.body = body;
    }

    @JsonGetter(value="capture_id")
    public String getCaptureId() {
        return this.captureId;
    }

    @JsonSetter(value="capture_id")
    public void setCaptureId(String captureId) {
        this.captureId = captureId;
    }

    @JsonGetter(value="Content-Type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonSetter(value="Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonGetter(value="PayPal-Request-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPayPalRequestId() {
        return this.payPalRequestId;
    }

    @JsonSetter(value="PayPal-Request-Id")
    public void setPayPalRequestId(String payPalRequestId) {
        this.payPalRequestId = payPalRequestId;
    }

    @JsonGetter(value="Prefer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return this.prefer;
    }

    @JsonSetter(value="Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    @JsonGetter(value="PayPal-Auth-Assertion")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPayPalAuthAssertion() {
        return this.payPalAuthAssertion;
    }

    @JsonSetter(value="PayPal-Auth-Assertion")
    public void setPayPalAuthAssertion(String payPalAuthAssertion) {
        this.payPalAuthAssertion = payPalAuthAssertion;
    }

    @JsonGetter(value="body")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public RefundRequest getBody() {
        return this.body;
    }

    @JsonSetter(value="body")
    public void setBody(RefundRequest body) {
        this.body = body;
    }

    public String toString() {
        return "CapturesRefundInput [captureId=" + this.captureId + ", contentType=" + this.contentType + ", payPalRequestId=" + this.payPalRequestId + ", prefer=" + this.prefer + ", payPalAuthAssertion=" + this.payPalAuthAssertion + ", body=" + this.body + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.captureId, this.contentType).payPalRequestId(this.getPayPalRequestId()).prefer(this.getPrefer()).payPalAuthAssertion(this.getPayPalAuthAssertion()).body(this.getBody());
        return builder;
    }

    public static class Builder {
        private String captureId;
        private String contentType = "application/json";
        private String payPalRequestId;
        private String prefer = "return=minimal";
        private String payPalAuthAssertion;
        private RefundRequest body;

        public Builder() {
        }

        public Builder(String captureId, String contentType) {
            this.captureId = captureId;
            this.contentType = contentType;
        }

        public Builder captureId(String captureId) {
            this.captureId = captureId;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder payPalRequestId(String payPalRequestId) {
            this.payPalRequestId = payPalRequestId;
            return this;
        }

        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        public Builder payPalAuthAssertion(String payPalAuthAssertion) {
            this.payPalAuthAssertion = payPalAuthAssertion;
            return this;
        }

        public Builder body(RefundRequest body) {
            this.body = body;
            return this;
        }

        public CapturesRefundInput build() {
            return new CapturesRefundInput(this.captureId, this.contentType, this.payPalRequestId, this.prefer, this.payPalAuthAssertion, this.body);
        }
    }
}

