/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk;

import com.paypal.sdk.ApiHelper;
import com.paypal.sdk.ClientCredentialsAuth;
import com.paypal.sdk.CompatibilityFactoryImpl;
import com.paypal.sdk.Configuration;
import com.paypal.sdk.Environment;
import com.paypal.sdk.Server;
import com.paypal.sdk.authentication.ClientCredentialsAuthManager;
import com.paypal.sdk.authentication.ClientCredentialsAuthModel;
import com.paypal.sdk.controllers.OAuthAuthorizationController;
import com.paypal.sdk.controllers.OrdersController;
import com.paypal.sdk.controllers.PaymentsController;
import com.paypal.sdk.controllers.VaultController;
import com.paypal.sdk.http.client.HttpCallback;
import com.paypal.sdk.http.client.HttpClientConfiguration;
import com.paypal.sdk.http.client.ReadonlyHttpClientConfiguration;
import com.paypal.sdk.logging.configuration.ApiLoggingConfiguration;
import com.paypal.sdk.logging.configuration.ReadonlyLoggingConfiguration;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.authentication.Authentication;
import io.apimatic.coreinterfaces.compatibility.CompatibilityFactory;
import io.apimatic.coreinterfaces.http.Callback;
import io.apimatic.coreinterfaces.http.HttpClient;
import io.apimatic.okhttpclient.adapter.OkClient;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class PaypalServerSDKClient
implements Configuration {
    private OrdersController orders;
    private PaymentsController payments;
    private VaultController vault;
    private OAuthAuthorizationController oAuthAuthorization;
    private static final CompatibilityFactory compatibilityFactory = new CompatibilityFactoryImpl();
    private static String userAgent = "PayPal REST API Java SDK, Version: 0.5.1, on OS {os-info}";
    private final Environment environment;
    private final HttpClient httpClient;
    private final ReadonlyHttpClientConfiguration httpClientConfig;
    private final ReadonlyLoggingConfiguration loggingConfig;
    private ClientCredentialsAuthManager clientCredentialsAuthManager;
    private ClientCredentialsAuthModel clientCredentialsAuthModel;
    private Map<String, Authentication> authentications = new HashMap<String, Authentication>();
    private final HttpCallback httpCallback;

    private PaypalServerSDKClient(Environment environment, HttpClient httpClient, ReadonlyHttpClientConfiguration httpClientConfig, ReadonlyLoggingConfiguration loggingConfig, ClientCredentialsAuthModel clientCredentialsAuthModel, HttpCallback httpCallback) {
        this.environment = environment;
        this.httpClient = httpClient;
        this.httpClientConfig = httpClientConfig;
        this.loggingConfig = loggingConfig;
        this.httpCallback = httpCallback;
        this.clientCredentialsAuthModel = clientCredentialsAuthModel;
        this.clientCredentialsAuthManager = new ClientCredentialsAuthManager(clientCredentialsAuthModel);
        this.authentications.put("Oauth2", (Authentication)this.clientCredentialsAuthManager);
        GlobalConfiguration globalConfig = new GlobalConfiguration.Builder().httpClient(httpClient).baseUri(server -> this.getBaseUri((String)server)).compatibilityFactory(compatibilityFactory).authentication(this.authentications).callback((Callback)httpCallback).userAgent(userAgent).loggingConfiguration(((ApiLoggingConfiguration)loggingConfig).getConfiguration()).build();
        this.clientCredentialsAuthManager.applyGlobalConfiguration(globalConfig);
        this.orders = new OrdersController(globalConfig);
        this.payments = new PaymentsController(globalConfig);
        this.vault = new VaultController(globalConfig);
        this.oAuthAuthorization = new OAuthAuthorizationController(globalConfig);
    }

    public static void shutdown() {
        OkClient.shutdown();
    }

    public OrdersController getOrdersController() {
        return this.orders;
    }

    public PaymentsController getPaymentsController() {
        return this.payments;
    }

    public VaultController getVaultController() {
        return this.vault;
    }

    public OAuthAuthorizationController getOAuthAuthorizationController() {
        return this.oAuthAuthorization;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    private HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public ReadonlyHttpClientConfiguration getHttpClientConfig() {
        return this.httpClientConfig;
    }

    @Override
    public ReadonlyLoggingConfiguration getLoggingConfig() {
        return this.loggingConfig;
    }

    @Override
    public ClientCredentialsAuth getClientCredentialsAuth() {
        return this.clientCredentialsAuthManager;
    }

    @Override
    public ClientCredentialsAuthModel getClientCredentialsAuthModel() {
        return this.clientCredentialsAuthModel;
    }

    @Override
    @Deprecated
    public long timeout() {
        return this.httpClientConfig.getTimeout();
    }

    @Override
    public String getBaseUri(Server server) {
        HashMap parameters = new HashMap();
        StringBuilder baseUrl = new StringBuilder(PaypalServerSDKClient.environmentMapper(this.environment, server));
        ApiHelper.appendUrlWithTemplateParameters((StringBuilder)baseUrl, parameters);
        return baseUrl.toString();
    }

    @Override
    public String getBaseUri() {
        return this.getBaseUri(Server.ENUM_DEFAULT);
    }

    public String getBaseUri(String server) {
        return this.getBaseUri(Server.fromString(server));
    }

    private static String environmentMapper(Environment environment, Server server) {
        if (environment.equals((Object)Environment.PRODUCTION) && server.equals((Object)Server.ENUM_DEFAULT)) {
            return "https://api-m.paypal.com";
        }
        if (environment.equals((Object)Environment.SANDBOX) && server.equals((Object)Server.ENUM_DEFAULT)) {
            return "https://api-m.sandbox.paypal.com";
        }
        return "https://api-m.sandbox.paypal.com";
    }

    public String toString() {
        return "PaypalServerSDKClient [environment=" + (Object)((Object)this.environment) + ", httpClientConfig=" + this.httpClientConfig + ", loggingConfig=" + this.loggingConfig + ", authentications=" + this.authentications + "]";
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.environment = this.getEnvironment();
        builder.httpClient = this.getHttpClient();
        builder.clientCredentialsAuth(this.getClientCredentialsAuthModel().toBuilder().build());
        builder.httpCallback = this.httpCallback;
        builder.httpClientConfig(() -> ((HttpClientConfiguration)this.httpClientConfig).newBuilder());
        builder.loggingConfig(() -> ((ApiLoggingConfiguration)this.loggingConfig).newBuilder());
        return builder;
    }

    public static class Builder {
        private Environment environment = Environment.SANDBOX;
        private HttpClient httpClient;
        private ClientCredentialsAuthModel clientCredentialsAuthModel = new ClientCredentialsAuthModel.Builder("", "").build();
        private HttpCallback httpCallback = null;
        private HttpClientConfiguration.Builder httpClientConfigBuilder = new HttpClientConfiguration.Builder();
        private ApiLoggingConfiguration.Builder loggingConfigBuilder = null;

        public Builder clientCredentialsAuth(ClientCredentialsAuthModel clientCredentialsAuthModel) {
            this.clientCredentialsAuthModel = clientCredentialsAuthModel;
            return this;
        }

        public Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        @Deprecated
        public Builder timeout(long timeout) {
            this.httpClientConfigBuilder.timeout(timeout);
            return this;
        }

        public Builder loggingConfig(Consumer<ApiLoggingConfiguration.Builder> action) {
            if (this.loggingConfigBuilder == null) {
                this.loggingConfigBuilder = new ApiLoggingConfiguration.Builder();
            }
            if (this.loggingConfigBuilder.build().getLogger() == null) {
                this.loggingConfigBuilder.useDefaultLogger();
            }
            action.accept(this.loggingConfigBuilder);
            return this;
        }

        public Builder loggingConfig() {
            this.loggingConfigBuilder = new ApiLoggingConfiguration.Builder();
            this.loggingConfigBuilder.useDefaultLogger();
            return this;
        }

        private Builder loggingConfig(Supplier<ApiLoggingConfiguration.Builder> supplier) {
            this.loggingConfigBuilder = supplier.get();
            return this;
        }

        public Builder httpCallback(HttpCallback httpCallback) {
            this.httpCallback = httpCallback;
            return this;
        }

        public Builder httpClientConfig(Consumer<HttpClientConfiguration.Builder> action) {
            action.accept(this.httpClientConfigBuilder);
            return this;
        }

        private Builder httpClientConfig(Supplier<HttpClientConfiguration.Builder> supplier) {
            this.httpClientConfigBuilder = supplier.get();
            return this;
        }

        public PaypalServerSDKClient build() {
            HttpClientConfiguration httpClientConfig = this.httpClientConfigBuilder.build();
            ApiLoggingConfiguration loggingConfig = this.loggingConfigBuilder != null ? this.loggingConfigBuilder.build() : new ApiLoggingConfiguration.Builder().build();
            this.httpClient = new OkClient(httpClientConfig.getConfiguration(), compatibilityFactory);
            return new PaypalServerSDKClient(this.environment, this.httpClient, httpClientConfig, loggingConfig, this.clientCredentialsAuthModel, this.httpCallback);
        }
    }
}

